import java.awt.*;
import java.lang.*;
import java.lang.Math;

public class GraphCanvas extends Canvas {

   public static final int startMinX = 10;
   public static final int startMinY = 15;

   public boolean doCalc = false;

   public int xSize;	// x ilgis
   public int ySize;	// y ilgis
   
   private int startGrX = 20;
   private int startGrY = 20;
   private int endGrX = 370;
   private int endGrY = 380;
   
   private int yMargin = 10;
   private int xMargin = 10;
   
   //daug nereikes
   boolean l_br = true;       //vaizduoti linija tarp Nuotakos pasirinkimu?
   boolean l_gr_br = true;    //vaizduoti linija tarp jainikiu gerumu & Nuotakos ispudziu?
   boolean sh_br_data = true; //vaizduoti Nuotakos pasirinkimus?
   boolean sh_gr_data = true; //vaizduoti jaunikiu duomenis?
   boolean sh_br_impr = true; //vaizduoti Nuotakos ispudzius?
   boolean s_curve = true;	// vaizduoti tik viena pasirinkimu kreive ?

    //atvaizdavimo spalvos, zr. auksciau
   Color br_data_c = Color.blue;
   Color gr_data_c = Color.red;
   Color br_impr_c = Color.green;
   Color l_br_c = Color.gray;
   Color l_gr_br_c = Color.lightGray;

   boolean load_br_data = false;   //ar perduoti jaunosios duomenys?
   boolean load_gr_data = false;   //ar perduoti jaunuju duomenys?
   boolean load_br_impr = false;   //ar perduoti jaunosios ispudziai?
   int married=1;
   double maxy=0.0;
   
   //private int halfX = 280;
   //private int halfY = 120;
   
   public Calc sk_data = new Calc();
   
   private String caption;
   
   public GraphCanvas() {
   	    setTitle("");
    	load_br_data = false;
        load_gr_data = false;
        load_br_impr = false;   	    
        this.setBackground(Color.lightGray);
    	repaint();
   }
   
   public GraphCanvas(int xSize, int ySize) {

   	this.xSize = xSize;
   	this.ySize = ySize;
   	load_br_data = false;
    load_gr_data = false;
    load_br_impr = false;
   	setTitle("");
   	this.setBackground(Color.lightGray);
    repaint();

   }
   
   
   public void paint(Graphics g) {

	Font titlesFont = new Font("ArialNarrow", Font.PLAIN, 12);
	g.setFont(titlesFont);
	g.setColor(Color.black);
	g.drawString(caption, 10, 9);
	
	g.setColor(Color.white);
	g.drawLine(5, 5, 8, 5);
	g.drawLine(10 + g.getFontMetrics(titlesFont).stringWidth(caption), 5, getSize().width - 6, 5);
	g.drawLine(5, 5, 5, getSize().height - 6);
	g.drawLine(getSize().width - 5, 5, getSize().width - 5, getSize().height - 6);
	g.drawLine(getSize().width - 5, getSize().height - 5, 5, getSize().height - 5);
	
	g.setColor(Color.gray);		
	g.drawLine(4, 4, 8, 4);
	g.drawLine(10 + g.getFontMetrics(titlesFont).stringWidth(caption), 4, getSize().width - 5, 4);
	g.drawLine(4, 4, 4, getSize().height - 5);
	g.drawLine(getSize().width - 6, 6, getSize().width - 6, getSize().height - 7);
	g.drawLine(getSize().width - 7, getSize().height - 6, 6, getSize().height - 6);
	
	g.setColor(Color.black);
    g.drawRect(startMinX - 2, startMinY - 2, xSize - 2*startMinX + 4, ySize - 2*startMinY + 4);
    g.setColor(Color.white);
    g.fillRect(startMinX - 1, startMinY - 1, xSize - 2*startMinX + 3, ySize - 2*startMinY + 3);

// koordinachiu  ashys ir uzhrashai
        //pasiskaiciuojam maxy
        maxy = (sk_data.Sigma_s+sk_data.Sigma_w)*3+Math.abs(sk_data.miu*sk_data.local_grooms)/1.5;
         
        g.setFont(new Font("Helvetica", Font.BOLD, 10));        
        g.setColor(Color.black);
        g.drawLine(startGrX, startGrY, startGrX, endGrY);
        g.drawLine(startGrX, (endGrY - startGrY)/2 + startGrY , endGrX, (endGrY - startGrY)/2 + startGrY);
        
        //uzrasai virsuje ir apacioje - y
        
        g.drawLine(startGrX - 2, startGrY + yMargin, startGrX + 2, startGrY + yMargin);
        g.drawString(String.valueOf(maxy), 30, startGrY+10);
        g.drawLine(startGrX - 2, endGrY - yMargin, startGrX + 2, endGrY - yMargin);
        g.drawString(String.valueOf(-maxy), 30, endGrY);
        
        g.drawLine(endGrX - xMargin, (endGrY - startGrY)/2 + startGrY - 2, endGrX - xMargin, (endGrY - startGrY)/2 + startGrY + 2);
        g.drawString("" + sk_data.local_grooms, endGrX - xMargin - 4, (endGrY - startGrY)/2 + startGrY + 15);
 	    g.drawString("0", startGrX - 6, (endGrY - startGrY)/2 + startGrY + 15);

 	    int xCoeff = ((endGrX - startGrX)/sk_data.local_grooms);
	    int yCoeff = (endGrY - startGrY)/2 - yMargin*2;
	    yCoeff = (int)(yCoeff / maxy);
	    
	   
 	    if(sh_br_data) {
             g.setColor(br_data_c);
		     for (int k=0;k<sk_data.num;k++)
                 for(int i=0;i<sk_data.local_grooms;i++) {
		         if (s_curve)
                    g.fillOval(startGrY+i*xCoeff,(endGrY - startGrY)/2 + startGrY-(int)(sk_data.w[i]*yCoeff),3,3);
		         else
                    g.fillOval(startGrY+i*xCoeff,(endGrY - startGrY)/2 + startGrY-(int)(sk_data.all_w[i][k]*yCoeff),3,3);
                }
            }
 	    
            if(sh_gr_data) {
                g.setColor(gr_data_c);
                for(int i=0;i<sk_data.local_grooms;i++) {
                    g.fillOval(startGrY+i*xCoeff,(endGrY - startGrY)/2 + startGrY-(int)(sk_data.jaun[i]*yCoeff),3,3);
                }
            } 
            
            if(sh_br_impr) {
                g.setColor(br_impr_c);
                for(int i=0;i<sk_data.local_grooms;i++) {
                   g.fillOval(startGrY+i*xCoeff,(endGrY - startGrY)/2 + startGrY-(int)(sk_data.impr[i]*yCoeff),3,3);
                }
            }   
            
 if(l_br && sh_br_data) {
     g.setColor(l_br_c);
     if (s_curve){
          for(int i=1;i<sk_data.local_grooms;i++){
             g.drawLine(startGrY+(i-1)*xCoeff,(endGrY - startGrY)/2 + startGrY-(int)(sk_data.w[i-1]*yCoeff),
                        startGrY+i*xCoeff,(endGrY - startGrY)/2 + startGrY-(int)(sk_data.w[i]*yCoeff));
          }              
       }else{
		for (int k=0;k<sk_data.local_grooms;k++){
                for(int i=1;i<sk_data.local_grooms;i++){
             g.drawLine(startGrY+(i-1)*xCoeff,(endGrY - startGrY)/2 + startGrY-(int)(sk_data.all_w[i-1][k]*yCoeff),
                        startGrY+i*xCoeff,(endGrY - startGrY)/2 + startGrY-(int)(sk_data.all_w[i][k]*yCoeff));
                }
        }
       }       
 }      
 if(l_gr_br && sh_gr_data && sh_br_impr) {
         g.setColor(l_gr_br_c);
         for(int i=0;i<sk_data.local_grooms;i++) {
             g.drawLine(startGrY+i*xCoeff,(endGrY - startGrY)/2 + startGrY-(int)(sk_data.impr[i]*yCoeff),
                        startGrY+i*xCoeff,(endGrY - startGrY)/2 + startGrY-(int)(sk_data.jaun[i]*yCoeff));
         }
     }

  }


    void setShowData(int what, boolean sh, Color c) {
        if(what == 1) {
            sh_br_data = sh;
            br_data_c = c;
        }
        else if(what == 2) {
            sh_gr_data = sh;
            gr_data_c = c;
        }
        else if(what == 3) {
            sh_br_impr = sh;
            br_impr_c = c;
        }
        else if(what == 4) {
            l_br = sh;
            l_br_c = c;
        }
        else if(what == 5) {
            l_gr_br = sh;
            l_gr_br_c = c;
        }
    }

    void setShowData(int what, boolean sh) {
        if(what == 6) 
            s_curve = sh;
    }

/** Changes title of the map 
  * @param name - title.
  * @return No return value
*/
     public void setTitle(String name) {
   	     caption = name;
   	     repaint();
     }
     
} 
