import java.io.*;

public class main {

	static int BAYES1 = 1;
	static int GLOPT = 2;
	static int EXKOR = 3;
	static int NLP = 4;

	static int NGLOBIT = task.MAX(fitimeb.GLOPT_MAX_IT, fitimeb.BAYES1_MAX_IT);
	static int NLOCIT = task.MAX(fitimeb.NPL_MAX_IT, fitimeb.EXKOR_MAX_IT);
	static int NIT = task.MAX(NGLOBIT, NLOCIT);

	public static int[] cols = new int[fitimeb.MAXCOLS];
	public static double[] min = new double[fitimeb.DM];
	public static double[] max = new double[fitimeb.DM];
	public static double[] rnd = new double[fitimeb.SI];
	public static double[] parms = new double[fitimeb.DM];
	public static double[] b;
	
	static double[] z;
	static double[][] A;
	static double[] B;
	static double[][] xn  = new double[NIT][];
	
	static double[] c = new double[fitimeb.S];
	static double[] a = new double[fitimeb.DM];
	static double[] ao, bo;
	
	static double delta, delta1;

	static int NPARAMS = 0;
	
	public static String inputfile = "test", outputfile = "test.out";

	static int epsprn, ig, il;
	public static int P, Q, t0;
	
	static double opt0, opt, opt1;
	
	public static void beginArma() {
		
		int Po, Qo, to, ts, tmax;
		
		initialize(fitimeb.INIFILE);
		DataOutputPanel.println("Number of Factors M " + fitimeb.M);
		DataOutputPanel.println("Number of Columns of matrix c R " + fitimeb.R);
		
		DataOutputPanel.println("INIFILE " + fitimeb.INIFILE );
		DataOutputPanel.println("Multi-step prognose indicator V " + fitimeb.V);
		DataOutputPanel.println("Multi-step optimization indicator W " + fitimeb.W);
		DataOutputPanel.println("Number of prognose repetitions K " + fitimeb.K);
		DataOutputPanel.println("indicator of simulated annealing SA " + fitimeb.SA);
		DataOutputPanel.println("temperature of simulated annealing ST " + fitimeb.ST);
		DataOutputPanel.println("number of simulated annealing iterations SI " + fitimeb.SI);
		DataOutputPanel.println("indicator of residual printing EPS " + fitimeb.EPS);
		DataOutputPanel.println("indicator of input control INP " + fitimeb.INP);
		DataOutputPanel.println("the first line in datafile for regression, TR " + fitimeb.TR);
		DataOutputPanel.println("the last line in datafile for regression, TE " + fitimeb.TE);
		DataOutputPanel.println("starting number of AR parameters Ps " + fitimeb.Ps);
		DataOutputPanel.println("starting number of MA parameters Qs " + fitimeb.Qs);
		DataOutputPanel.println("minimal number of AR parameters Pmin " + fitimeb.Pmin);
		DataOutputPanel.println("minimal number of MA parameters Qmin " + fitimeb.Qmin);
		DataOutputPanel.println("maximal number of AR parameters Pmax " + fitimeb.Pmax);
		DataOutputPanel.println("maximal number of MA parameters Qmax " + fitimeb.Qmax);
		DataOutputPanel.println("number of data entries T " + fitimeb.T);
		DataOutputPanel.println("number of entries for a and b optimization T0 " + fitimeb.T0);
		DataOutputPanel.println("number of entries for P and Q optimization T1 " + fitimeb.T1);
		DataOutputPanel.println("indicator of variance F " + fitimeb.F);
		
		ig = 0;
		il = 0;
		int dP = fitimeb.M;
		int dQ = 1;
		int dt = 1;
		ts = 0;
		tmax = ts;
		
		DataOutputPanel.println("Global Max Iterat " + fitimeb.BAYES1_MAX_IT);
		DataOutputPanel.println("Local Max Iterat " + fitimeb.EXKOR_MAX_IT);
		DataOutputPanel.println("b-Bounds " + fitimeb.MAX_B_BOUNDS);
		DataOutputPanel.println("Diskret Params Init (Ps-AR params, Qs-MA params, ts-starting time) : Ps Qs ts = " + 
							fitimeb.Ps + " " + fitimeb.Qs + " " + ts);
		DataOutputPanel.println("Diskret Params Step : dP dQ dt = " + dP + " " + dQ  + " " + dt);
		DataOutputPanel.println("Diskret Params Max : Pmax Qmax tmax = " + fitimeb.Pmax + " " + fitimeb.Qmax + " " + tmax);
		
		P = fitimeb.Ps;
		Q = fitimeb.Qs;
		t0 = ts;
		Po = fitimeb.Ps;
		Qo = fitimeb.Qs;
		to = ts;
		
		opt = fi0(P, Q, t0);
		bo = b;
		ao = a;
		
		for (int l = 0; l < fitimeb.Ps; l++)
			DataOutputPanel.println("Start AR:  l=0_Ps  a[l] = " + a[l]);
			
		for (int k = 0; k < fitimeb.Qs; k++) {
			DataOutputPanel.println("Start MA:  k=0_Qs  b[k] = " + b[k]);
		}
		
		DataOutputPanel.println("Start Results: opt  delta_perc  delta_mean = " + opt + "  " + delta + "  " + delta1);
		DataOutputPanel.println("Start Discret: Po  Qo  to    opt  delta_perc  delta_mean = " + Po + "  " + Qo + "  " +
												to + "  " + opt + "  " + delta + "  " + delta1);
		
		for (int k = 0; k < Qo; k++) {
			DataOutputPanel.println("Start MA: k=0_Qo  b[k] = " + b[k]);
		}
		
		for (int l = 0; l < Po; l++) {
			DataOutputPanel.println("Start AR: l=0_Po  a[l] = " + a[l]);
		}
		
		if (fitimeb.Ps > fitimeb.Pmax)
			DataOutputPanel.println("Error: Ps>Pmax");
		if (fitimeb.Ps < fitimeb.Pmin)
			DataOutputPanel.println("Error: Ps<Pmin");
		if (fitimeb.Qs > fitimeb.Qmax)
			DataOutputPanel.println("Error: Qs>Qmax");
		if (fitimeb.Qs < fitimeb.Qmax)
			DataOutputPanel.println("Error: Qs<Qmin");
		if (P > fitimeb.DM / fitimeb.M)
			DataOutputPanel.println("Warning: P>DM/M");
		if (fitimeb.T1 != 2*fitimeb.T0)
			DataOutputPanel.println("Warning: T1 != 2*T0");
		if (P > fitimeb.T0 / fitimeb.M)
			DataOutputPanel.println("Warning: P>T0/M");
			
		if (fitimeb.SA == 1) {
			double eks;
			P = fitimeb.Ps;
			Q = fitimeb.Qs;
			
			for (int i = 0; i < fitimeb.SI; i++) {
				
				rnd[i] = fitimeb.RAND();
				if (rnd[i] >= 0.5 && P+fitimeb.M-1 < fitimeb.Pmax)
					P += fitimeb.M;
				if (rnd[i] < 0.5 && P-fitimeb.M+1 > fitimeb.Pmin)
					P -= fitimeb.M;
					
				rnd[i] = fitimeb.RAND();
				if (rnd[i] >= 0.5 && Q < fitimeb.Qmax)
					Q += 1;
				rnd[i] = fitimeb.RAND();
				if (rnd[i] < 0.5 && Q > fitimeb.Pmin)
					Q -= 1;
				
				opt1 = fi0(P, Q, t0);
				
				if (opt1 < opt) {
					opt = opt1;
					Po = P;
					Qo = Q;
					to = t0;
					bo = b;
					ao = a;
				}
				
				if (opt1 >= opt) {
					rnd[i] = fitimeb.RAND();
					eks = Math.pow(2.0, (opt-opt1)/(fitimeb.ST*0.6931)); //ldexp(1.0, (opt-opt1)/(fitimeb.ST*0.6931));
					
					if (rnd[i] > eks) {
						Po = P;
						Qo = Q;
						to = t0;
					}
				}
				
			}
		}
		
		if (fitimeb.SA == 0) {
			
			for ( P = fitimeb.Pmin; P < fitimeb.Pmax+1; P+=dP)
				for ( Q = fitimeb.Qmin; Q < fitimeb.Qmax+1; Q+=dQ)
					for ( t0 = ts; t0 < tmax+1; t0+=dt) {
						
						opt1 = fi0(P, Q, t0);
						
						DataOutputPanel.println("before opt1 < opt: Po  Qo  to  P  Q  t0  opt  delta_perc  delta_mean  opt1= " +
																Po + "  " + Qo + "  " + to + "  " + P + "  " + Q + "  " + t0 + "  " + 
																opt + "  " + delta + "  " + delta1 + "  " + opt1);
						
						for (int k = 0; k < Q; k++) {
							DataOutputPanel.println("bef opt1 < opt: k  b[k] = " + k + "  " + b[k]);
						}
						
						for (int l = 0; l < P; l++) {
							DataOutputPanel.println("bef opt1 < opt: l  a[l] = " + l + "  " + a[l]);
						}
						
						if (opt1 < opt) {
							opt = opt1;
							
							DataOutputPanel.println("after opt1 < opt before Po=P ao = a: Po  Qo  to  P  Q  t0  opt  delta_perc  delta_mean  opt1 opt0= " + 
																	Po + "  " + Qo + "  " + to + "  " + P + "  " + Q + "  " + t0 + "  " +
																	opt + "  " + delta + "  " + delta1 + "  " + opt1 + "  " + opt0);
							
							for (int k = 0; k < Q; k++) {
								DataOutputPanel.println("  k  b[k] = " + k + "  " + b[k]);
							}
							for (int k = 0; k < Qo; k++) {
								DataOutputPanel.println("  k  bo[k] = " + k + "  " + bo[k]);
							}
							for (int l = 0; l < P; l++) {
								DataOutputPanel.println("  l  a[l] = " + l + "  " + a[l]);
							}
							for (int l = 0; l < Po; l++) {
								DataOutputPanel.println("  l  ao[l] = " + l + "  " + ao[l]);
							}
							
							Po = P;
							Qo = Q;
							to = t0;
							opt0 = opt1;
							ao = a;
							bo = b;
						}
					}
		}
		
		P = Po;
		Q = Qo;
		t0 = to;
		
		
		DataOutputPanel.println("before last opt=fi0 Po=P ao = a: Po  Qo  to  P  Q  t0  opt  delta_perc  delta_mean  opt1 opt0= " + 
												Po + "  " + Qo + "  " + to + "  " + P + "  " + Q + "  " + t0 + "  " +
												opt + "  " + delta + "  " + delta1 + "  " + opt1 + "  " + opt0);
		
		for (int k = 0; k < Q; k++) {
			DataOutputPanel.println("  k  b[k] = " + k + "  " + b[k]);
		}
		for (int k = 0; k < Qo; k++) {
			DataOutputPanel.println("  k  bo[k] = " + k + "  " + bo[k]);
		}
		for (int l = 0; l < P; l++) {
			DataOutputPanel.println("  l  a[l] = " + l + "  " + a[l]);
		}
		for (int l = 0; l < Po; l++) {
			DataOutputPanel.println("  l  ao[l] = " + l + "  " + ao[l]);
		}
	
		epsprn = 1;
		opt = fi0(P, Q, t0);
		
		DataOutputPanel.println("Finish Discret: Po  Qo  to  P  Q  t0  opt  delta_perc  delta_mean= " + 
												Po + "  " + Qo + "  " + to + "  " + P + "  " + Q + "  " + t0 + "  " +
												opt + "  " + delta + "  " + delta1);
		
		for (int k = 0; k < Q; k++) {
			DataOutputPanel.println("Finish MAo: k=0_Q b[k] = " + b[k]);
		}
		for (int l = 0; l < P; l++) {
			DataOutputPanel.println("Finish ARo: l=0_P a[l] = " + a[l]);
		}
		
		if (fitimeb.PL == 1) {
			double D1 = (fitimeb.B1 - fitimeb.A1) / fitimeb.DN;
			double[] xplot = new double[100];
			
			Draw2D fp = new Draw2D();
			
			for (xplot[fitimeb.PLOT1] = fitimeb.A1; xplot[fitimeb.PLOT1] <= fitimeb.B1; xplot[fitimeb.PLOT1] += D1) {
				
				for (int i = 0; i < Q; i++) {
					if (i == fitimeb.PLOT1)
						b[i] = xplot[i];
				}
				
				double fiplot = Math.log( fi.fi(b, Q) );
				
				fp.addPoint( b[fitimeb.PLOT1], fiplot );
			}
			
			fp.close();

		}
	
		if (fitimeb.PL == 2) {
			double D1 = (fitimeb.B1 - fitimeb.A1) / fitimeb.DN;
			double D2 = (fitimeb.B2 - fitimeb.A2) / fitimeb.DN;
			
			double[] xplot = new double[100];
			
			Draw3D fp = new Draw3D();
			
		  for (xplot[fitimeb.PLOT1] = fitimeb.A1; xplot[fitimeb.PLOT1] <= fitimeb.B1; xplot[fitimeb.PLOT1] += D1) {
		  	for (xplot[fitimeb.PLOT2] = fitimeb.A2; xplot[fitimeb.PLOT2] <= fitimeb.B2; xplot[fitimeb.PLOT2] += D2) {
		  		for (int i = 0; i < Q; i++ ) {
		  			if (i == fitimeb.PLOT1)
		  				b[i] = xplot[i];
		  			if (i == fitimeb.PLOT2)
		  				b[i] = xplot[i];
		  		}
		  		double fiplot = Math.log( fi.fi( b, Q ) );

					fp.addPoint( b[fitimeb.PLOT1], b[fitimeb.PLOT2], fiplot );
				  
		  	}
		  }
		  
			fp.close();
		}
		
		if (fitimeb.V == 1) {
			fi.multi_step(t0, fitimeb.T1 / fitimeb.M, fitimeb.T / fitimeb.M );
			
			double progn;
			progn = fi.progn_err( fitimeb.T1 / fitimeb.M, fitimeb.T / fitimeb.M );
			
			DataOutputPanel.println("Finish progn_err " + progn);
		}
	}
// --------------------	init_arrays -------------------------
	private static void init_arrays() {
		
		for (int i = 0; i < NIT; i++) {
			xn[i] = new double[NPARAMS];
		}
		b = parms;
		//System.out.println(b + " " + parms);
		for (int i = 0; i < fitimeb.S; i++) {
			c[i] = parms[Q + fitimeb.R * i];
		}
	}
// --------------------	initialize -------------------------
	private static int initialize(String ininame) {
		String str = null;
		int nCol = 0;
		
		//cols = new int[fitimeb.MAXCOLS];
		for (int i = 0; i < fitimeb.MAXCOLS; i++)
			cols[i] = 0;
		
		ReadData fp = null;
		try {
			fp = new ReadData( ininame );
		}
		catch (FileNotFoundException excp) {
			Util.errorMsg("Error: no ini file found: " + ininame);
			System.exit( 1 );
		}
	
		int i = 0;
		
		byte strt[] = new byte[100];
		
		int e = 0;
		
		try {
			str = fp.readLine();
		}
		catch (IOException excp) {
			e = -1;
		}

		while (e != -1 && str != null ) {
			//str = new String(strt);
			if (str.length() > 0) {
				i++;
				String str1 = null, str2 = null;
				
				str1 = str.substring(0, str.indexOf(" ")).trim();
				str2 = str.substring(str.indexOf(" ")+1).trim();
				
				if ( str1.equals("INP") ) {
					inputfile = new String(str2);
					//System.out.println("INP " + str2);
				}
				
				else if (str1.equals("OUTP") ) {
						outputfile = new String(str2);
						//System.out.println("OUTP " + str2);
				}
				else if (str1.equals("COL") ) {
						int iCol = Integer.parseInt(str2);
						iCol--;
						
						if (iCol >= fitimeb.MAXCOLS || iCol < 0) {
							DataOutputPanel.println("Error: wrong column: " + str2);
						}
						//else System.out.println("COL " + iCol);
						cols[iCol] = 1;
						nCol++;
				}
				else DataOutputPanel.println("Check initialization string! " + str);
				
				try {
					str = fp.readLine();
				}
				catch (IOException excp) {
					e = -1;
				}
			}
			else e = -1;
		}
		
		try {
			fp.close();
		}
		catch (IOException expt) {}
		
		A = new double[fitimeb.T][fitimeb.DM];
		B = new double[fitimeb.T];
		z = new double[fitimeb.T];
		return 1;
	}
// --------------------	fi0 -------------------------
	private static double fi0(int p, int q, int s) {
		double fval;
		fi.get_z();
	
		set_bounds();
		fi.set_t(fitimeb.T0 / fitimeb.M);
		init_arrays();
		
		if (NPARAMS > 0) {
			get_glob_parms ();
			get_local_parms();
			a = fi.get_a(b, c);
		}
		else {
			a = fi.get_a(b, c);
		}
		
		double delt_p0;
		double rw_p0;
		
		fi.set_t(fitimeb.T0 / fitimeb.M);
		
		delt_p0 = fi.fm0(P / fitimeb.M);
		rw_p0 = fi.frw(P / fitimeb.M);
		
		double delt_01 = 0;
		double rw_01;
		
		fi.set_t( fitimeb.T1 / fitimeb.M );
		
		if (fitimeb.W == 0) {
		  delt_01 = fi.fm0( fitimeb.T0 / fitimeb.M );
		}
		
		if (fitimeb.W == 1) {
		  delt_01 = fi.multi_step( t0, fitimeb.T0 / fitimeb.M, fitimeb.T1 / fitimeb.M );
		}
		
		rw_01 = fi.frw( fitimeb.T0 / fitimeb.M );
		
		double delt_1t;
		double rw_1t;
		
		fi.set_t( fitimeb.T / fitimeb.M );
		delt_1t = fi.fm0( fitimeb.T1 / fitimeb.M );
		rw_1t = fi.frw( fitimeb.T1 / fitimeb.M );
		
		delta = 100 * (delt_1t - rw_1t) / rw_1t;
		delta1 = delt_1t;
		
		double delt_0t;
		double rw_0t;
		
		fi.set_t( fitimeb.T / fitimeb.M );
		delt_0t = fi.fm0( fitimeb.T0 / fitimeb.M );
		rw_0t = fi.frw( fitimeb.T0 / fitimeb.M );
		
		double delt_pt;
		double rw_pt;
		
		fi.set_t( fitimeb.T / fitimeb.M );
		delt_pt = fi.fm0( P / fitimeb.M );
		rw_pt = fi.frw( P / fitimeb.M );
	
		return delt_01;
	}
// --------------------	set_bounds -------------------------
	private static void set_bounds() {
		int i;
		for (i = 0; i < Q; i++) {
			min[i] = - fitimeb.MAX_B_BOUNDS;
			max[i] = fitimeb.MAX_B_BOUNDS;
		}
		
		NPARAMS = Q + fitimeb.S * fitimeb.R;
		for (; i < NPARAMS; i++) {
			min[i] = - fitimeb.MAX_C_BOUNDS;
			max[i] = fitimeb.MAX_C_BOUNDS;
		}
		
	}
// --------------------	get_glob_params -------------------------
	private static void get_glob_parms() {
		
		if (fitimeb.GLOBAL_METH == BAYES1) {
			//bayes1();
			if (ig == 0) {
				DataOutputPanel.println("BAYES,");
				ig++;
			}
		}
		else if (fitimeb.GLOBAL_METH == GLOPT) {
				//glopt();
				if (ig == 0) {
					DataOutputPanel.println("GLOPT,");
					ig++;
				}
			}
	}
// --------------------	get_local_params -------------------------
	private static void get_local_parms() {
		if (fitimeb.LOCAL_METH == NLP) {
			//fnlpql();
			if (il == 0) {
				DataOutputPanel.println("NLP,");
				il++;
			}
		}
		else if (fitimeb.LOCAL_METH == EXKOR) {
				//exkor();
				if (il == 0) {
					DataOutputPanel.println("EXKOR,");
					il++;
				}
			}
			else {
					Util.errorMsg("LOCAL_METH in fitimeb.java should be NLP or EXKOR.");
					System.exit( 1 );
				}
	}

}
