import java.io.*;
//import java.util.*;

public class fi {
	
	static double[] z;
	static double[] zInp;

	static double[] a = new double[fitimeb.DM];
	static double[] b;
	static double[] c = new double[fitimeb.S];

	static double[][] A = new double[fitimeb.T][fitimeb.DM];//[main.P];
	static double[] B = new double[fitimeb.T]; //[main.P];
	
	static double[][] ma = new double[fitimeb.DM][fitimeb.DM];
	static double[] mb = new double[fitimeb.DM];
	
	static double[] ymin = new double[fitimeb.T * fitimeb.M];
	static double[] ymax = new double[fitimeb.T * fitimeb.M];
	static double[] yav = new double[fitimeb.T * fitimeb.M];
	static double[] yb = new double[fitimeb.T * fitimeb.M ];
	static double[][] eps = new double[fitimeb.K][fitimeb.T * fitimeb.M ];
	static double[][] y = new double[fitimeb.K][fitimeb.T * fitimeb.M ];

	static int Tst;

	static boolean zInpFilled = false;

// ------------------------- get_z --------------------------
	public static void get_z() {
		
		if (!zInpFilled) {
			zInp = new double[fitimeb.T];
			zInpFilled = true;
			
			
			{
				ReadData fp = null;
				try {
					fp = new ReadData( main.inputfile );
				}
				catch (FileNotFoundException excp) {
					Util.errorMsg("Error: wrong parameter INP: " + main.inputfile);
					System.exit( 1 );
				}
			
				String str = new String(); 
				
				for (int t = 0, nCols = 0; t < fitimeb.T; t+= fitimeb.M, nCols = 0) {
					
					try {
						str = fp.readLine();
					}
					catch (IOException excp) {
						return;
					}
					if (str == null) {
						Util.errorMsg("ERROR-1: Unexpected end of file!");
						return;
					}
					
					int strCol = 0;
										
					for (int i = 0; strCol != -1 && i < fitimeb.MAXCOLS; i++) {

						if (main.cols[i] == 1) {
							
							strCol = str.indexOf(" ", strCol);
							
							String subS;
							if (strCol == -1) {
								subS = str;
								
							}
							else {
								subS = str.substring(0, strCol);
								str = str.substring(strCol).trim();
							}
							
							zInp[t + nCols] = Double.valueOf(subS).doubleValue(); 
						
							//TESTING DATA INPUT:
							if (fitimeb.INP == 1) {
								DataOutputPanel.println( "  " + (t + nCols) + "   " + zInp[t+nCols]);
							}
							nCols++;
						}
						
					}
									
					if (nCols != fitimeb.M) {
						DataOutputPanel.println("nCols  M" + nCols + "  " + fitimeb.M);
						DataOutputPanel.println("ERROR-2: Unexpected end of line!");
					}
				}
				
				try {
					fp.close();
				}
				catch (IOException expt) {}
		
			}
		}
		
		z = new double[fitimeb.T];
		System.arraycopy(zInp, 0, z, 0, fitimeb.T);

	}
// ------------------------- get_AB --------------------------
	public static void get_AB() {
		
		for (int t = 0; t < fitimeb.T; t++)
			for (int i = 0; i < main.P; i++) 
				A[t][i] =  0;
		
		for (int t = 0; t < main.P; t++)
			B[t] = 0;
		
		for (int t = 0; t < Tst; t++)
			for (int i = 0; i < main.P && fitimeb.M*t-i > 0; i++) {
				
				A[fitimeb.M*t][i] = - z[fitimeb.M*t-i-1];
				
				for (int j = 0; j < main.Q && fitimeb.M*(t-j) > 0; j++)
					A[fitimeb.M*t][i] += b[j] * A[fitimeb.M*(t-j-1)][i];
					
				for (int k = 0; k < fitimeb.S && fitimeb.M*(t-k) > 0; k++)
					for (int l = 0; l < fitimeb.R && fitimeb.M*(t-l) > 0; l++)
						A[fitimeb.M*t][i] -= c[k*fitimeb.S+l] * z[fitimeb.M*(t-k-1)] * A[fitimeb.M*(t-l-1)][i];
			}
		
		for (int t = main.t0; t < Tst; t++) {
			
			B[fitimeb.M*t] = z[fitimeb.M*t];
			
			for (int j = 0; j < main.Q && fitimeb.M*(t-j) > 0; j++) 
				B[fitimeb.M*t] += b[j] * B[fitimeb.M*(t-j-1)];
			
			for (int k = 0; k < fitimeb.S && fitimeb.M*(t-k) > 0; k++) 
				for (int l = 0; l < fitimeb.R && fitimeb.M*(t-l) > 0; l++)
					B[fitimeb.M*t] -= c[fitimeb.S*k+l] * z[fitimeb.M*(t-k-1)] * B[fitimeb.M*(t-l-1)];
		}
		
	}
// ------------------------- get_ma_mb --------------------------
	public static void get_ma_mb() {
		for (int i = 0; i < main.P; i++) {
			mb[i] = 0;
			
			for (int j = 0; j < main.P; j++) {
				ma[i][j] = 0;
				
				for (int t = main.t0; t < Tst; t++)
					ma[i][j] += A[fitimeb.M*t][j] * A[fitimeb.M*t][i];
			}
			
			mb[i] = 0;
			
			for (int t = main.t0; t < Tst; t++)
				mb[i] -= B[fitimeb.M*t] * A[fitimeb.M*t][i];
		}
	}
// ------------------------- eqgauss --------------------------
	static double AMIN = 1e-100;

	public static void eqgauss() {
		
		int i, j, max;
		double t;
		
		for ( i = 0; i < main.P-1; i++) {
			int k;
			
			for (j = i+1, max = i; j < main.P; j++) {
				if ( Math.abs(ma[j][i]) > Math.abs(ma[max][i]) )
					max = j;
			}
			
			if (max != i) { 
				for (k = 0; k < main.P; k++) {
					t = ma[max][k];
					ma[max][k] = ma[i][k];
					ma[i][k] = t;
				}
				
				t = mb[max];
				mb[max] = mb[i];
				mb[i] = t;
			}
			
			for (j = i+1; j < main.P; j++) {
				double s;
				s = ma[j][i] / ( Math.abs(ma[i][i]) > AMIN ? ma[i][i] : AMIN );
				
				for (k = main.P - 1; k >= i; k--) 
					ma[j][k] -= ma[i][k] * s;
					
				mb[j] -= mb[i] * s; 
			}
		}
		
		for (i = main.P - 1; i >= 0; i--) {
			a[i] = mb[i];
			
			for (j = main.P - 1; j >= 0; j--)
				a[i] -= ma[i][j] * a[j];
				
			a[i] /= (Math.abs(ma[i][i]) > AMIN ? ma[i][i] : AMIN);
		}
	}
// ------------------------- fm0 ----------------------------
	public static double fm0(int t0) {
		double sum = 0.0;
		
		for (int t = 0; t < fitimeb.T; t++) 
			yb[t] = 0.0;
			
		get_AB();
		
		for (int t = t0; t < Tst; t++) {
			double et = B[fitimeb.M*t];
			
			for (int j = 0; j < main.P; j++)
				et += A[fitimeb.M*t][j] * a[j];
				
			sum += et * et;
		}
		
		for (int t = 0; t < Tst; t++) {
			yb[fitimeb.M*t] = B[fitimeb.M*t];
			
			for (int j = 0; j < main.Q && fitimeb.M*(t-j) > 0; j++) {
				yb[fitimeb.M*t] -= B[fitimeb.M*(t-j-1)] * b[j];
			}
		}
		
		sum /= Tst - t0;
		
		return Math.sqrt( sum );
	}
// ------------------------- frw ----------------------------
	public static double frw(int t0) {
		double sum = 0.0;
		
		for (int t = t0; t < Tst; t++) {
			sum += (z[fitimeb.M*t] - z[fitimeb.M*(t-1)]) * (z[fitimeb.M*t] - z[fitimeb.M*(t-1)]);
		}
		
		sum /= Tst - t0;
		return Math.sqrt( sum );
	}
// ------------------------- fi -----------------------------
	public static double fi( final double[] x, int n ) {
		b = x;
		
		for (int i = 0; i < fitimeb.S; i++)
			c[i] = x[main.Q + fitimeb.R*i];
		
		get_AB();
		
		get_ma_mb();
		
		eqgauss();
		
		double sum = 0;
		
		for (int t = main.t0; t < fitimeb.T0 / fitimeb.M; t++) {
			double et = B[fitimeb.M*t];
			
			for (int j = 0; j < main.P; j++)
				et += A[fitimeb.M*t][j] * a[j];
			
			sum += et * et;
		}
		
		sum /= ( fitimeb.T0 / fitimeb.M ) - main.t0;
		
		double sqsum = Math.sqrt( sum );
				
		return sqsum;
	}
// ------------------------- get_a --------------------------
	public static double[] get_a( double[] bb, double[] cc ) {
		get_z();
		b = bb;
		
		for (int i = 0; i < fitimeb.S; i++) 
			c[i] = cc[i];
		get_AB();
		
		get_ma_mb();
		
		eqgauss();
		
		return a;
	}
// ------------------------- set_t --------------------------
	public static void set_t(int t) {
		Tst = t;
	}
// ------------------------- progn_err ----------------------	
	public static double progn_err(int t2, int t3) {
		
		double delt = 0;
		
	  WriteData fp = null;
	  try {
		fp = new WriteData( "progn.out" );
	  }
	  catch (IOException excp) {
			Util.errorMsg("Error: can't create file: progn.out");
			System.exit( 1 );
	  }
		
		for (int t = t2; t < t3; t++) {
			delt += (yav[fitimeb.M*t] - z[fitimeb.M*t]) * (yav[fitimeb.M*t] - z[fitimeb.M*t]);
		}
		
		delt /= t3 - t2;
		delt = Math.sqrt( delt );
		
		if (fitimeb.TR < 0) {
			
			for (int t = t2; t < t3; t++) {
				try {
				  fp.writeBytes("progn t  ymin[M*t]  yav[M*t]  ymax[M*t]  " + t + "  " + ymin[fitimeb.M*t] + "  " + 
				  							yav[fitimeb.M*t] + "  " + ymax[fitimeb.M*t] + "\n");
				}
				catch (IOException expt) {
				  Util.errorMsg( "Error: unable write to file: progn.out");
				  System.exit( 1 );
				}
			}
		}
		else {
			
			double[] reg = new double[fitimeb.T / fitimeb.M];
			int tpr = fitimeb.TR / fitimeb.M;
			int tend = fitimeb.TE / fitimeb.M;
			
			for (int j = tpr; j < tend; j++) {
				reg[j] = 0.0;
			}
			
			for (int j = tpr; j < tend; j++)
				for (int i = 0; i < main.P-1; i++) {
					reg[j] += a[i] * z[fitimeb.M*j - i - 1 + fitimeb.M];
				}
				
			double[] reg_f = new double[fitimeb.T / fitimeb.M];
			
			for (int j = tpr; j < tend; j++) {
				reg_f[j] = 0.0;
			}
			
			for (int j = tpr; j < tend; j++)
				for (int i = 0; i < main.P-1; i++) {
					reg_f[j] += a[i] * z[fitimeb.M*j - i - 1 + fitimeb.M];
				}
			
			double[] reg_err = new double[fitimeb.T / fitimeb.M];
			double reg_averr = 0.0;
			
			for (int j = tpr; j < tend; j++) {
				reg_err[j] = 0.0;
			}
			
			for (int j = tpr; j < tend; j++) {
				reg_err[j] = reg[j] - z[fitimeb.M*j - main.P + 1 - 1 + fitimeb.M];
				
				try {
				  fp.writeBytes("simple regression and true value = " + reg[j] + "  " + 
				  							z[fitimeb.M*j - main.P + 1 - 1 + fitimeb.M] + "  " + j + "\n");
				  fp.writeBytes("regression error = " + reg_err[j] + "  " + j + "\n");
				}
				catch (IOException expt) {
				  Util.errorMsg( "Error: unable write to file: progn.out");
				  System.exit( 1 );
				}
				
				reg_averr += Math.abs(reg_err[j]);
			}
			
			reg_averr /= tend - tpr;
			
			try {
			  fp.writeBytes("in the line TR/M  TE/M  reg_averr = " + tpr + "  " + tend + "  " + reg_averr + "\n");
			}
			catch (IOException expt) {
			  Util.errorMsg( "Error: unable write to file: progn.out");
			  System.exit( 1 );
			}
			
			for (int i = 0; i < main.P-1; i++) {
				try {
				  fp.writeBytes("regression parameters a[i]  i = " + a[i] + "  " + i + "\n");
				}
				catch (IOException expt) {
				  Util.errorMsg( "Error: unable write to file: progn.out");
				  System.exit( 1 );
				}
			}
			
		}
		
		try {
			fp.close();
	  }
	  catch (IOException expt) {}
		
		return delt;
	}
// ------------------------- multi_step ---------------------	
	public static double multi_step( int t1, int t2, int t3 ) {
	  
	  double large = 10.0e+20;
	  double sigma = 0;
	  double average = 0;

	  
	  WriteData fp = null;
	  try {
		fp = new WriteData( main.outputfile );
	  }
	  catch (IOException excp) {
		Util.errorMsg("Error: can't create file: " + main.outputfile);
		System.exit( 1 );
	  }

	  for (int t = 0; t < fitimeb.T * fitimeb.M; t++) {
		ymin[t] = large;
		ymax[t] = - large;
		yav[t] = 0.0;
		
		for (int k = 0; k < fitimeb.K; k++) {
		  eps[k][t] = 0.0;
		  y[k][t] = 0.0;
		}
	  }
	  for (int k = 0; k < fitimeb.K; k++)
		for (int t = t1; t < t2; t++) {
		  
		  for (int i = 0; i < main.P && fitimeb.M * t - i > 0; i++)
			eps[k][fitimeb.M*t] -= a[i] * z[fitimeb.M*t-i-1];
		  
		  for (int j = 0; j < main.Q && fitimeb.M*(t-j) > 0; j++) {
			eps[k][fitimeb.M*t] += b[j] * eps[k][fitimeb.M*(t-j-1)];
		  }
		  
		  eps[k][fitimeb.M*t] += z[fitimeb.M*t];
		  
		  try {
			
			fp.writeBytes( "equal0  eps[0][M*t]  eps[1][M*t]  t  k   " + 
						   eps[0][fitimeb.M*t] + "  " + eps[1][fitimeb.M*t] + "  " +
							t + "  " + k + "\n");
		  }
		  catch (IOException expt) {
			Util.errorMsg( "Error: unable write to file: " + main.outputfile );
			System.exit( 1 );
		  }
		  
		}
	
	  for (int t = t1; t < t2; t++) {
			sigma += eps[0][fitimeb.M*t] * eps[0][fitimeb.M*t];
				
			try {
			  fp.writeBytes("sigma  eps[0][M*t]  eps[0][0]  b[0]  a[0]  a[1]  t  t1  t2  " +
			   				sigma + "  " + eps[0][fitimeb.M*t] + "  " + eps[0][0] + "  " +
			  				b[0] + "  " + a[0] + "  " + a[1] + "  " + t + "  " + t1 + "  " +
			  				t2 + "\n");
			  fp.writeBytes("z[0]  z[M*t]  t  " + z[0] + "  " + z[fitimeb.M*t] + "  " + t + "\n");
			}
			catch (IOException expt) {
			  Util.errorMsg( "Error: unable write to file: " + main.outputfile );
			  System.exit( 1 );
			}
			
			average += eps[0][fitimeb.M*t];
			
			try {
			  fp.writeBytes("average[M*t]  t  " + average + "  " + t + "\n");
			}
			catch (IOException expt) {
			  Util.errorMsg( "Error: unable write to file: " + main.outputfile );
			  System.exit( 1 );
			}
	  }

	  sigma /= t2 - t1;
	  average /= t2 - t1;
	  average *= average;
	  
	  try {
		  fp.writeBytes("average**2  " + average + "\n");
		}
	  catch (IOException expt) {
	    Util.errorMsg( "Error: unable write to file: " + main.outputfile );
	    System.exit( 1 );
	  }
	  
	  sigma -= average;
	  sigma = Math.sqrt( sigma );
	  
	  if (fitimeb.F == 0) {
		sigma = 0.0;
	  }
	  
	  DataOutputPanel.println("Finish: sigma  " + sigma + "\n");
	  
	  try {
		  fp.writeBytes("sqrt  " + sigma + "\n");
		}
	  catch (IOException expt) {
	    Util.errorMsg( "Error: unable write to file: " + main.outputfile );
	    System.exit( 1 );
	  }
	  
	  for (int k = 0; k < fitimeb.K; k++)
		for (int t = t1; t < t2*fitimeb.M; t++) {
		  y[k][t] = z[t];
		}
	  
	  double noise = 0;
	  
	  for (int k = 0; k < fitimeb.K; k++)
		for (int t = t2; t < t3; t++) {
		  long ltime = System.currentTimeMillis() / 1000; // = time(null);
		  int stime = (int) ltime / 2;
		  
		  fitimeb.setSeed( stime );	  //srand(stime);
		  
		  noise = gauss();
		  
		  eps[k][fitimeb.M*t] = noise * sigma;
	
		  try {
		     fp.writeBytes("rnd  eps[k][M*t]  nois  t  k  t2  t3  " + 
		     eps[k][fitimeb.M*t] + "  " + noise + "  " + t + "  " + k + "  " +
		     t2 + "  " + t3 + "\n");
		  }
	  	catch (IOException expt) {
	     	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
	    	System.exit( 1 );
	  	}
		  
		}
		
		try {
		  fp.writeBytes("rnd noise  " + noise + "\n");
		}
	  catch (IOException expt) {
	   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
	    System.exit( 1 );
	  }								
	  
	  for (int k = 0; k < fitimeb.K; k++)
	  	for (int t = t2; t < t3; t++)
	  		for (int i = 1; i < fitimeb.M; i++) {
	  			y[k][fitimeb.M*t-i] = z[fitimeb.M*t2-i];
	  			
	  			try {
					  fp.writeBytes("detygr  y[k][M*t-i]  z[M*t2-i]  t  k  i  " + y[k][fitimeb.M*t-i] + "  " + 
					  							z[fitimeb.M*t2-i] + "  " + t + "  " + k + "  " + i + "\n");
					}
				  catch (IOException expt) {
				   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
				    System.exit( 1 );
				  }
	  		}
	  		
	  for (int k = 0; k < fitimeb.K; k++) {
	  	for (int t = t2; t < t3; t++) {
	  		for (int i = 0; i < main.P && fitimeb.M*t-i > 0; i++) {
	  			y[k][fitimeb.M*t] += a[i] * y[k][fitimeb.M*t-i-1];
	  			
	  			try {
					  fp.writeBytes("y[k][M*t]  y[k][M*t-i-1]  a[i]  i  t  k  t2  t3  " + y[k][fitimeb.M*t] + "  " + 
					  							y[k][fitimeb.M*t-i-1] + "  " + a[i] + "  " + i + "  " + t + "  " + k + "  " +
					  							t2 + "  " + t3 + "\n");
					}
				  catch (IOException expt) {
				   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
				    System.exit( 1 );
				  }
	  		}
	  		
	  		for (int j = 0; j < main.Q && fitimeb.M*(t-j) > 0; j++) {
	  			y[k][fitimeb.M*t] -= b[j] * eps[k][fitimeb.M*(t-j-1)];
	  			
	  			try {
					  fp.writeBytes("y[k][M*t]  eps[k][M*(t-j-1)]  b[j]  j  t  k  t2  t3  " + y[k][fitimeb.M*t] + "  " + 
					  							eps[k][fitimeb.M*(t-j-1)] + "  " + b[j] + "  " + j + "  " + t + "  " + k + "  " +
					  							t2 + "  " + t3 + "\n");
					}
				  catch (IOException expt) {
				   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
				    System.exit( 1 );
				  }
	  		}
	  		
	  		for (int i = 0; i < main.P && fitimeb.M*t-i > 0; i++) {
	  			try {
					  fp.writeBytes("first  y[k][M*t-i]  eps[k][M*t]  t  k  i  " + y[k][fitimeb.M*t-i] + "  " + 
					  							eps[k][fitimeb.M*t] + "  " + t + "  " + k + "  " + i + "\n");
					}
				  catch (IOException expt) {
				   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
				    System.exit( 1 );
				  }
	  		}
	  		
	  		y[k][fitimeb.M*t] = y[k][fitimeb.M*(t-1)] + eps[k][fitimeb.M*t];
	  	}
	  }
	  
	  for (int k = 0; k < fitimeb.K; k++) {
			try {
			  fp.writeBytes("second  y[k][M*t2]  eps[k][M*t2]  t2  k  " + y[k][fitimeb.M*t2] + "  " + 
			  							eps[k][fitimeb.M*t2] + "  " + t2 + "  " + k + "\n");
			}
		  catch (IOException expt) {
		   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
		    System.exit( 1 );
		  }
	  }
	  
	  for (int t = t2; t < t3; t++)
	  	for (int k = 0; k < fitimeb.K; k++) {
	  		yav[fitimeb.M*t] += y[k][fitimeb.M*t];
	  		
  			try {
				  fp.writeBytes("yav[M*t]  y[k][M*t]  y[0][M*t]  y[1][M*t]  t  k  " + yav[fitimeb.M*t] + "  " + 
				  							y[k][fitimeb.M*t] + "  " + y[0][fitimeb.M*t] + "  " + y[1][fitimeb.M*t] + "  " +
				  							t + "  " + k + "\n");
				}
			  catch (IOException expt) {
			   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
			    System.exit( 1 );
			  }
			  
			  if (y[k][fitimeb.M*t] < ymin[fitimeb.M*t])
			  	ymin[fitimeb.M*t] = y[k][fitimeb.M*t];
			  	
			  try {
				  fp.writeBytes("ymin[M*t]  y[k][M*t]  t  k  " + ymin[fitimeb.M*t] + "  " + 
				  							y[k][fitimeb.M*t] + "  " + t + "  " + k + "\n");
				}
			  catch (IOException expt) {
			   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
			    System.exit( 1 );
			  }
			  
			  if (y[k][fitimeb.M*t] > ymax[fitimeb.M*t])
			  	ymax[fitimeb.M*t] = y[k][fitimeb.M*t];
			  
			  try {
				  fp.writeBytes("ymax[M*t]  y[k][M*t]  t  k  " + ymax[fitimeb.M*t] + "  " + 
				  							y[k][fitimeb.M*t] + "  " + t + "  " + k + "\n");
				}
			  catch (IOException expt) {
			   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
			    System.exit( 1 );
			  }
	  	}
	  
	  for (int t = t2; t < t3; t++) {
	  	try {
			  fp.writeBytes("gale: t  ymin[M*t]  yav[M*t]  ymax[M*t]  " + t + "  " + ymin[fitimeb.M*t] + "  " + 
			  							yav[fitimeb.M*t] + "  " + ymax[fitimeb.M*t] + "\n");
			}
		  catch (IOException expt) {
		   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
		    System.exit( 1 );
		  }
	  }
	  
	  try {
		  fp.writeBytes("sigma and average  " + sigma + "  " + average + "\n");
		}
	  catch (IOException expt) {
	   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
	    System.exit( 1 );
	  }
	  
	  double delt = 0.0;
	  
	  for (int t = t2; t < t3; t++) {
	  	delt += (yav[fitimeb.M*t] - z[fitimeb.M*t]) * (yav[fitimeb.M*t] - z[fitimeb.M*t]);
	  	
	  	try {
			  fp.writeBytes("multi-step for: t  t2  t3  ymin[M*t]  yav[M*t]  ymax[M*t]  z[M*t]  " + t + "  " + t2 + "  " + 
			  							t3 + "  " + ymin[fitimeb.M*t] + "  " + yav[fitimeb.M*t] + "  " + ymax[fitimeb.M*t] + "  " +
			  							z[fitimeb.M*t] + "\n");
			}
		  catch (IOException expt) {
		   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
		    System.exit( 1 );
		  }
	  }
	  
	  delt /= t3 - t2;
	  delt = Math.sqrt( delt );
	  
	  try {
		  fp.writeBytes("delt  t0  T1  T: " + delt + "     " + t1 + "  " + t2 + "  " + t3 + "\n");
		}
	  catch (IOException expt) {
	   	Util.errorMsg( "Error: unable write to file: " + main.outputfile );
	    System.exit( 1 );
	  }
	  
	  try {
			fp.close();
	  }
	  catch (IOException expt) {}

	  return delt;
	}
// ------------------------- gauss ---------------------	
	static int iset = 0;
	static double gset;
	
	public static double gauss() {
	  double fac, r, v1, v2;
	  
	  if (iset == 0) {
		do {
		  v1 = 2.0 * fitimeb.RAND() - 1.0;
		  v2 = 2.0 * fitimeb.RAND() - 1.0;
		  r = v1 * v1 + v2 * v2;
		} while (r >= 1.0);
		
		fac = Math.sqrt(-2.0 * Math.log(r) / r);
		gset = v1 * fac;
		iset = 1;
		return v2 * fac;
	  }
	  else {
		iset = 0;
		return gset;
	  }
	}
}