import java.io.*;


public class WriteData
{
  public static final int SYSTEM = 0;
  public static final int FILE = 1;
  public static final int FRAME = 2;
  public static final int NONE = 3;
  
  private static int mOutputTo = SYSTEM;

  private FileOutputStream f = null;
  private DataOutputStream fp = null;
  private OutputFrame fr = null;
  
  public WriteData( String name ) throws IOException
  {
	//mOutputTo = FRAME;//NONE; //FILE;

	switch (mOutputTo)
	{
	  case FILE: f = new FileOutputStream( Util.filePath + name ); 
				 fp = new DataOutputStream( f );
				 break;
	  case FRAME: fr = new OutputFrame( name );
				  fr.setSize( 400, 400 );
				  break;
	}
  }
  
  public static void setOutput( int out )
  {
	mOutputTo = out;
  }
  
  public void writeBytes( String s ) throws IOException
  {
	switch (mOutputTo) 
	{
	  case SYSTEM: System.out.println( s );
				   break;
	  case FILE: if (fp != null) 
				   fp.writeBytes( s );
				 break;
	  case FRAME: fr.writeString( s ); 
				  break;
	  case NONE: break;
	}
  }
  
  public void close() throws IOException
  {
	switch (mOutputTo)
	{
	  case FILE: if (fp != null)
				   fp.close();
				 if (f != null)
				   f.close();
				 break;
	  case FRAME: fr.setVisible( true );
				  break;
	}
  }
  
}
