
import java.awt.*;


public class UpperPane extends Panel
{
	
	private Component mActive = null;
	
	public UpperPane()
	{
		super();
	}
	
	private void drawTab( Component c, Graphics g )
	{
		Rectangle d = getBounds();
		Rectangle r = c.getBounds();
		
		g.setColor( Color.black );
		g.drawLine( r.x-4, d.y+d.height-1, r.x-4, d.y+2 );
		g.drawLine( r.x-4, d.y+2, r.x+r.width+1, d.y+2 );
		g.drawLine( r.x+r.width+1, d.y+2, r.x+r.width+1, d.y+d.height-1 );
	}
	
	public void paint( Graphics g )
	{
		super.paint( g );
		
		Rectangle d = getBounds();
		Rectangle r = mActive.getBounds();

		for (int i = 0; i < getComponentCount(); i++)
		{
			drawTab( getComponent( i ), g );
		}
		
		g.setColor( Color.black );
		g.drawLine( d.x, d.height+d.y-1, r.x-4, d.height+d.y-1 );
		g.drawLine( r.x+r.width+1, d.y+d.height-1, d.x+d.width, d.y+d.height-1 );

	}
	
	public void setActiveComponent( Component active )
	{
		for (int i = 0; i < getComponentCount(); i++)
		{
			if ( getComponent(i).getName().equals(active.getName()) )
				mActive = active;
		}
		
		repaint();
	}
	
}
