
import java.awt.*;
import java.awt.event.*;

public class TabPane extends Panel
{
	
	private UpperPane titles;
	private LowerPane panels;
	
	public TabPane()
	{
		super();
		
		setBackground( Color.lightGray );
		
		titles = new UpperPane();
		titles.setLayout( new FlowLayout( FlowLayout.LEFT ) );
		
		panels = new LowerPane();
		panels.setLayout( new CardLayout() );
		
		setLayout( new BorderLayout() );
		add( titles, BorderLayout.NORTH );
		add( panels, BorderLayout.CENTER );
	}
	
	public void addTab( String title, Container contents)
	{
		Button b = new Button( title );
		b.addActionListener( new newListener() );
		titles.add( b );
		panels.add( contents, title );
		if (titles.getComponentCount() == 1)
			titles.setActiveComponent( b );
	}
	
	class newListener implements ActionListener
	{
		public void actionPerformed( ActionEvent e )
		{
			if (e.getSource() instanceof Button)
			{
				Button b = (Button)e.getSource();
				String t = b.getLabel();
				
				((CardLayout)panels.getLayout()).show( panels, t );
				titles.setActiveComponent( b );
			}
		}
	}
	
}
