import java.awt.*;


public class OptionsPanel extends Panel
{
	
	private CheckboxGroup outp;
	private CheckboxGroup grph;

	private static final String OUT_NONE = "None";
	private static final String OUT_FILE = "File";
	private static final String OUT_FRAME = "Frame";
	private static final String OUT_SYSTEM = "System output";
	private static final String GRP_NONE = "None";
	private static final String GRP_2D = "2D";
	private static final String GRP_3D = "3D";
	
	public OptionsPanel()
	{
		super();
		
		setLayout( new GridLayout(0, 1) );
		
		Panel p1 = new Panel();
		p1.setLayout(new FlowLayout());
		p1.add(new Label("Output options"));
		add( p1 );
		
		Panel p2 = new Panel();
		p2.setLayout(new FlowLayout());
    outp = new CheckboxGroup();
		Checkbox c1 = new Checkbox(OUT_NONE, outp, true);
		Checkbox c2 = new Checkbox(OUT_SYSTEM, outp, false);
		Checkbox c3 = new Checkbox(OUT_FRAME, outp, false);
		Checkbox c4 = new Checkbox(OUT_FILE, outp, false);
		p2.add( c1 );
		p2.add( c2 );
		p2.add( c3 );
		p2.add( c4 );
		add( p2 );
		
		Panel p3 = new Panel();
		p3.setLayout(new FlowLayout());
		p3.add(new Label("Graphic options"));
		add( p3 );
		
		Panel p4 = new Panel();
		p4.setLayout(new FlowLayout());
    grph = new CheckboxGroup();
		Checkbox b1 = new Checkbox(GRP_NONE, grph, true);
		Checkbox b2 = new Checkbox(GRP_2D, grph, false);
		Checkbox b3 = new Checkbox(GRP_3D, grph, false);
		b1.setEnabled( false );
		b2.setEnabled( false );
		b3.setEnabled( false );
		p4.add( b1 );
		p4.add( b2 );
		p4.add( b3 );
		add( p4 );
	}
	
	public Insets getInsets()
	{
		return new Insets( 5, 10, 10, 10);
	}

	public void notifyData()
  {
		if (outp != null)
		{
			String label = outp.getSelectedCheckbox().getLabel();
			if (label.equals(OUT_NONE))
				WriteData.setOutput( WriteData.NONE );
			else if (label.equals(OUT_FRAME))
				WriteData.setOutput( WriteData.FRAME );
				else if (label.equals(OUT_SYSTEM))
					WriteData.setOutput( WriteData.SYSTEM );
					else if (label.equals(OUT_FILE))
						WriteData.setOutput( WriteData.FILE );
		}
		
		if (grph != null)
		{
			String label = grph.getSelectedCheckbox().getLabel();
			if (label.equals(GRP_NONE))
				fitimeb.PL = 0;
			else if (label.equals(GRP_2D))
				fitimeb.PL = 1;
				else if (label.equals(GRP_3D))
					fitimeb.PL = 2;
		}
  }
	

	
}
