import java.awt.*;
import java.awt.event.*;
import java.io.*;


public class FilePanel extends Panel
{
  
  private TextField fileName;
  private TextField dirName;
  private CheckboxGroup cbg;
  private Button mBrowse;
				   
  public FilePanel()
  {
	super();
	setLayout( new BorderLayout() );

	Panel p1 = new Panel();
	p1.setLayout( new FlowLayout() );
	fileName = new TextField( "", 30 );
	//fileName.setEditable( false );
	dirName = new TextField( "", 30 );
	//dirName.setEditable( false );

	p1.add( new Label( "INI File" ) );
	p1.add( fileName );
	
	mBrowse = new Button("Browse...");
	mBrowse.addActionListener( new NewListener() );
	p1.add( mBrowse );
	
	Panel p2 = new Panel();
	p2.setLayout( new FlowLayout() );
	
	p2.add( new Label( "Working directory or URL" ) );
	p2.add( dirName );
	
	Panel p3 = new Panel();
	p3.setLayout( new BorderLayout() );
	p3.add( p2, BorderLayout.NORTH );
	
	add(p1, BorderLayout.NORTH);
	add(p3, BorderLayout.CENTER);
	
	Panel p4 = new Panel();
	p4.setLayout(new FlowLayout());
    cbg = new CheckboxGroup();
	Checkbox c1 = new Checkbox("Local File", cbg, true);
	c1.addItemListener(new ItemListener()
	  {
		public void itemStateChanged(ItemEvent evt)
		{
		  if (((Checkbox)evt.getSource()).getState() == true)
		  {
			mBrowse.setEnabled( true );
		  }
		}
	  });
    p4.add( c1 );
	
	Checkbox c2 = new Checkbox("Local URL", cbg, false);
	c2.addItemListener(new ItemListener()
	  {
		public void itemStateChanged(ItemEvent evt)
		{
		  if (((Checkbox)evt.getSource()).getState() == true)
		  {
			mBrowse.setEnabled( false );
		  }
		}
	  });
    p4.add( c2 );
	
	add( p4, BorderLayout.SOUTH );
	
  }
    
  class NewListener implements ActionListener
  {
	public void actionPerformed( ActionEvent e )
	{
	  Frame f = Util.getFrame( FilePanel.this );//new Frame();
	  FileDialog d = new FileDialog( f, "Load INI File" );
	  d.setResizable( false );
	  //Util.setToCenter( d );
	  
	  if (dirName != null) {
		d.setDirectory( dirName.getText() );
	  }
	  
	  String s = null;
	  do
	  {
		if (s != null)
		{
		  Util.errorMsg("Error: File extension must be <.ini>", f);
		}
		d.show();
		s = d.getFile();
		if ( s == null ) return;
	  } while (!s.substring(s.length()-4).equals(".ini"));
	  
	  dirName.setText( d.getDirectory() );
	  fileName.setText( s );
	}
  }

  public void notifyData()
  {
		if (cbg != null)
		{
			if (cbg.getSelectedCheckbox().getLabel().equals("Local File"))
			{
				if (dirName != null)
					Util.filePath = dirName.getText();
				ReadData.setInput( ReadData.FILE );
			}
			if (cbg.getSelectedCheckbox().getLabel().equals("Local URL"))
			{
				Util.filePath = "";
				ReadData.setInput( ReadData.URL );
			}
		}
		
		if (fileName != null)
		  fitimeb.INIFILE = fileName.getText();
  }
}
