import java.awt.*;
import java.awt.event.*;
import java.util.*;


public class DataOutputPanel extends Panel
{
  private static TextArea text = null;
  
  public static void println(String s)
  {
	if (text != null)
	  text.append( s + "\n" );
  }

  private Vector mObjects = null;
  
  public void addNotifier(Object obj)
  {
	if (mObjects == null)
	  mObjects = new Vector();
	mObjects.addElement( obj );
  }
  
  public DataOutputPanel()
  {
		super();
		Button b = new Button("Calculate");
		b.addActionListener( new ActionListener() 
		  {
			public void actionPerformed( ActionEvent e )
			{
			  if (mObjects != null)
			  {
				int count = mObjects.size();
				for (int i = 0; i < count; i++)
				{
				  if (mObjects.elementAt(i) instanceof FilePanel)
				    ((FilePanel)(mObjects.elementAt(i))).notifyData();

					if (mObjects.elementAt(i) instanceof DataInputPanel)
				    ((DataInputPanel)(mObjects.elementAt(i))).notifyData();
					
					if (mObjects.elementAt(i) instanceof OptionsPanel)
				    ((OptionsPanel)(mObjects.elementAt(i))).notifyData();
				}
			  }
				
				Frame f = Util.getFrame( DataOutputPanel.this );
				if (f != null)
					f.setTitle("ARMA Frame: calculating...");
				
				OutputFrame.hideAll();
				
			  text.setText("");
			  main.beginArma();
				
				if (f != null)
					f.setTitle("ARMA Frame: calculated");
			}
		  });
		Panel p = new Panel( new FlowLayout() );
		p.add( b );
		text = new TextArea("Cia bus ishvedami rezultatai...");//, 21, 81);
				//t.setEditable( false );
		setLayout( new BorderLayout() );
		add( p, BorderLayout.NORTH );
		add( text, BorderLayout.CENTER );
		
  }
  
}
