import java.awt.*;

public class DataInputPanel extends Panel
{
  private TextField mM;
  private TextField mS;
  private TextField mR;
  private TextField mK;
  private TextField mW;
  private TextField mV;
  private TextField mF;
  private TextField mEPS;
  private TextField mINP;
  private TextField mSA;
  private TextField mST;
  private TextField mSI;
  private TextField mQmin;
  private TextField mQmax;
  private TextField mT;
  
  public DataInputPanel()
  {
		super();
		setLayout( new GridLayout(0, 1) );
		
		add(new Label("Number of factors (M)"));
		mM = new TextField("1"); 
		add( mM );
		
		add(new Label("Number of rows in matrix c (S)"));
		mS = new TextField("0"); 
		add( mS );
		
		add(new Label("Number of columns of matrix c (R)"));
		mR = new TextField("0"); 
		add( mR );
		
		add(new Label("Number of \"multi-step\" repetitions (K)"));
		mK = new TextField("5"); 
		add( mK );
		
		add(new Label("W 0 means with the one-step structural optimization, W 1 defines the multi-step one (W)"));
		mW = new TextField("0"); 
		add( mW );
		//------
		add(new Label("V 1 means with multi-step prognose, V 0 means without (V)"));
		mV = new TextField("1"); 
		add( mV );
		
		add(new Label("Indicator of variance, F 1 involves variance (F)"));
		mF = new TextField("1"); 
		add( mF );
		
		add(new Label("Indicator of residual printing (EPS)"));
		mEPS = new TextField("0"); 
		add( mEPS );
		
		add(new Label("Indicator of input control (INP)"));
		mINP = new TextField("1"); 
		add( mINP );
				
		add(new Label("Indicator of simulated annealing (SA)"));
		mSA = new TextField("0"); 
		add( mSA );
		
		add(new Label("Temperature of simulated annealing (ST)"));
		mST = new TextField("10000.0"); 
		add( mST );
		
		add(new Label("Number of simulated annealing iterations (SI)"));
		mSI = new TextField("100"); 
		add( mSI );
		
		add(new Label("Minimal number of MA paremeters (Qmin)"));
		mQmin = new TextField("2"); 
		add( mQmin );
		
		add(new Label("Maximal number of MA parameters (Qmax)"));
		mQmax = new TextField("2"); 
		add( mQmax );
		
		add(new Label("Number of data entries in DATAFILE (T)"));
		mT = new TextField("60"); 
		add( mT );
	}

	public Insets getInsets()
	{
		return new Insets( 5, 10, 10, 10);
	}
  
	private Integer getInteger( TextField f )
	{
		Integer i = null;
		try 
		{
			i = Integer.decode( f.getText() );
		}
		catch (NumberFormatException e) {}
		
		if (i != null)
			System.out.println( i.intValue() );
		
		return i;
		
	}
	
	private Double getDouble( TextField f )
	{
		Double i = null;
		try 
		{
			i = Double.valueOf( f.getText() );
		}
		catch (NumberFormatException e) {}
		
		if (i != null)
			System.out.println( i.doubleValue() );
		
		return i;
		
	}

	
	public void notifyData()
  {
		Integer a = null;

		//----------- M -----------
		a = getInteger( mM );
		if (a != null)
			fitimeb.M = a.intValue();
		
		//----------- S -----------
		a = getInteger( mS );
		if (a != null)
			fitimeb.S = a.intValue();
		
		//----------- R -----------
		a = getInteger( mR );
		if (a != null)
			fitimeb.R = a.intValue();
		
		//----------- K -----------
		a = getInteger( mK );
		if (a != null)
			fitimeb.K = a.intValue();
		
		//----------- W -----------
		a = getInteger( mW );
		if (a != null)
			fitimeb.W = a.intValue();
		
		//----------- V -----------
		a = getInteger( mV );
		if (a != null)
			fitimeb.V = a.intValue();
		
		//----------- F -----------
		a = getInteger( mF );
		if (a != null)
			fitimeb.F = a.intValue();
		
		//----------- EPS -----------
		a = getInteger( mEPS );
		if (a != null)
			fitimeb.EPS = a.intValue();
		
		//----------- INP -----------
		a = getInteger( mINP );
		if (a != null)
			fitimeb.INP = a.intValue();
		
		//----------- SA -----------
		a = getInteger( mSA );
		if (a != null)
			fitimeb.SA = a.intValue();

		Double b = null;
		//----------- ST -----------
		b = getDouble( mST );
		if (b != null)
			fitimeb.ST = b.doubleValue();

		//----------- SI -----------
		a = getInteger( mSI );
		if (a != null)
			fitimeb.SI = a.intValue();
		
		//----------- Qmin -----------
		a = getInteger( mQmin );
		if (a != null)
			fitimeb.Qmin = a.intValue();
		
		//----------- Qmax -----------
		a = getInteger( mQmax );
		if (a != null)
			fitimeb.Qmax = a.intValue();
		
		//----------- T -----------
		a = getInteger( mT );
		if (a != null)
			fitimeb.T = a.intValue();
	}

}
