import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;

public class ArmaApplet extends Applet implements Runnable
{
	private String version = "v991219";
	
  private Thread thread;
  private long startTime;
  private ArmaFrame frame;
  
  private Button showB = new Button("Show"); 
  private Button hideB = new Button("Hide");
  
  public ArmaApplet()
  {
	super();
  }
  
  public void init()
  {
  	startTime = System.currentTimeMillis();
	showB.addActionListener( new showButton() );
	hideB.addActionListener( new hideButton() );
	
	System.out.println( version );
	
	Util.codeBase = getCodeBase().toString();
  }
  
  public void start()
  {
    thread = new Thread( this );
    thread.start();
    frame = new ArmaFrame();
    frame.addWindowListener( new newWindowListener() );
    setLayout(new FlowLayout());
    add( showB );
  }
  
  public void stop()
  {
	thread = null;
	frame.setVisible( false );
	OutputFrame.hideAll();
  }
 
  public void run()
  {
	Thread me = Thread.currentThread();
    while (thread == me) 
	{
	  try 
	  {
		Thread.currentThread().sleep(1000);
	  } 
	  catch (InterruptedException e) 
	  {}
	  repaint();
    }
  }
  
  public void paint( Graphics g )
  {
		Dimension d = getSize();
		FontMetrics f = g.getFontMetrics();
		g.setColor( Color.black );
		g.draw3DRect( 1, 1, d.width-3, d.height-3, true );
		String s = "Time elapsed: " + (System.currentTimeMillis() - startTime) / 1000 + "s";
		g.drawString(s, (d.width-f.stringWidth( s ))/2, d.height - 5 );
  }
 
  class showButton implements ActionListener
  {
  	public void actionPerformed(ActionEvent e)
  	{
  		remove( showB );
  		add( hideB );
  		ArmaApplet.this.validate();
  		frame.setVisible( true );
  	}
  }
  
  class hideButton implements ActionListener
  {
  	public void actionPerformed(ActionEvent e)
  	{
	 		remove( hideB );
	 		ArmaApplet.this.validate();
  		add( showB );
  		ArmaApplet.this.validate();
  		frame.setVisible( false );

			OutputFrame.hideAll();
  	}
  }
  
  class newWindowListener extends WindowAdapter {
		public void windowClosing(WindowEvent e) {
			removeAll();
			add( showB );
			ArmaApplet.this.validate();
		}
	}

}
