/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class ExamSchedMIDlet
extends MIDlet
implements CommandListener {
    private Form stage0form;
    private Form stage1form;
    private Form stage2form;
    private Form stage3form;
    private Calendar cal = Calendar.getInstance();
    private TextField examCount = new TextField("Enter number of exams:", "3", 10, 2);
    private String[] moduleList = null;
    private int[] durationList = null;
    private Calendar[][] dateList = null;
    private int[] creditList = null;
    private int[] percentList = null;
    private DateField[] dateFields;
    private int examCountInt = 0;
    private TextField subject = new TextField("Subject:", "m1", 10, 0);
    private TextField credits = new TextField("Credits:", "4", 10, 2);
    private TextField percents = new TextField("Percentage of final grade:", "100", 10, 2);
    private TextField days = new TextField("Days to learn:", "2", 10, 2);
    private TextField dayCount = new TextField("Number of possible exam days:", "3", 10, 2);
    private Command button_ok = new Command("OK", 4, 0);
    private Command button_exit = new Command("Exit", 7, 0);
    private Command button_about = new Command("About", 4, 0);
    private Command button_charts = new Command("Charts", 4, 0);
    int[] bestSchedule = null;
    private int stage = 0;
    private int currentExam = 1;
    private ScheduleProcessor sp = null;

    public ExamSchedMIDlet() {
        this.stage0form = new Form("Exam scheduling program v1.0");
        this.stage0form.append((Item)this.examCount);
        this.stage0form.addCommand(this.button_ok);
        this.stage0form.addCommand(this.button_exit);
        this.stage0form.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.stage0form);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void stage1FormBuild(int n) {
        this.examCountInt = Integer.parseInt(this.examCount.getString());
        this.moduleList = new String[this.examCountInt];
        this.durationList = new int[this.examCountInt];
        this.dateList = new Calendar[this.examCountInt][];
        this.creditList = new int[this.examCountInt];
        this.percentList = new int[this.examCountInt];
        this.subject.setString("m" + new Integer(n).toString());
        this.stage1form = new Form("Exam scheduling program v1.0");
        this.stage1form.append((Item)new StringItem(null, "Enter data for the exam #" + new Integer(n).toString() + ":"));
        this.stage1form.append((Item)this.subject);
        this.stage1form.append((Item)this.credits);
        this.stage1form.append((Item)this.percents);
        this.stage1form.append((Item)this.days);
        this.stage1form.append((Item)this.dayCount);
        this.stage1form.addCommand(this.button_ok);
        this.stage1form.addCommand(this.button_exit);
        this.stage1form.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.stage1form);
    }

    public void stage1FormInit(int n) {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.stage1form);
        this.stage1form.set(0, (Item)new StringItem(null, "Enter data for the exam #" + new Integer(n).toString() + ":"));
        this.subject.setString("m" + new Integer(n).toString());
        this.credits.setString("4");
        this.percents.setString("100");
        this.days.setString("2");
        this.dayCount.setString("3");
    }

    public void stage2FormBuild(int n) {
        int n2 = Integer.parseInt(this.dayCount.getString());
        this.dateFields = new DateField[n2];
        this.stage2form = new Form("Exam scheduling program v1.0");
        this.stage2form.append((Item)new StringItem(null, "Enter possible dates for the exam #" + new Integer(n).toString() + ":"));
        for (int i = 0; i < n2; ++i) {
            this.dateFields[i] = new DateField("Date " + new Integer(i + 1).toString() + ": ", 1);
            this.dateFields[i].setDate(this.cal.getTime());
            this.stage2form.append((Item)this.dateFields[i]);
        }
        this.stage2form.addCommand(this.button_ok);
        this.stage2form.addCommand(this.button_exit);
        this.stage2form.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.stage2form);
    }

    public void getStage2Data(int n) {
        int n2 = Integer.parseInt(this.dayCount.getString());
        this.dateList[n - 1] = new Calendar[n2];
        for (int i = 0; i < n2; ++i) {
            this.dateList[n - 1][i] = Calendar.getInstance();
            this.dateList[n - 1][i].setTime(this.dateFields[i].getDate());
        }
    }

    public void stage3FormBuild() {
        int n;
        boolean bl = false;
        this.stage3form = new Form("Exam scheduling program v1.0");
        String string = new String("");
        for (int i = 0; i < this.dateList.length; ++i) {
            string = string + this.moduleList[i] + ':';
            for (n = 0; n < this.dateList[i].length; ++n) {
                string = string + " " + new Integer(this.dateList[i][n].get(2)).toString() + '-' + new Integer(this.dateList[i][n].get(5)).toString();
            }
            string = string + "\n";
        }
        this.stage3form.append((Item)new StringItem(null, "Possible exam dates (month-day):\n" + string + '\n'));
        int[] nArray = new int[this.creditList.length];
        for (n = 0; n < this.creditList.length; ++n) {
            nArray[n] = this.creditList[n] * this.percentList[n];
        }
        this.sp = new ScheduleProcessor(this.dateList, nArray, this.durationList, 0);
        int[] nArray2 = null;
        nArray2 = this.sp.getBestSchedule();
        this.bestSchedule = new int[this.moduleList.length];
        System.arraycopy(nArray2, 0, this.bestSchedule, 0, nArray2.length);
        string = "";
        for (int i = 0; i < this.dateList.length; ++i) {
            string = string + this.moduleList[i] + ": " + new Integer(this.dateList[i][nArray2[i]].get(2)).toString() + '-' + new Integer(this.dateList[i][nArray2[i]].get(5)).toString() + '\n';
        }
        this.stage3form.append((Item)new StringItem(null, "Optimal exam schedule: " + string));
        this.stage3form.addCommand(this.button_charts);
        this.stage3form.addCommand(this.button_exit);
        this.stage3form.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.stage3form);
    }

    void showAbout() {
        Form form = new Form("About...");
        form.append("Exam scheduling program:\n");
        form.append("Andrius Armonas\n");
        form.append("baubas@andrius.org\n");
        form.append("http://baubas.andrius.org/\n");
        form.append("2004 (c)\n");
        form.addCommand(this.button_exit);
        form.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)form);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.button_ok || command == this.button_about || command == this.button_charts) {
            switch (this.stage) {
                case 0: {
                    if (this.currentExam == 1) {
                        this.stage1FormBuild(1);
                    } else {
                        this.getStage2Data(this.currentExam - 1);
                        this.stage1FormInit(this.currentExam);
                    }
                    ++this.stage;
                    break;
                }
                case 1: {
                    this.moduleList[this.currentExam - 1] = this.subject.getString();
                    this.durationList[this.currentExam - 1] = Integer.parseInt(this.days.getString());
                    this.creditList[this.currentExam - 1] = Integer.parseInt(this.credits.getString());
                    this.percentList[this.currentExam - 1] = Integer.parseInt(this.percents.getString());
                    this.stage2FormBuild(this.currentExam);
                    ++this.currentExam;
                    if (this.currentExam > this.examCountInt) {
                        this.stage = 2;
                        break;
                    }
                    this.stage = 0;
                    break;
                }
                case 2: {
                    this.getStage2Data(this.currentExam - 1);
                    this.stage3FormBuild();
                    this.stage = 3;
                    break;
                }
                case 3: {
                    Graph1 graph1 = new Graph1(this.moduleList, this.dateList, this.durationList, this.bestSchedule);
                    graph1.addCommand(this.button_about);
                    graph1.addCommand(this.button_exit);
                    graph1.setCommandListener(this);
                    this.stage = 4;
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)graph1);
                    break;
                }
                case 4: {
                    this.showAbout();
                    this.stage = 5;
                    break;
                }
                default: {
                    this.notifyDestroyed();
                    break;
                }
            }
        } else {
            this.notifyDestroyed();
        }
    }
}

