/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.methods;

import lt.ktu.gmj.Domain;
import lt.ktu.gmj.Point;
import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultLogger;
import lt.ktu.gmj.Task;
import lt.ktu.gmj.methods.MethodBase;

public class LBayes
extends MethodBase {
    private double aniu;
    private double beta;
    private static final double EPS0 = 0.5;
    private static final double A0 = 1.0;
    private static final double GAMA0 = 0.2;
    private static final double COEF = 0.8;
    private static final double EPS2 = 1.0E-6;
    private static final double EPS3 = 1.0E-6;
    private static final double EPS4 = 1.0E-10;
    private static final double B1 = 1.0E-6;
    private static final double V1 = 1.0E-6;
    private static final double B2 = 0.01;
    private static final double V2 = 1.0;
    private static final int CONV = 1;
    private static final int SL_CONV = 2;
    private double M1;
    private int N2;
    private Point x1Pnt;
    private Point x2Pnt;
    private Point dmlPnt;
    private Point dml1Pnt;
    private Point abPnt;

    public LBayes() {
        this.iterations = 500;
        this.aniu = 0.05;
        this.beta = 0.9;
    }

    private void FillPoint(Point xPnt, double val) {
        int i = 0;
        while (i < xPnt.x.length) {
            xPnt.x[i] = val;
            ++i;
        }
    }

    private void dispersion(double[] x, int n_of_pnts, double[] meandisp) {
        meandisp[0] = 0.0;
        meandisp[1] = 0.0;
        int i = 0;
        while (i < n_of_pnts) {
            meandisp[0] = meandisp[0] + x[i];
            meandisp[1] = meandisp[1] + x[i] * x[i];
            ++i;
        }
        meandisp[0] = meandisp[0] / (double)n_of_pnts;
        meandisp[1] = (meandisp[1] - (double)n_of_pnts * meandisp[0] * meandisp[0]) / (double)(n_of_pnts - 1);
    }

    protected double increment(double x, double a, double b, double dx) {
        return dx > 0.0 ? (x > b ? b : x) : (x < a ? a : (x += dx));
    }

    private void lbayes_dispersion(Point xPnt, Point x1Pnt, double[] meandisp, int n2, Task task) {
        double[] x = new double[n2];
        int i = 0;
        while (i < n2) {
            x1Pnt.x[i < x1Pnt.x.length ? i : 0] = x[i] = task.f(xPnt);
            ++i;
        }
        this.dispersion(x, n2, meandisp);
    }

    public Result run(ResultLogger logger, Task task) {
        Domain domain = task.domain();
        Result result = new Result();
        Result bestres = new Result();
        int n = domain.dimensions().length;
        this.M1 = 0.8 * (double)this.iterations - 2.0;
        this.N2 = 2 * n;
        this.x1Pnt = new Point(domain.defaultPoint);
        this.x2Pnt = new Point(domain);
        this.dmlPnt = new Point(domain);
        this.dml1Pnt = new Point(domain);
        this.abPnt = new Point(domain);
        double[] meandisp = new double[2];
        int n2 = this.N2;
        int am2 = 1;
        int an0 = 1;
        int lo = 1;
        int lb = 1;
        double a1 = 0.0;
        result.point = this.x1Pnt;
        this.lbayes_dispersion(this.x1Pnt, this.x2Pnt, meandisp, n2, task);
        result.value = meandisp[0];
        bestres = new Result(result.iteration, result.point, result.value);
        logger.log(result);
        double f13 = (double)n2 * meandisp[0];
        double f11 = meandisp[1];
        ++result.iteration;
        int i = 0;
        while (i < n) {
            this.abPnt.x[i] = 0.5 * (domain.max[i] - domain.min[i]);
            ++i;
        }
        int m = 0;
        while (m < this.iterations - 1) {
            double dx;
            result = new Result(result.iteration, result.point, result.value);
            double hm0 = 0.2 * Math.pow(m + 1, -this.aniu);
            double sig0 = Math.sqrt(f11);
            this.x1Pnt = new Point(result.point);
            this.x2Pnt = new Point(result.point);
            i = 0;
            while (i < n) {
                dx = hm0 * this.abPnt.x[i];
                this.x1Pnt.x[i] = this.increment(result.point.x[i], domain.min[i], domain.max[i], dx);
                this.x2Pnt.x[i] = this.increment(result.point.x[i], domain.min[i], domain.max[i], -dx);
                this.dmlPnt.x[i] = 2.0 * dx * (task.f(this.x1Pnt) - task.f(this.x2Pnt));
                int n3 = i;
                this.dmlPnt.x[n3] = this.dmlPnt.x[n3] / (this.x1Pnt.x[i] - this.x2Pnt.x[i]);
                this.x1Pnt.x[i] = this.x2Pnt.x[i] = result.point.x[i];
                ++i;
            }
            if (lb > 1) {
                i = 0;
                while (i < n) {
                    this.dmlPnt.x[i] = (this.dmlPnt.x[i] + this.dml1Pnt.x[i] * (double)(lb - 1)) / (double)lb;
                    ++i;
                }
            }
            double s1 = this.dmlPnt.norma() + 1.0E-10;
            double hm = Math.sqrt(hm0) / s1;
            i = 0;
            while (i < n) {
                dx = hm * this.abPnt.x[i] * this.dmlPnt.x[i];
                this.x1Pnt.x[i] = this.increment(result.point.x[i], domain.min[i], domain.max[i], dx);
                this.x2Pnt.x[i] = this.increment(result.point.x[i], domain.min[i], domain.max[i], -dx);
                ++i;
            }
            double hs = 0.0;
            double hs1 = 0.0;
            double hs2 = 0.0;
            i = 0;
            while (i < n) {
                hs += Math.pow((this.x2Pnt.x[i] - this.x1Pnt.x[i]) / this.abPnt.x[i], 2.0);
                hs1 += Math.pow((this.x1Pnt.x[i] - result.point.x[i]) / this.abPnt.x[i], 2.0) + 1.0E-6;
                hs2 += Math.pow((this.x2Pnt.x[i] - result.point.x[i]) / this.abPnt.x[i], 2.0) + 1.0E-6;
                ++i;
            }
            hs = Math.sqrt(hs);
            hs1 = Math.sqrt(hs1);
            hs2 = Math.sqrt(hs2);
            double am = task.f(this.x1Pnt) * hs2 + task.f(this.x2Pnt) * hs1 - result.value * hs;
            am *= 2.0 * hm0;
            double d1 = am /= hs1 * hs2 * (hs1 + hs2);
            if (am < 1.0E-6) {
                d1 = 1.0E-6;
            }
            if (am < 0.01 && m == 0) {
                d1 = 1.0;
            }
            double epsm = hm0 * (a1 += d1 / hm0) / (double)(m + 1);
            if ((double)m < this.M1) {
                if (f11 * (double)(n2 - 1) / (double)n2 < 1.0E-6) {
                    f11 = 2.0E-6;
                    n2 = 2;
                }
                sig0 = Math.sqrt(f11);
                double sigl = hm0 * sig0 * Math.sqrt((double)n / (2.0 * (double)lb)) / d1;
                if (lo != 1) {
                    if (s1 >= sigl) {
                        lo = 1;
                    } else {
                        ++an0;
                    }
                } else if (s1 <= 0.5 * sigl) {
                    lo = 2;
                    ++an0;
                }
            } else {
                ++an0;
            }
            double a3 = (Math.pow(an0, this.beta) + 2.0) * epsm;
            i = 0;
            while (i < n) {
                this.x1Pnt.x[i] = this.increment(result.point.x[i], domain.min[i], domain.max[i], -this.abPnt.x[i] * this.dmlPnt.x[i] / a3);
                ++i;
            }
            this.lbayes_dispersion(this.x1Pnt, this.x2Pnt, meandisp, n2, task);
            double f14 = (double)n2 * meandisp[0];
            if (meandisp[0] <= result.value + 0.5 * sig0 / Math.sqrt(n2)) {
                result.point = this.x1Pnt;
                result.value = meandisp[0];
                f13 = f14;
                f11 = (meandisp[1] + f11 * (double)(++am2 - 1)) / (double)am2;
                lb = 1;
            } else {
                result.value = (f13 += task.f(result.point)) / (double)(am2 == 1 ? lb + 2 * n : lb + n2);
                ++lb;
                this.dml1Pnt = new Point(this.dmlPnt);
            }
            if (result.value < bestres.value) {
                bestres = result;
            }
            logger.log(result);
            ++m;
            ++result.iteration;
        }
        return bestres;
    }
}

