/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.DatasetUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;

public class DefaultCategoryDataset
extends AbstractSeriesDataset
implements CategoryDataset {
    protected String[] seriesNames;
    protected Object[] categories;
    protected Number[][] data;

    public DefaultCategoryDataset(double[][] dArray) {
        this(DatasetUtilities.createNumberArray2D(dArray));
    }

    public DefaultCategoryDataset(Number[][] numberArray) {
        this(null, null, numberArray);
    }

    public DefaultCategoryDataset(String[] stringArray, Number[][] numberArray) {
        this(stringArray, null, numberArray);
    }

    public DefaultCategoryDataset(String[] stringArray, Object[] objectArray, Number[][] numberArray) {
        this.data = numberArray;
        if (numberArray != null) {
            String string = "com.jrefinery.data.resources.DataPackageResources";
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            int n = numberArray.length;
            if (n > 0) {
                if (stringArray != null) {
                    if (stringArray.length != n) {
                        throw new IllegalArgumentException("DefaultCategoryDataset: the number of series names does not match the number of series in the data.");
                    }
                    this.seriesNames = stringArray;
                } else {
                    String string2 = resourceBundle.getString("series.default-prefix") + " ";
                    this.seriesNames = this.generateNames(n, string2);
                }
                int n2 = numberArray[0].length;
                if (objectArray != null) {
                    if (objectArray.length != n2) {
                        throw new IllegalArgumentException("DefaultCategoryDataset: the number of categories does not match the number of categories in the data.");
                    }
                    this.categories = objectArray;
                } else {
                    String string3 = resourceBundle.getString("categories.default-prefix") + " ";
                    this.categories = this.generateNames(n2, string3);
                }
            } else {
                this.seriesNames = null;
                this.categories = null;
            }
        }
    }

    public int getSeriesCount() {
        int n = 0;
        if (this.data != null) {
            n = this.data.length;
        }
        return n;
    }

    public String getSeriesName(int n) {
        if (n >= this.getSeriesCount() || n < 0) {
            throw new IllegalArgumentException("DefaultCategoryDataset.getSeriesName(int): no such series.");
        }
        return this.seriesNames[n];
    }

    public void setSeriesName(int n, String string) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setSeriesName(...): no such series.");
        }
        if (string == null) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setSeriesName(...): null not permitted.");
        }
        this.seriesNames[n] = string;
        this.fireDatasetChanged();
    }

    public void setSeriesNames(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setSeriesNames(): null not permitted.");
        }
        if (stringArray.length != this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setSeriesNames(): the number of series names does not match the data.");
        }
        this.seriesNames = stringArray;
        this.fireDatasetChanged();
    }

    public int getCategoryCount() {
        int n = 0;
        if (this.data != null && this.getSeriesCount() > 0) {
            n = this.data[0].length;
        }
        return n;
    }

    public List getCategories() {
        if (this.categories == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.categories));
    }

    public void setCategories(Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setCategories(...): null not permitted.");
        }
        if (objectArray.length != this.data[0].length) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setCategories(...): the number of categories does not match the data.");
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                throw new IllegalArgumentException("DefaultCategoryDataset.setCategories(...): null category not permitted.");
            }
            ++n;
        }
        this.categories = objectArray;
        this.fireDatasetChanged();
    }

    public Number getValue(int n, Object object) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultCategoryDataset.getValue(...): series index out of range.");
        }
        if (object == null) {
            throw new IllegalArgumentException("DefaultCategoryDataset.getValue(...): null category not allowed.");
        }
        int n2 = this.getCategoryIndex(object);
        if (n2 < 0) {
            throw new IllegalArgumentException("DefaultCategoryDataset.getValue(...): unknown category.");
        }
        return this.data[n][n2];
    }

    public void setValue(int n, Object object, Number number) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setValue: series outside valid range.");
        }
        int n2 = this.getCategoryIndex(object);
        if (n2 < 0) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setValue: unrecognised category.");
        }
        this.data[n][n2] = number;
        this.fireDatasetChanged();
    }

    private int getCategoryIndex(Object object) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.categories.length) {
            if (object.equals(this.categories[n2])) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private String[] generateNames(int n, String string) {
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string2;
            stringArray[n2] = string2 = string + (n2 + 1);
            ++n2;
        }
        return stringArray;
    }
}

