/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractRenderer;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.LegendItem;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public abstract class AbstractCategoryItemRenderer
extends AbstractRenderer
implements CategoryItemRenderer {
    private CategoryPlot plot = null;
    private Paint[] categoriesPaint = null;
    private CategoryToolTipGenerator toolTipGenerator;
    private CategoryURLGenerator urlGenerator;
    private boolean useCategoriesPaint;

    protected AbstractCategoryItemRenderer() {
        this(null, null);
    }

    protected AbstractCategoryItemRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    protected AbstractCategoryItemRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    protected AbstractCategoryItemRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        this.toolTipGenerator = categoryToolTipGenerator;
        this.urlGenerator = categoryURLGenerator;
    }

    public CategoryPlot getPlot() {
        return this.plot;
    }

    public void setPlot(CategoryPlot categoryPlot) {
        this.plot = categoryPlot;
    }

    public boolean getUseCategoriesPaint() {
        return this.useCategoriesPaint;
    }

    public Paint[] getCategoriesPaint() {
        return this.categoriesPaint;
    }

    public void setCategoriesPaint(Paint[] paintArray) {
        Paint[] paintArray2 = this.categoriesPaint;
        this.categoriesPaint = paintArray;
        this.firePropertyChanged("renderer.CategoriesPaint", paintArray2, paintArray);
    }

    public Paint getCategoryPaint(int n) {
        Paint paint = null;
        if (this.categoriesPaint != null) {
            paint = this.categoriesPaint[n % this.categoriesPaint.length];
        }
        return paint;
    }

    public CategoryToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(CategoryToolTipGenerator categoryToolTipGenerator) {
        CategoryToolTipGenerator categoryToolTipGenerator2 = this.toolTipGenerator;
        this.toolTipGenerator = categoryToolTipGenerator;
        this.firePropertyChanged("renderer.ToolTipGenerator", categoryToolTipGenerator2, categoryToolTipGenerator);
    }

    public CategoryURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        CategoryURLGenerator categoryURLGenerator2 = this.urlGenerator;
        this.urlGenerator = categoryURLGenerator;
        this.firePropertyChanged("renderer.URLGenerator", categoryURLGenerator2, categoryURLGenerator);
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, ChartRenderingInfo chartRenderingInfo) {
        this.plot = categoryPlot;
        this.setInfo(chartRenderingInfo);
        if (categoryDataset.getSeriesCount() == 1 && this.categoriesPaint != null) {
            this.useCategoriesPaint = this.categoriesPaint.length > 0;
        }
    }

    public boolean isStacked() {
        return false;
    }

    public Rectangle2D getAxisArea(Rectangle2D rectangle2D) {
        return rectangle2D;
    }

    public Shape getDataClipRegion(Rectangle2D rectangle2D) {
        return rectangle2D;
    }

    public void drawPlotBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, Shape shape) {
        if (categoryPlot.getBackgroundPaint() != null) {
            graphics2D.setPaint(categoryPlot.getBackgroundPaint());
            graphics2D.fill(shape);
        }
        if (categoryPlot.getOutlineStroke() != null && categoryPlot.getOutlinePaint() != null) {
            graphics2D.setStroke(categoryPlot.getOutlineStroke());
            graphics2D.setPaint(categoryPlot.getOutlinePaint());
            graphics2D.draw(shape);
        }
    }

    public LegendItem getLegendItem(int n) {
        String string;
        if (this.plot == null) {
            return null;
        }
        CategoryDataset categoryDataset = this.plot.getCategoryDataset();
        String string2 = string = categoryDataset.getSeriesName(n);
        Shape shape = null;
        Paint paint = this.plot.getSeriesPaint(n);
        Paint paint2 = this.plot.getSeriesOutlinePaint(n);
        Stroke stroke = this.plot.getSeriesStroke(n);
        Stroke stroke2 = this.plot.getSeriesOutlineStroke(n);
        return new LegendItem(string, string2, shape, paint, paint2, stroke, stroke2);
    }

    public abstract void drawCategoryItem(Graphics2D var1, Rectangle2D var2, CategoryPlot var3, ValueAxis var4, CategoryDataset var5, int var6, Object var7, int var8, Object var9);

    public abstract void drawRangeMarker(Graphics2D var1, CategoryPlot var2, ValueAxis var3, Marker var4, Rectangle2D var5, Shape var6);
}

