/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.annotations.Annotation;
import com.jrefinery.chart.annotations.XYAnnotation;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class FastScatterPlot
extends Plot {
    private float[][] data;
    private ValueAxis domainAxis;
    private ValueAxis rangeAxis;
    private List domainMarkers;
    private List rangeMarkers;
    private List annotations;

    public FastScatterPlot(float[][] fArray, ValueAxis valueAxis, ValueAxis valueAxis2) {
        super(null, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f);
        this.data = fArray;
        this.domainAxis = valueAxis;
        this.rangeAxis = valueAxis2;
    }

    public ValueAxis getDomainAxis() {
        return this.domainAxis;
    }

    public ValueAxis getRangeAxis() {
        return this.rangeAxis;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Object object;
        Iterator iterator;
        Object object2;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        double d = 0.0;
        if (this.domainAxis != null) {
            HorizontalAxis horizontalAxis = (HorizontalAxis)((Object)this.domainAxis);
            d = horizontalAxis.reserveHeight(graphics2D, this, rectangle2D);
        }
        double d2 = 0.0;
        if (this.rangeAxis != null) {
            object2 = (VerticalAxis)((Object)this.rangeAxis);
            d2 = object2.reserveAxisArea(graphics2D, this, rectangle2D, d).getWidth();
        }
        object2 = new Rectangle2D.Double(rectangle2D.getX() + d2, rectangle2D.getY(), rectangle2D.getWidth() - d2, rectangle2D.getHeight() - d);
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setDataArea((Rectangle2D)object2);
        }
        this.drawOutlineAndBackground(graphics2D, (Rectangle2D)object2);
        if (this.domainAxis != null) {
            this.domainAxis.draw(graphics2D, rectangle2D, (Rectangle2D)object2);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.draw(graphics2D, rectangle2D, (Rectangle2D)object2);
        }
        Shape shape = graphics2D.getClip();
        Composite composite = graphics2D.getComposite();
        graphics2D.clip((Shape)object2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
        if (this.domainMarkers != null) {
            iterator = this.domainMarkers.iterator();
            while (iterator.hasNext()) {
                object = (Marker)iterator.next();
            }
        }
        if (this.rangeMarkers != null) {
            iterator = this.rangeMarkers.iterator();
            while (iterator.hasNext()) {
                object = (Marker)iterator.next();
            }
        }
        this.render(graphics2D, (Rectangle2D)object2, chartRenderingInfo, null);
        if (this.annotations != null) {
            iterator = this.annotations.iterator();
            while (iterator.hasNext()) {
                object = (Annotation)iterator.next();
                if (!(object instanceof XYAnnotation)) continue;
                XYAnnotation xYAnnotation = (XYAnnotation)object;
                xYAnnotation.draw(graphics2D, (Rectangle2D)object2, this.getDomainAxis(), this.getRangeAxis());
            }
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        Object object;
        Date date = new Date();
        System.out.println("Start: " + date.toString());
        graphics2D.setPaint(Color.red);
        if (this.data != null) {
            object = this.getDomainAxis();
            ValueAxis valueAxis = this.getRangeAxis();
            int n = 0;
            while (n < this.data[0].length) {
                float f = this.data[0][n];
                float f2 = this.data[1][n];
                int n2 = (int)((ValueAxis)object).translateValueToJava2D(f, rectangle2D);
                int n3 = (int)valueAxis.translateValueToJava2D(f2, rectangle2D);
                graphics2D.drawRect(n2, n3, 1, 1);
                ++n;
            }
        }
        object = new Date();
        System.out.println("Finish: " + ((Date)object).toString());
    }

    public String getPlotType() {
        return "Fast Scatter Plot";
    }
}

