/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.TickUnit;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTickUnit
extends TickUnit {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SECOND = 5;
    public static final int MILLISECOND = 6;
    private int unit;
    private int count;
    private DateFormat formatter;

    public DateTickUnit(int n, int n2) {
        this(n, n2, DateFormat.getDateInstance(3));
    }

    public DateTickUnit(int n, int n2, DateFormat dateFormat) {
        super(DateTickUnit.getMillisecondCount(n, n2));
        this.unit = n;
        this.count = n2;
        this.formatter = dateFormat;
    }

    public int getUnit() {
        return this.unit;
    }

    public int getCount() {
        return this.count;
    }

    public String valueToString(double d) {
        return this.formatter.format(new Date((long)d));
    }

    public String dateToString(Date date) {
        return this.formatter.format(date);
    }

    public Date addToDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(this.getCalendarField(this.unit), this.count);
        return calendar.getTime();
    }

    public int getCalendarField() {
        return this.getCalendarField(this.unit);
    }

    private int getCalendarField(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 13;
            }
            case 6: {
                return 14;
            }
        }
        return 14;
    }

    private static long getMillisecondCount(int n, int n2) {
        switch (n) {
            case 0: {
                return 31536000000L * (long)n2;
            }
            case 1: {
                return 2678400000L * (long)n2;
            }
            case 2: {
                return 86400000L * (long)n2;
            }
            case 3: {
                return 3600000L * (long)n2;
            }
            case 4: {
                return 60000L * (long)n2;
            }
            case 5: {
                return 1000L * (long)n2;
            }
            case 6: {
                return n2;
            }
        }
        return n2;
    }
}

