/*
 * Stock Rate Game Model
 * Created by Vytautas Vaitkevicius
 * Modified by Mindaugas Baltutis FMM-7/1
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.lang.*;
import java.util.Random;


/* --------------------------------------
 * Pagrindine klase Stock Game Rate Model
 */
public class StockRateGameModel extends Applet implements Runnable
 {
    SRGMControls controls;  // Valdymo elementai
    SRGMCanvas canv;        // Vaizdavimo erdve
    Thread timer = null;    // Laikmatis
    boolean threadSuspended;
    
    
    // Inicializavimo procedura
    public void init()
     {
      BorderLayout blSRGM=new BorderLayout();
      blSRGM.setHgap(5);  
      blSRGM.setVgap(5);
      setLayout( blSRGM);
	  
	  canv = new SRGMCanvas();
	  add("Center", canv);          // Vaizdavimo erdve patalpinama viduryje
	  add("South", controls = new SRGMControls( canv));      // vald. el. - apacioje
	  threadSuspended = false;
	 }


    // Sunaikinimo procedura
    public void destroy()
     {
        remove(controls);   // Pasalina Vald. el.
        remove(canv);       // Pasalina Vaizd. erdve
     }


    // Paleidimo procedura
    public void start()
     {
	  controls.setEnabled(true);
	  timer = new Thread(this);     // Sukurti laikmati
      timer.start();                // Paleisti laikmati
     }
     
     
    // Sustabdymo procedura 
    public void stop()
     {
	  controls.setEnabled(false);
	  timer = null;                 // Panaikinti laikmati
	  if (threadSuspended) {
            threadSuspended = false;
            notify();
        }
     }
    
    
    // --- Vykdymo procedura ---
    // Joje atliekami kiekvieno ciklo pagrindiniai skaiciavimai 
    public void run()
     {
        
      Thread me = Thread.currentThread();
      while (timer == me)
       {
        try {
             Thread.sleep(200);
             synchronized(this)
              {
               while (threadSuspended) { wait(); }
              }
             } catch (InterruptedException e){}
                        
        // Jei paspaustas "Play" arba "Next"
        if (controls.bPlay || controls.bNext)     
         {
          controls.bNext=false;  
            
          int iBmax, iSmin;         // Kurio kliento maksimali pirkimo ir minimali pardavimo kainos
          int iIterN=canv.iIterN;   // Iteraciju skaicius
          
//MBA atsitiktine kainos dedamoji turetu buti Normaliojo skirstinio
        Random rNorm = new Random();
        double dEps = canv.iNiu*rNorm.nextGaussian();	// MBA Atsitiktine kainos dedamoji
               
          // Perskaiciuojamas iteraciju skaicius
          if (iIterN<50) iIterN++;
          else  // Jei daugiau nei 50 iteraciju, daromas perstumimas
           {    
            for (int i=0; i<iIterN; i++)
             {
              canv.stock.dZ[i]=canv.stock.dZ[i+1];
              for (int j=0; j<canv.iCN; j++)
               {
                canv.customer[j].dZbuy[i] =canv.customer[j].dZbuy[i+1];
                canv.customer[j].dZsell[i]=canv.customer[j].dZsell[i+1];
               } 
             }   
           }
          
          // --- Maks. pirkimo ir min. pardavimo kainu radimas --- 
          // Kurio is klientu pirkimo kaina didesne ? MBA jei lygios pasirenkama atsitiktinai
		  if (canv.customer[0].dZbuy[iIterN-1] >canv.customer[1].dZbuy[iIterN-1] ) iBmax=0;
          else if (canv.customer[0].dZbuy[iIterN-1]==canv.customer[1].dZbuy[iIterN-1] ) iBmax=(int)Math.round(Math.random()); //MBA
          	else iBmax=1;
          
          // Kurio is klientu pardavimo kaina mazesne ?
          // Taip pat tikrinama ar tas klientas turi akciju
          if (canv.customer[0].dZsell[iIterN-1]<canv.customer[1].dZsell[iIterN-1] &&
              canv.customer[0].iN>0) iSmin=0;
		  else if (canv.customer[0].dZsell[iIterN-1]==canv.customer[1].dZsell[iIterN-1]) iSmin=(int)Math.round(Math.random()); //MBA
          	else iSmin=1;
          
          // --- Akciju pirkimas pardavimas ---        
          // Tikrinama ar yra kas parduoda akcija
          if (canv.stock.dZ[iIterN-1]>=canv.customer[iSmin].dZsell[iIterN-1] && canv.customer[iSmin].iN>0) 
           {
             // Nustatoma nauja akcijos kaina ir perskaiciuojamas akciju kiekis
             canv.stock.dZ[iIterN]=canv.customer[iSmin].dZsell[iIterN-1]+dEps;			//MBA dEps nereiketu
             canv.customer[iSmin].dProfit+=canv.customer[iSmin].dZsell[iIterN-1];
             canv.customer[iSmin].iN--;
             canv.stock.iN++;
           }
          // Tikrinama ar yra kas perka akcija. Taip pat ar yra akciju pardavime
          else if (canv.stock.dZ[iIterN-1]<=canv.customer[iBmax].dZbuy[iIterN-1] && canv.stock.iN>0)
                {
                 // Nustatoma nauja akcijos kaina ir perskaiciuojami kiekiai   
                 canv.stock.dZ[iIterN]=canv.customer[iBmax].dZbuy[iIterN-1]+dEps;		//MBA dEps nereiketu
                 canv.customer[iBmax].dProfit-=canv.customer[iBmax].dZbuy[iIterN-1];
                 canv.customer[iBmax].iN++;
                 canv.stock.iN--;
                }
               // Jei niekas nenupirko 
               else canv.stock.dZ[iIterN]=canv.stock.dZ[iIterN-1]+dEps;
               
          if (canv.stock.dZ[iIterN]<0.5) canv.stock.dZ[iIterN]=0.5;
          if (canv.stock.dZ[iIterN]>9.5) canv.stock.dZ[iIterN]=9.5;
                   
                   
		// -------------------------------------         
		// MBA Apskaiciuojami nauji kainu slenksciai
		for (int j=0; j<canv.iCN; j++)
        {
        	if (canv.customer[j].iStrategy>0 && iIterN>1) //jei AR parametras p>0 tai naudoti AR modeli
        	{
        		AR model = new AR(canv.stock.dZ, iIterN, canv.customer[j].iStrategy);	//MBA
        		canv.customer[j].dZpred=model.predict();								//MBA
        	}
        	else canv.customer[j].dZpred=canv.stock.dZ[iIterN-1];
            
            double dBeta=canv.customer[j].dZpred-canv.stock.dZ[iIterN-1];	// Spejamas kainos pokytis
            double dExpectedProfit=dBeta+canv.dDividend-canv.dCDYield;		// Kliento laukiamas pelnas
            
            canv.customer[j].dZbuy[iIterN] =canv.dKbuy* (dExpectedProfit+canv.stock.dZ[iIterN-1]);
            canv.customer[j].dZsell[iIterN]=canv.dKsell*(dExpectedProfit+canv.stock.dZ[iIterN-1]);
		} 
         
          
          // --- Apvalinimas iki dvieju skaiciu po kablelio ---
          // Akcijos kurso apvalinimas iki dvieju skaiciu po kablelio
          canv.stock.dZ[iIterN]=(double)Math.round( 100*canv.stock.dZ[iIterN])/100;         
          
          // Klientu pirkimo pardavimo slenksciu apvalinimas iki dvieju skaiciu po kablelio
          for (int j=0; j<canv.iCN; j++)
           {
            canv.customer[j].dZbuy[iIterN] =(double)Math.round( 100*canv.customer[j].dZbuy[iIterN] )/100;
            canv.customer[j].dZsell[iIterN]=(double)Math.round( 100*canv.customer[j].dZsell[iIterN])/100;
            
            canv.customer[j].dProfAll=canv.customer[j].dProfit+canv.customer[j].iN*canv.stock.dZ[iIterN];
            canv.customer[j].dProfAll=(double)Math.round( 100*canv.customer[j].dProfAll)/100;
           } 
           
         
          // Irasomas perskaiciuotas iteraciju skaicius ir perpiesiama vaizdavimo erdve              
          canv.iIterN=iIterN;
          canv.lProc++;
          canv.repaint();
         } 
       } 
       
     }   


    
    // Ivykio apdorojimo procedura
    public void processEvent(AWTEvent e)
     {
        if (e.getID() == Event.WINDOW_DESTROY)
         {
           System.exit(0);
         }
     }


    // Pagrindine procedura
    public static void main(String args[])
     {
	  Frame f = new Frame("Stock Rate Game Model");
	  StockRateGameModel  srgm = new StockRateGameModel();  // Sukuria modeli

	  srgm.init();  // Inicializuoja modeli
	  srgm.start(); // Paleidzia modeli

	  f.add("Center", srgm);    // Ideda modeli remo centre
	  f.setSize(650, 550);      // Nustato remo dydi
	  f.show();
     }


    // Apleto informacija
    public String getAppletInfo()
     {
      return "Stock Rate Game Model Test.\n Modified by Mindaugas Baltutis,\n Created by Vytautas Vaitkevicius.";
     }
 }


/* -----------------------
 * Akcijos klase SRGMStock
 */
class SRGMStock extends Object
 {
   double   dZ[]=new double[51];
   int      iN;
      
   public SRGMStock( double dZ, int iN)
    { 
     this.dZ[0]=dZ;
     this.iN=iN;
    }

 }


/* --------------------------
 * Kliento klase SRGMCustomer
 */
class SRGMCustomer extends Object
 {
   double   dZbuy[]=  new double[51];
   double   dZsell[]= new double[51];
   double   dZpred;   // Spejamas akciju kursas
   double   dProfit, dProfAll;
   int      iN;			//akciju kiekis
	int		iStrategy;	//MBA losimo strategija
		  

   public SRGMCustomer( double dZbuy, double dZsell, int iN, int iStrategy)
    {
     this.dZbuy[0] =dZbuy;
     this.dZsell[0]=dZsell;
     this.dZpred=(dZbuy+dZsell)/2;  // Spejamas akciju kursas
     this.iN=iN;
     this.iStrategy=iStrategy;
     this.dProfit=0;
     this.dProfAll=0;
    }

 }



/* ----------------------------------
 * Vaizdavimo erdves klase SRGMCanvas
 */
class SRGMCanvas extends Canvas
 {
    
    Font	font;
    
    double dKbuy=0.98, dKsell=1.02; // Pirkimo pardavimo koeficientai
    double dDividend=0.01; 			// Dividentu dydis
    double dCDYield=0.01; 			// Palukanu dydis
        
    SRGMStock       stock=new SRGMStock( 5.00, 50);     // Akcijos objekto sukurimas
    SRGMCustomer    customer[]=new SRGMCustomer[2]; 	// Klientu masyvo sukurimas
    int             iCN=2;      // Klientu skaicius
    int             iIterN=0;   // Iteracijos nr 50 demenu masyve
    long			lProc=0;	// MBA Proceso tekme
    double 			iNiu=0.09;	// MBA (Stock Volatility) ats.d. standartinis nuokrypis
    
    
    // SRGMCanvas konstruktorius
    public SRGMCanvas()
     {
      customer[0]=new SRGMCustomer( 4.86, 5.13, 0, 0); // Kliento 1 sukurimas
      customer[1]=new SRGMCustomer( 4.86, 5.13, 0, 0); // Kliento 2 sukurimas  
     }
    
    
    
    // Vaizdavimo procedura
    public void paint(Graphics g)
     {
      
      int hlines = 100;  // Horizontaliu tinklelio liniju skaicius
      int vlines = 50;  // Vertikaliu tinklelio liniju skaicius
      
      int iX=125, iY=700;  // Koordinaciu pradzios x ir y reiksmes
      int iDX=10, iDY=20;  // x ir y asiu mastelio reiksmes

      // Perskaiciuojamas iY, kad visada matytume paskutine reiksme centre
      iY=200+(int)(stock.dZ[iIterN]+0.5)*10*iDY;
      //iY=200+(int)(stock.dZ[iIterN]*10*iDY);
      
      Color cl=new Color( 180, 180, 180);   // Sukuriama tinklelio spalva
      // Piesiamos horizontalios tinklelio linijos
      g.setColor( cl);
      for (int i=0; i<=hlines; i++)
        g.drawLine( iX, iY-i*iDY, iX+vlines*10, iY-i*iDY);

      // Piesiamos vertikalios tinklelio linijos
      for (int i=0; i<=vlines; i++)
        g.drawLine( iX+i*10, iY, iX+i*10, iY-hlines*iDY);
      
      cl=new Color( 128, 128, 128); // Sukuriama sveiku skaiciu spalva
      // Piesiamos horizontalios sveiku skaiciu linijos
      g.setColor( cl);
      for (int i=0; i<=10; i++)
        g.drawLine( iX, iY-10*iDY*i, iX+vlines*10, iY-10*iDY*i);
      
      
      // Piesiamas akcijos kurso grafikas
      cl=new Color( 0, 0, 128);     // Sukuriamas akcijos kurso grafiko spalva
      g.setColor( cl);	  
      for (int j=0; j<iIterN; j++)
       {
        g.drawLine( iX+j*iDX, iY-(int)(10*iDY*stock.dZ[j]), iX+(j+1)*iDX, iY-(int)(10*iDY*stock.dZ[j+1]));
       }
	  g.drawString("z(t) = " + stock.dZ[iIterN], 10, 30);   // Uzrasomas akcijos kursas
	  g.drawString("N =    " + stock.iN, 10, 50);              // Uzrasomas akciju kiekis
	  g.drawString("Dividend = " + dDividend, 10, 70);      // Uzrasomas dividentu dydis
	  g.drawString("Yield CD = " + dCDYield, 10,  90);      // Uzrasomas palukanu dydis
	  g.drawString("k        = " + dKbuy, 10, 110);          // Uzrasomas pirkimo slenkscio koeficientas
	  g.drawString( "buy", 16, 117);
	  g.drawString("k        = " + dKsell, 10, 130);         // Uzrasomas pardavimo slenkscio koeficientas
	  g.drawString( "sell", 16, 137);
	        
      int ip=0;
      // Piesiami klientu pirkimo ir pardavimo kainu grafikai
      for (int i=0; i<iCN; i++)
       {
        cl=new Color( 96*i, 96-96*i, 96);   // Skukuriama kliento grafiku spalva
        g.setColor( cl);	  
        
        // Piesiamas grafikas
        for (int j=0; j<iIterN; j++)
         {
          g.drawLine( iX+j*iDX, iY-(int)(10*iDY*customer[i].dZbuy[j] ), iX+(j+1)*iDX, iY-(int)(10*iDY*customer[i].dZbuy[j+1] ));
          g.drawLine( iX+j*iDX, iY-(int)(10*iDY*customer[i].dZsell[j]), iX+(j+1)*iDX, iY-(int)(10*iDY*customer[i].dZsell[j+1]));
         }
        
        // Uzrasomas klientas, jo akciju kiekis, pirkimo ir pardavimo slenkstis
        ip=i+1;
        g.drawString( "Customer " + ip, 10, 30+ip*140);
        g.drawString( "N = " + customer[i].iN, 10, 50+ip*140);
        g.drawString( "z       (t) = " + customer[i].dZbuy[iIterN], 10, 70+ip*140);
        g.drawString( "buy", 16, 65+ip*140);
        g.drawString( " " + ip, 16, 77+ip*140);
        g.drawString( "z       (t) = " + customer[i].dZsell[iIterN], 10, 95+ip*140);
        g.drawString( "sell", 16, 90+ip*140);
        g.drawString( " " + ip, 16, 102+ip*140);
        g.drawString( "Profit = " + customer[i].dProfAll, 10, 115+ip*140);
       } 
	//MBA uzrasomas proceso momentas
    cl=new Color( 0, 0, 0);   // Skukuriama nauja spalva
    g.setColor( cl);	  
	g.drawString( "Process = " + lProc, 10, 150+ip*140);
	  
     }

    
}



/* -----------------------------------
 * Valdymo elementu klase SRGMControls
 */
class SRGMControls extends Panel
                  implements ActionListener
{
    
    TextField tfKbuy;       // Tekstinis laukelis ivesti pirkimo koeficientui
    TextField tfKsell;      // Tekstinis laukelis ivesti pardavimo koeficientui
    TextField tfDividend;   // Tekstinis laukelis ivesti dividentu dydziui
    TextField tfCDYield;    // Tekstinis laukelis ivesti palukanu dydziui
    TextField tfStockV;		//MBA Tekstinis laukelis ivesti akciju nepastovumui
    Choice chCustomer;		//MBA pirkeju sarasas
    Choice chStrategy;		//MBA strategiju sarasas
    Button btPlayPause=null;
    Button btNext=null;
    Label lbPav;
    
    SRGMCanvas canv;
    boolean bPlay=false;
    boolean bNext=false;


    // SRGMControls konstruktorius
	public SRGMControls(SRGMCanvas canv)
    {
      this.canv = canv;
      
      GridLayout glControls=new GridLayout( 3, 8 );
      glControls.setHgap( 5);
      glControls.setVgap( 2);
      setLayout( glControls);
      
      Color clText=new Color( 0, 0, 128);   // Sukuriama teksto spalva
      setForeground( clText);
      
      add(lbPav = new Label());
      add(lbPav = new Label("Volatility",Label.LEFT));
      add(lbPav = new Label( "Dividend", Label.RIGHT));  
      add(tfDividend = new TextField( "0.01", 4));  	// Sukuriamas ir idedamas dividentu TL      
      add(lbPav = new Label( "Kbuy", Label.RIGHT));  
      add(tfKbuy     = new TextField( "0.98", 4));  	// Sukuriamas ir idedamas pirk. koef. TL
      add(lbPav = new Label( "Customer", Label.RIGHT));  
      
      // MBA Sukuriamas ir idemamas pirkeju pasirinkimo sarasas
      add(chCustomer= new Choice()	);
      chCustomer.addItem(" 1 st");
      chCustomer.addItem(" 2 nd");
      
      add(lbPav = new Label()); 
	  add(tfStockV  = new TextField( String.valueOf(canv.iNiu), 4));  // MBA Sukuriamas ir idedamas akciju nepastovumo TL
      add(lbPav = new Label( "Yield of CD", Label.RIGHT));  
      add(tfCDYield  = new TextField( "0.01", 4));  	// Sukuriamas ir idedamas palukanu TL
      add(lbPav = new Label( "Ksell", Label.RIGHT));  
      add(tfKsell    = new TextField( "1.02", 4)); 		// Sukuriamas ir idedamas pard. koef. TL
      add(lbPav = new Label( "Strategy", Label.RIGHT));  
      
	  // MBA Sukuriamas ir idemamas strategiju pasirinkimo sarasas
	  add(chStrategy= new Choice()	);
      chStrategy.addItem(" Wiener's");
      chStrategy.addItem(" AR 1");
      chStrategy.addItem(" AR 2");
      chStrategy.addItem(" AR 3");
      chStrategy.addItem(" AR 4");
      chStrategy.addItem(" AR 5");
      chStrategy.addItem(" AR 6");
      chStrategy.addItem(" AR 7");
      chStrategy.addItem(" AR 8");
      chStrategy.addItem(" AR 9");
      chStrategy.addItem(" AR 10");
      chStrategy.select(canv.customer[0].iStrategy);	//MBA parodo pradine 1-mo pirk.strat.
      
      add(lbPav = new Label());
	  add(lbPav = new Label());  
	  add(lbPav = new Label());
	  
	  btPlayPause=new Button( " Play ");    // Sukuriamas "Play/Pause" mygtukas
	  btPlayPause.addActionListener( this); // "Play/Pause" mygtukas idedamas i veiksmus
	  add( btPlayPause);                    // Idedamas "Play/Pause" mygtukas	    
	  
	  add(lbPav = new Label());
	  btNext=new Button( "Next");      		// Sukuriamas "Next" mygtukas
	  btNext.addActionListener( this); 		// "Next" mygtukas idedamas i veiksmus
	  add( btNext);                    		// Idedamas "Next" mygtukas

       	//MBA sukuriama vidine ItemListener veiskmu apdorojimo klase
		ItemListener chListener = new ItemListener()
		{
			public void itemStateChanged(ItemEvent e)
			{
				choiceChanged(e);
			}
		};
	//MBA sarasams priskiriama veiksmu apdorojimo klase
	chCustomer.addItemListener(chListener);
	chStrategy.addItemListener(chListener);
	}
	
	//MBA sarasu apdorojimo procedura
	public void choiceChanged(ItemEvent event)
	{
		Object anObject = event.getItemSelectable();
		if (anObject == chCustomer)
		{
			int iSelected = chCustomer.getSelectedIndex();
			chStrategy.select(canv.customer[iSelected].iStrategy);
		}
		else if (anObject == chStrategy)
		{
			int iSelected = chCustomer.getSelectedIndex();
			canv.customer[iSelected].iStrategy = chStrategy.getSelectedIndex();
		}
	}


    // Veiksmu apdorojimo procedura
    public void actionPerformed(ActionEvent ev)
     {
      String label = ev.getActionCommand();
      
      
      canv.dKbuy     =Double.valueOf(     tfKbuy.getText().trim() ).doubleValue();
      canv.dKsell    =Double.valueOf(    tfKsell.getText().trim() ).doubleValue();
      canv.dDividend =Double.valueOf( tfDividend.getText().trim() ).doubleValue();
      canv.iNiu 	 =Double.valueOf(   tfStockV.getText().trim() ).doubleValue(); //MBA
      
      
      // Jei paspaustas mygtukas "Play", paleisti ir pakeisti mygtuka i "Pause"
      if (label.equals(" Play "))
       {
        bPlay=true;
        btPlayPause.setLabel( "Pause");
       } 
      // Jei paspaustas mygtukas "Pause", sustabdyti ir pakeisti mygtuka i "Play" 
      if (label.equals("Pause"))
       {
         bPlay=false;
         btPlayPause.setLabel( " Play ");
       }  
       
      // Jei paspaustas mygtukas "Next", parodyti viena iteracija 
      if (label.equals("Next"))
       {
         bPlay=false;
         btPlayPause.setLabel( " Play ");
         bNext=true;
       } 
     }
}