/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util.spinner;

import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import symantec.itools.awt.Orientation;
import symantec.itools.awt.util.spinner.SpinButtonPanel;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public abstract class Spinner
extends Panel
implements Orientation,
Serializable {
    protected static int ORIENTATION_DEFAULT;
    protected String text;
    protected int textWidth = 0;
    protected int orientation;
    protected boolean wrappable;
    protected boolean editable;
    protected int min = 0;
    protected int max = 0;
    protected int current = 0;
    protected int increment = 1;
    protected VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected ResourceBundle errors;
    protected ActionListener actionListener;
    protected CurrentVeto currentVeto;
    protected MaxVeto maxVeto;
    protected MinVeto minVeto;
    protected Action action;
    protected boolean added = false;
    TextField textFld;
    SpinButtonPanel buttons;

    public Spinner() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        super.setLayout(gridBagLayout);
        this.setSize(61, 20);
        this.textFld = new TextField();
        this.textFld.setBounds(0, 0, 100, 20);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.textFld, gbc);
        this.add(this.textFld);
        this.buttons = new SpinButtonPanel();
        this.buttons.setLayout(new GridLayout(2, 1, 0, 0));
        this.buttons.setBounds(100, 0, 3, 20);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.05;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.buttons, gbc);
        this.add(this.buttons);
        this.textFld.setEditable(false);
        try {
            this.setWrappable(false);
            this.setOrientation(ORIENTATION_DEFAULT);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void setEnabled(boolean f) {
        this.buttons.setEnabled(f);
        this.textFld.setEnabled(f);
    }

    public void setEditable(boolean f) throws PropertyVetoException {
        if (this.editable != f) {
            Boolean oldValue = new Boolean(this.editable);
            Boolean newValue = new Boolean(f);
            this.vetos.fireVetoableChange("editable", oldValue, newValue);
            this.editable = f;
            this.textFld.setEditable(this.editable);
            this.changes.firePropertyChange("editable", oldValue, newValue);
        }
    }

    public boolean getEditable() {
        return this.editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setOrientation(int o) throws PropertyVetoException {
        if (this.orientation != o) {
            Integer oldValue = new Integer(this.orientation);
            Integer newValue = new Integer(o);
            this.vetos.fireVetoableChange("orientation", oldValue, newValue);
            this.orientation = o;
            this.buttons.setOrientation(this.orientation);
            this.changes.firePropertyChange("orientation", oldValue, newValue);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setWrappable(boolean f) throws PropertyVetoException {
        if (this.wrappable != f) {
            Boolean oldValue = new Boolean(this.wrappable);
            Boolean newValue = new Boolean(f);
            this.vetos.fireVetoableChange("wrappable", oldValue, newValue);
            this.wrappable = f;
            this.updateButtonStatus();
            this.changes.firePropertyChange("wrappable", oldValue, newValue);
        }
    }

    public boolean getWrappable() {
        return this.wrappable;
    }

    public boolean isWrappable() {
        return this.wrappable;
    }

    public Dimension getPreferredSize() {
        Dimension textFldDim = this.textFld.getPreferredSize();
        Dimension btnsDim = this.buttons.getPreferredSize();
        return new Dimension(textFldDim.width + btnsDim.width, Math.max(textFldDim.height, btnsDim.height));
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setMin(int i) throws PropertyVetoException {
        if (this.min != i) {
            Integer oldValue = new Integer(this.min);
            Integer newValue = new Integer(i);
            this.vetos.fireVetoableChange("min", oldValue, newValue);
            this.min = i;
            if (this.getCurrent() < this.min) {
                this.setCurrent(this.min);
            } else {
                this.updateButtonStatus();
            }
            this.changes.firePropertyChange("min", oldValue, newValue);
        }
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int i) throws PropertyVetoException {
        if (this.max != i) {
            Integer oldValue = new Integer(this.max);
            Integer newValue = new Integer(i);
            this.vetos.fireVetoableChange("max", oldValue, newValue);
            this.max = i;
            if (this.getCurrent() > this.max) {
                this.setCurrent(this.max);
            } else {
                this.updateButtonStatus();
            }
            this.changes.firePropertyChange("max", oldValue, newValue);
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setCurrent(int i) throws PropertyVetoException {
        if (this.current != i) {
            Integer oldValue = new Integer(this.current);
            Integer newValue = new Integer(i);
            this.vetos.fireVetoableChange("current", oldValue, newValue);
            this.current = i;
            this.updateText(false);
            this.updateButtonStatus();
            this.changes.firePropertyChange("current", oldValue, newValue);
        }
    }

    public int getCurrent() {
        if (this.validateText()) {
            Integer i = new Integer(this.textFld.getText());
            this.current = i;
        }
        return this.current;
    }

    public void setNotifyWhilePressed(boolean f) throws PropertyVetoException {
        if (f != this.buttons.getNotifyWhilePressed()) {
            Boolean oldValue = new Boolean(this.getNotifyWhilePressed());
            Boolean newValue = new Boolean(f);
            this.vetos.fireVetoableChange("notifyWhilePressed", oldValue, newValue);
            this.buttons.setNotifyWhilePressed(f);
            this.changes.firePropertyChange("notifyWhilePressed", oldValue, newValue);
        }
    }

    public boolean isNotifyWhilePressed() {
        return this.buttons.isNotifyWhilePressed();
    }

    public boolean getNotifyWhilePressed() {
        return this.isNotifyWhilePressed();
    }

    public void setDelay(int d) throws PropertyVetoException {
        if (d != this.buttons.getDelay()) {
            Integer oldValue = new Integer(this.buttons.getDelay());
            Integer newValue = new Integer(d);
            this.vetos.fireVetoableChange("delay", oldValue, newValue);
            this.buttons.setDelay(d);
            this.changes.firePropertyChange("delay", oldValue, newValue);
        }
    }

    public int getDelay() {
        return this.buttons.getDelay();
    }

    public String getEntryFieldText() {
        return this.textFld.getText();
    }

    public void setLayout(LayoutManager lm) {
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.added = true;
        this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        if (this.action == null) {
            this.action = new Action();
            this.buttons.addActionListener(this.action);
            this.textFld.addActionListener(this.action);
        }
        if (this.currentVeto == null) {
            this.currentVeto = new CurrentVeto();
            this.addCurrentListener(this.currentVeto);
        }
        if (this.maxVeto == null) {
            this.maxVeto = new MaxVeto();
            this.addMaxListener(this.maxVeto);
        }
        if (this.minVeto == null) {
            this.minVeto = new MinVeto();
            this.addMinListener(this.minVeto);
        }
        this.updateText(true);
    }

    public synchronized void removeNotify() {
        if (this.action != null) {
            this.textFld.removeActionListener(this.action);
            this.buttons.removeActionListener(this.action);
            this.action = null;
        }
        if (this.currentVeto != null) {
            this.removeCurrentListener(this.currentVeto);
            this.currentVeto = null;
        }
        if (this.maxVeto != null) {
            this.removeMaxListener(this.maxVeto);
            this.maxVeto = null;
        }
        if (this.minVeto != null) {
            this.removeMinListener(this.minVeto);
            this.minVeto = null;
        }
        super.removeNotify();
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public synchronized void addCurrentListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("current", listener);
    }

    public synchronized void removeCurrentListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("current", listener);
    }

    public synchronized void addCurrentListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("current", listener);
    }

    public synchronized void removeCurrentListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("current", listener);
    }

    public synchronized void addMaxListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("max", listener);
    }

    public synchronized void removeMaxListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("max", listener);
    }

    public synchronized void addMaxListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("max", listener);
    }

    public synchronized void removeMaxListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("max", listener);
    }

    public synchronized void addMinListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("min", listener);
    }

    public synchronized void removeMinListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("min", listener);
    }

    public synchronized void addMinListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("min", listener);
    }

    public synchronized void removeMinListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("min", listener);
    }

    protected boolean isValidCurrentValue(int i) {
        return i <= this.max && i >= this.min;
    }

    protected boolean isValidMaxValue(int i) {
        return i >= this.min;
    }

    protected boolean isValidMinValue(int i) {
        return i <= this.max;
    }

    protected void sourceActionEvent(String s) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, s));
        }
    }

    protected void scrollUp() {
        try {
            if (this.validateText()) {
                Integer i = new Integer(this.textFld.getText());
                this.current = i;
            }
            this.setCurrent(this.current + this.increment);
        }
        catch (PropertyVetoException propertyVetoException) {
            if (this.wrappable) {
                try {
                    this.setCurrent(this.min);
                }
                catch (PropertyVetoException propertyVetoException2) {}
            }
            try {
                this.setCurrent(this.max);
            }
            catch (PropertyVetoException propertyVetoException3) {}
        }
        this.updateText(false);
    }

    protected void scrollDown() {
        try {
            if (this.validateText()) {
                Integer i = new Integer(this.textFld.getText());
                this.current = i;
            }
            this.setCurrent(this.current - this.increment);
        }
        catch (PropertyVetoException propertyVetoException) {
            if (this.wrappable) {
                try {
                    this.setCurrent(this.max);
                }
                catch (PropertyVetoException propertyVetoException2) {}
            }
            try {
                this.setCurrent(this.min);
            }
            catch (PropertyVetoException propertyVetoException3) {}
        }
        this.updateText(false);
    }

    protected void updateText(boolean force) {
        String currentText = this.getCurrentText();
        if (force || !this.textFld.getText().equals(currentText)) {
            ((TextComponent)this.textFld).setText(currentText);
        }
    }

    protected void updateButtonStatus() {
        if (this.buttons != null) {
            if (this.wrappable) {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(true);
            } else if (this.current == this.max && this.current == this.min) {
                this.buttons.setUpButtonEnabled(false);
                this.buttons.setDownButtonEnabled(false);
            } else if (this.current == this.max) {
                this.buttons.setUpButtonEnabled(false);
                this.buttons.setDownButtonEnabled(true);
            } else if (this.current == this.min) {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(false);
            } else {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(true);
            }
        }
    }

    protected abstract String getCurrentText();

    protected boolean validateText() {
        return false;
    }

    class Action
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof TextField && (TextField)e.getSource() == Spinner.this.textFld) {
                if (Spinner.this.validateText()) {
                    Spinner.this.current = new Integer(Spinner.this.textFld.getText());
                }
                Spinner.this.updateText(false);
                Spinner.this.requestFocus();
                return;
            }
            String cmdStr = "";
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("Increment")) {
                Spinner.this.scrollUp();
                cmdStr = "ScrollUp";
                Spinner.this.sourceActionEvent(cmdStr);
            } else if (actionCommand.equals("Decrement")) {
                Spinner.this.scrollDown();
                cmdStr = "ScrollDown";
                Spinner.this.sourceActionEvent(cmdStr);
            }
        }

        Action() {
            Spinner.this = Spinner.this;
        }
    }

    class CurrentVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!Spinner.this.isValidCurrentValue(i)) {
                throw new PropertyVetoException(String.valueOf(Spinner.this.errors.getString("InvalidCurrentValue")) + i, e);
            }
        }

        CurrentVeto() {
            Spinner.this = Spinner.this;
        }
    }

    class MaxVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!Spinner.this.isValidMaxValue(i)) {
                throw new PropertyVetoException(String.valueOf(Spinner.this.errors.getString("InvalidMaxValue")) + i, e);
            }
        }

        MaxVeto() {
            Spinner.this = Spinner.this;
        }
    }

    class MinVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!Spinner.this.isValidMinValue(i)) {
                throw new PropertyVetoException(String.valueOf(Spinner.this.errors.getString("InvalidMinValue")) + i, e);
            }
        }

        MinVeto() {
            Spinner.this = Spinner.this;
        }
    }
}

