/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util.spinner;

import java.awt.FontMetrics;
import java.awt.TextComponent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import symantec.itools.awt.util.spinner.Spinner;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class ListSpinner
extends Spinner {
    protected Vector list;
    protected boolean dynamicResizing;
    protected int internalMax;
    protected String oldText = "";
    protected boolean isPossibleEdit = false;
    private boolean editAdding = false;
    private Focus focus;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ListSpinner() {
        this.list = new Vector();
        try {
            this.setAllowDynamicResizing(false);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.max = 10;
        this.updateInternalMax();
        this.updateButtonStatus();
    }

    public void setListItems(String[] items) throws PropertyVetoException {
        String[] oldValue = this.getListItems();
        if (!GeneralUtils.objectsEqual(oldValue, items)) {
            this.vetos.fireVetoableChange("listItems", oldValue, items);
            this.list = new Vector();
            int i = 0;
            while (i < items.length) {
                this.addItem(items[i]);
                ++i;
            }
            this.updateInternalMax();
            if (!this.isValidCurrentValue(this.getCurrent())) {
                this.setCurrent(this.internalMax);
            }
            this.updateButtonStatus();
            this.updateText(false);
            this.changes.firePropertyChange("listItems", oldValue, items);
        }
    }

    public String[] getListItems() {
        int len = this.list.size();
        String[] items = new String[len];
        int i = 0;
        while (i < len) {
            items[i] = (String)this.list.elementAt(i);
            ++i;
        }
        return items;
    }

    public void setAllowDynamicResizing(boolean f) throws PropertyVetoException {
        if (this.dynamicResizing != f) {
            Boolean oldValue = new Boolean(this.dynamicResizing);
            Boolean newValue = new Boolean(f);
            this.vetos.fireVetoableChange("allowDynamicResizing", oldValue, newValue);
            this.dynamicResizing = f;
            this.changes.firePropertyChange("allowDynamicResizing", oldValue, newValue);
        }
    }

    public boolean isAllowDynamicResizing() {
        return this.dynamicResizing;
    }

    public String getCurrentText() {
        return this.list.size() > 0 ? (String)this.list.elementAt(this.current) : "";
    }

    public void setMax(int i) throws PropertyVetoException {
        if (this.max != i) {
            Integer oldValue = new Integer(this.max);
            Integer newValue = new Integer(i);
            this.vetos.fireVetoableChange("max", oldValue, newValue);
            this.max = i;
            if (this.getCurrent() > this.max) {
                this.setCurrent(this.max);
            } else {
                this.updateInternalMax();
                this.updateButtonStatus();
            }
            this.changes.firePropertyChange("max", oldValue, newValue);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.focus == null) {
            this.focus = new Focus();
            this.textFld.addFocusListener(this.focus);
        }
        if (this.list.size() > 0) {
            int oldTextWidth = this.textWidth;
            Enumeration e = this.list.elements();
            while (e.hasMoreElements()) {
                this.textWidth = Math.max(this.textWidth, ((String)e.nextElement()).length());
            }
            this.text = (String)this.list.elementAt(this.current);
        }
    }

    public synchronized void removeNotify() {
        if (this.focus != null) {
            this.textFld.removeFocusListener(this.focus);
            this.focus = null;
        }
        super.removeNotify();
    }

    public void addItem(String s) {
        int oldTextWidth = this.textWidth;
        this.list.addElement(s);
        this.textWidth = Math.max(this.textWidth, s.length());
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }

    public synchronized void addMaxListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("max", listener);
    }

    public synchronized void removeMaxListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("max", listener);
    }

    public synchronized void addMaxListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("max", listener);
    }

    public synchronized void removeMaxListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("max", listener);
    }

    protected String truncateContents(String contents) {
        if (this.added) {
            FontMetrics fm = this.getFontMetrics(this.textFld.getFont());
            int stringWidth = fm.stringWidth(contents);
            if (stringWidth <= 0) {
                return "";
            }
            int charWidth = fm.stringWidth("W");
            int textFieldPadWidth = this.textFld.getPreferredSize((int)1).width - charWidth;
            int maxTextWidth = this.textFld.getSize().width - textFieldPadWidth;
            if (maxTextWidth < 0) {
                maxTextWidth = 0;
            }
            String testString = contents;
            int stringIndex = testString.length();
            while (stringIndex > 0 && fm.stringWidth(testString) > maxTextWidth - charWidth) {
                testString = contents.substring(0, stringIndex);
                --stringIndex;
            }
            if (stringIndex != contents.length()) {
                testString = String.valueOf(testString) + "...";
                while (stringIndex > 0 && fm.stringWidth(testString) > maxTextWidth - charWidth) {
                    testString = String.valueOf(contents.substring(0, stringIndex)) + "...";
                    --stringIndex;
                }
            }
            return testString;
        }
        return "";
    }

    protected void scrollUp() {
        try {
            this.setCurrent(this.current + this.increment);
        }
        catch (PropertyVetoException propertyVetoException) {
            if (this.isWrappable()) {
                try {
                    this.setCurrent(this.min);
                }
                catch (PropertyVetoException propertyVetoException2) {}
            }
            try {
                this.setCurrent(this.internalMax);
            }
            catch (PropertyVetoException propertyVetoException3) {}
        }
        this.updateText(true);
    }

    protected void scrollDown() {
        try {
            this.setCurrent(this.current - this.increment);
        }
        catch (PropertyVetoException propertyVetoException) {
            if (this.isWrappable()) {
                try {
                    this.setCurrent(this.internalMax);
                }
                catch (PropertyVetoException propertyVetoException2) {}
            }
            try {
                this.setCurrent(this.min);
            }
            catch (PropertyVetoException propertyVetoException3) {}
        }
        this.updateText(false);
    }

    protected void updateText(boolean force) {
        boolean isListEmpty;
        String currentText = this.getCurrentText();
        String truncContents = this.truncateContents(currentText);
        String textFieldContents = this.textFld.getText();
        boolean bl = isListEmpty = this.list == null || this.list.size() <= 0;
        if (!textFieldContents.equals(truncContents)) {
            if (this.isPossibleEdit && !this.list.contains(textFieldContents) && !textFieldContents.equals("")) {
                this.editAdding = true;
                this.addItem(textFieldContents);
                this.updateInternalMax();
                this.updateButtonStatus();
                truncContents = this.truncateContents(this.getCurrentText());
                isListEmpty = false;
            } else {
                this.editAdding = false;
            }
            if (!isListEmpty) {
                ((TextComponent)this.textFld).setText(truncContents);
            }
        }
        if (isListEmpty) {
            ((TextComponent)this.textFld).setText("");
        }
    }

    protected boolean isValidCurrentValue(int i) {
        return i >= this.min && i <= this.internalMax;
    }

    protected boolean isValidMaxValue(int i) {
        return i >= this.min && i >= 0;
    }

    protected boolean isValidMinValue(int i) {
        return i <= this.internalMax && i >= 0;
    }

    protected void updateInternalMax() {
        this.internalMax = 0;
        int listSize = this.list.size();
        if (this.max >= listSize) {
            if (listSize > 0) {
                this.internalMax = listSize - 1;
            }
        } else {
            this.internalMax = this.max;
        }
    }

    protected void updateButtonStatus() {
        if (this.buttons != null) {
            if (this.isWrappable()) {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(true);
            } else if (this.current == this.internalMax && this.current == this.min) {
                this.buttons.setUpButtonEnabled(false);
                this.buttons.setDownButtonEnabled(false);
            } else if (this.current == this.internalMax) {
                this.buttons.setUpButtonEnabled(false);
                this.buttons.setDownButtonEnabled(true);
            } else if (this.current == this.min) {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(false);
            } else {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(true);
            }
        }
    }

    class Focus
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            if (ListSpinner.this.textFld.isEditable()) {
                ListSpinner.this.isPossibleEdit = true;
                ListSpinner.this.oldText = ListSpinner.this.textFld.getText();
                ((TextComponent)ListSpinner.this.textFld).setText(ListSpinner.this.getCurrentText());
            }
        }

        public void focusLost(FocusEvent e) {
            ListSpinner.this.updateText(false);
            ListSpinner.this.isPossibleEdit = false;
        }

        Focus() {
            ListSpinner.this = ListSpinner.this;
        }
    }
}

