/*
 * Decompiled with CFR 0.152.
 */
package plugins.test;

import com.pkc.ann.ANN;
import com.pkc.ann.Neuron;
import com.pkc.ann.Perceptron;
import com.pkc.ann.SigmoidNeuron;
import com.pkc.data.PackingDataSource;
import com.pkc.ec.Individual;
import com.pkc.ec.Population;
import com.pkc.geom.RectObject;
import com.pkc.packing.PackingAlgorithm;
import com.pkc.settings.Settings;
import com.pkc.util.Tools;
import com.plugin.Plugin;
import com.plugin.PluginManager;
import com.plugin.SimpleBooleanParam;
import com.plugin.SimpleIntParam;
import java.util.List;
import java.util.Locale;

public class Test
implements Plugin {
    public boolean trainEC;
    public boolean trainANN;
    public boolean searchForBest;
    public boolean repeat;
    public boolean ratio;
    public static int iterationsForLayer = 1000;
    public static int retryCount = 5;
    public int maxProblems = Integer.MAX_VALUE;
    final int POPULATION_SIZE = 20;
    final int CHROMOSOME_SIZE = 5;
    final int GENERATION_COUNT = 100;
    final int MAX_GENE_VALUE = 100;
    final int MUTANTS_PER_GENERATION = 2;
    int[][] population = new int[20][5];
    double[] fitness = new double[20];

    public Test() {
        PluginManager.registerParam(new SimpleBooleanParam(this, "trainEC", "Search for best mixture using genetic algorithm."));
        PluginManager.registerParam(new SimpleBooleanParam(this, "trainANN", "Search for ANN providing best mixture according to problem parameters."));
        PluginManager.registerParam(new SimpleBooleanParam(this, "searchForBest", "Try to find best possible packing."));
        PluginManager.registerParam(new SimpleBooleanParam(this, "repeat", "Repeat packing several times."));
        PluginManager.registerParam(new SimpleBooleanParam(this, "ratio", "Perform experiment on interation/repeat ratio."));
        PluginManager.registerParam(new SimpleIntParam(this, "iterationsForLayer", "iterations", "Perform packing given number of {0} for each layer. Default is " + iterationsForLayer + "."));
        PluginManager.registerParam(new SimpleIntParam(this, "retryCount", "count", "Retry packing given number of times. Default is " + retryCount + "."));
        PluginManager.registerParam(new SimpleIntParam(this, "maxProblems", "count", "Perform packing only for given {0} of problems. Default is " + this.maxProblems + "."));
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public void run() {
        if (this.maxProblems > Settings.problems.size()) {
            this.maxProblems = Settings.problems.size();
        }
        Settings.problems = Settings.problems.subList(0, this.maxProblems);
        int[] criterionProbabilities = new int[]{10, 44, 8, 82, 14};
        if (this.trainEC) {
            int i = 0;
            while (i < 20) {
                int j = 0;
                while (j < 5) {
                    this.population[i][j] = Tools.random.nextInt(100);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < 100) {
                System.out.println();
                System.out.println("Iteration " + (i + 1) + " of " + 100);
                System.out.println();
                int bestIndividual = 0;
                double bestFitness = 0.0;
                double avgFitness = 0.0;
                int j = 0;
                while (j < 20) {
                    System.out.println("+----------------------------------------------------------------------+");
                    System.out.println("| Individual " + (j + 1) + " of " + 20);
                    this.fitness[j] = Test.pack(Settings.problems, this.population[j], 0, this.maxProblems);
                    if (this.fitness[j] > bestFitness) {
                        bestFitness = this.fitness[j];
                        bestIndividual = j;
                    }
                    avgFitness += this.fitness[j];
                    ++j;
                }
                this.generateNextGeneration(avgFitness /= 20.0);
                System.out.println("######################################################################");
                System.out.println("# Best individual fitness: " + bestFitness);
                System.out.print("# Best individual:");
                j = 0;
                while (j < 5) {
                    System.out.print(String.valueOf(this.population[bestIndividual][j]) + " ");
                    ++j;
                }
                System.out.println();
                System.out.println("######################################################################");
                ++i;
            }
        } else if (this.trainANN) {
            Population population = new Population(10, MixtureChooser.class);
            population.evolve(100, 2, 2, 4, 3);
        } else if (this.searchForBest) {
            int i = 0;
            while (i < 20) {
                Test.pack(Settings.problems, criterionProbabilities, 0, this.maxProblems);
                iterationsForLayer *= 2;
                ++i;
            }
        } else if (this.repeat) {
            int i = 0;
            while (i < 50) {
                Test.pack(Settings.problems, criterionProbabilities, 0, this.maxProblems);
                ++i;
            }
        } else if (this.ratio) {
            int i = 1;
            while (i < 11) {
                retryCount = i;
                iterationsForLayer = 5000 / i;
                List problems = Settings.problems;
                Test.pack(problems, criterionProbabilities, 0, this.maxProblems);
                ++i;
            }
        } else if (Settings.problems != null && Settings.problems.size() > 0) {
            Test.pack(Settings.problems, criterionProbabilities, 0, this.maxProblems);
        }
    }

    private void copyChomosomes(int sourceInduvidual, int destIndividual, int start, int end) {
        int i = start;
        while (i <= end) {
            this.population[destIndividual][i] = this.population[sourceInduvidual][i];
            ++i;
        }
    }

    private void generateNextGeneration(double avgFitness) {
        int i = 0;
        int size = 20;
        while (i < size) {
            if (this.fitness[i] < avgFitness) {
                if (i < --size) {
                    this.fitness[i] = this.fitness[size];
                    this.copyChomosomes(size, i, 0, 4);
                }
                if (size != 1) continue;
                break;
            }
            ++i;
        }
        System.out.println("Survivor count: " + size);
        i = 0;
        while (i < 2) {
            if (size == 20) break;
            this.copyChomosomes(Tools.random.nextInt(size), size, 0, 4);
            this.population[size][Tools.random.nextInt((int)5)] = Tools.random.nextInt(100);
            ++size;
            ++i;
        }
        while (size < 20) {
            int mother = Tools.random.nextInt(size);
            int father = Tools.random.nextInt(size);
            int crossPoint = Tools.random.nextInt(3) + 1;
            this.copyChomosomes(mother, size, 0, crossPoint);
            this.copyChomosomes(father, size, crossPoint + 1, 4);
            ++size;
        }
    }

    private static String formatFixnum(long num, int symbols) {
        String temp = String.valueOf(num);
        while (temp.length() < symbols) {
            temp = " " + temp;
        }
        return temp;
    }

    private static String formatFlonum(double num, int symbols) {
        String temp = Tools.flonumFormat.format(num);
        while (temp.length() < symbols) {
            temp = " " + temp;
        }
        return temp;
    }

    private static String formatPercent(double num) {
        String temp = Tools.percentFormat.format(num);
        while (temp.length() < 7) {
            temp = " " + temp;
        }
        return temp;
    }

    private static void formatCell(String content, int length) {
        while (content.length() < length) {
            content = String.valueOf(content) + " ";
        }
        System.out.print("|" + content + "|");
    }

    private static double pack(List problems, int[] criterionProbabilities, int from, int to) {
        Tools.random.setSeed(0L);
        int count = to - from;
        int minObjectCount = Integer.MAX_VALUE;
        int maxObjectCount = Integer.MIN_VALUE;
        long avgObjectCount = 0L;
        double minFill = Double.MAX_VALUE;
        double maxFill = Double.MIN_VALUE;
        double avgFill = 0.0;
        double minGreedy1 = Double.MAX_VALUE;
        double maxGreedy1 = Double.MIN_VALUE;
        double avgGreedy1 = 0.0;
        double minGreedy2 = Double.MAX_VALUE;
        double maxGreedy2 = Double.MIN_VALUE;
        double avgGreedy2 = 0.0;
        double minGreedy3 = Double.MAX_VALUE;
        double maxGreedy3 = Double.MIN_VALUE;
        double avgGreedy3 = 0.0;
        double minBest = Double.MAX_VALUE;
        double maxBest = Double.MIN_VALUE;
        double avgBest = 0.0;
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        long avgTime = 0L;
        PackingAlgorithm packingAlgorithm = null;
        System.out.println("+----------------------------------------------------------------------+");
        Test.formatCell(" Retry count: " + retryCount, 70);
        System.out.println();
        Test.formatCell(" Iterations for layer: " + iterationsForLayer, 70);
        System.out.println();
        String probabilities = " Criterion probabilities: ";
        int i = 0;
        while (i < criterionProbabilities.length) {
            probabilities = String.valueOf(probabilities) + criterionProbabilities[i] + (i != criterionProbabilities.length - 1 ? ", " : "");
            ++i;
        }
        Test.formatCell(probabilities, 70);
        System.out.println();
        System.out.println("+-----+-------+--------+--------------------------+--------+-----------+");
        System.out.println("|     |       |        |          Greedy          |        |           |");
        System.out.println("| No  |  Box  | Fill   +--------+--------+--------+ Best   | Time (s)  |");
        System.out.println("|     | Count |        | Volume | Ratio  | MinMax |        |           |");
        System.out.println("+-----+-------+--------+--------+--------+--------+--------+-----------+");
        i = from;
        while (i < to) {
            PackingDataSource.PackingProblem problem = (PackingDataSource.PackingProblem)problems.get(i);
            int j = 0;
            while (j < problem.getObjects().size()) {
                ((RectObject)problem.getObjects().get(j)).restoreOrigRotation();
                ++j;
            }
            packingAlgorithm = new PackingAlgorithm(problem, criterionProbabilities);
            long containerVolume = ((RectObject)problem.getContainers().get(0)).getVolume();
            Test.formatCell(Test.formatFixnum(i + 1, 4), 5);
            int objectCount = problem.getObjects().size();
            if (objectCount < minObjectCount) {
                minObjectCount = objectCount;
            }
            if (objectCount > maxObjectCount) {
                maxObjectCount = objectCount;
            }
            avgObjectCount += (long)problem.getObjects().size();
            System.out.print(String.valueOf(Test.formatFixnum(objectCount, 6)) + " |");
            double fill = (double)packingAlgorithm.getObjectsVolume() / (double)containerVolume;
            if (fill < minFill) {
                minFill = fill;
            }
            if (fill > maxFill) {
                maxFill = fill;
            }
            avgFill += fill;
            System.out.print(String.valueOf(Test.formatPercent(fill)) + " |");
            long t1 = System.currentTimeMillis();
            double value = (double)packingAlgorithm.packGreedy(packingAlgorithm.chooseLargestVolumeObjectCriterion) / (double)containerVolume;
            if (value < minGreedy1) {
                minGreedy1 = value;
            }
            if (value > maxGreedy1) {
                maxGreedy1 = value;
            }
            avgGreedy1 += value;
            System.out.print(String.valueOf(Test.formatPercent(value)) + " |");
            value = (double)packingAlgorithm.packGreedy(packingAlgorithm.chooseMaxRatioObjectCriterion) / (double)containerVolume;
            if (value < minGreedy2) {
                minGreedy2 = value;
            }
            if (value > maxGreedy2) {
                maxGreedy2 = value;
            }
            avgGreedy2 += value;
            System.out.print(String.valueOf(Test.formatPercent(value)) + " |");
            value = (double)packingAlgorithm.packGreedy(packingAlgorithm.chooseMaxMinObjectCriterion) / (double)containerVolume;
            if (value < minGreedy3) {
                minGreedy3 = value;
            }
            if (value > maxGreedy3) {
                maxGreedy3 = value;
            }
            avgGreedy3 += value;
            System.out.print(String.valueOf(Test.formatPercent(value)) + " |");
            int retries = 0;
            while (retries < retryCount) {
                packingAlgorithm.layerChooserByObjDims.reset();
                packingAlgorithm.packUsingLayers(packingAlgorithm.layerChooserByObjDims, iterationsForLayer);
                ++retries;
            }
            value = (double)packingAlgorithm.getBestValue() / (double)containerVolume;
            if (value < minBest) {
                minBest = value;
            }
            if (value > maxBest) {
                maxBest = value;
            }
            avgBest += value;
            System.out.print(String.valueOf(Test.formatPercent(value)) + " |");
            long t2 = System.currentTimeMillis();
            long time = t2 - t1;
            if (time < minTime) {
                minTime = time;
            }
            if (time > maxTime) {
                maxTime = time;
            }
            avgTime += time;
            System.out.println(String.valueOf(Test.formatFlonum((double)time / 1000.0, 10)) + " |");
            ++i;
        }
        System.out.println("+-----+-------+--------+--------+--------+--------+--------+-----------+");
        System.out.println("| Min |" + Test.formatFixnum(minObjectCount, 6) + " |" + Test.formatPercent(minFill) + " |" + Test.formatPercent(minGreedy1) + " |" + Test.formatPercent(minGreedy2) + " |" + Test.formatPercent(minGreedy3) + " |" + Test.formatPercent(minBest) + " |" + Test.formatFlonum((double)minTime / 1000.0, 10) + " |");
        System.out.println("+-----+-------+--------+--------+--------+--------+--------+-----------+");
        System.out.println("| Avg |" + Test.formatFixnum(avgObjectCount / (long)count, 6) + " |" + Test.formatPercent(avgFill / (double)count) + " |" + Test.formatPercent(avgGreedy1 / (double)count) + " |" + Test.formatPercent(avgGreedy2 / (double)count) + " |" + Test.formatPercent(avgGreedy3 / (double)count) + " |" + Test.formatPercent(avgBest / (double)count) + " |" + Test.formatFlonum((double)avgTime / (double)(1000 * count), 10) + " |");
        System.out.println("+-----+-------+--------+--------+--------+--------+--------+-----------+");
        System.out.println("| Max |" + Test.formatFixnum(maxObjectCount, 6) + " |" + Test.formatPercent(maxFill) + " |" + Test.formatPercent(maxGreedy1) + " |" + Test.formatPercent(maxGreedy2) + " |" + Test.formatPercent(maxGreedy3) + " |" + Test.formatPercent(maxBest) + " |" + Test.formatFlonum((double)maxTime / 1000.0, 10) + " |");
        System.out.println("+-----+-------+--------+--------+--------+--------+--------+-----------+");
        return avgBest / (double)count;
    }

    public static class MixtureChooser
    extends Individual {
        private static final double MUTATION_PROBABILITY = 0.1;
        int[] criterionProbabilities = new int[5];
        private ANN ann = new Perceptron(3, new int[]{3, 5}, new Class[]{SigmoidNeuron.class, SigmoidNeuron.class, SigmoidNeuron.class});
        private float testValue;

        private void mutateNeuron(Neuron neuron, Neuron original) {
            int i = 0;
            while (i < neuron.getConnections().size()) {
                float weight = ((Neuron.Connection)original.getConnections().get(i)).getWeight();
                if (Tools.random.nextDouble() < 0.1) {
                    weight = (float)((double)weight + Tools.random.nextGaussian());
                }
                ((Neuron.Connection)neuron.getConnections().get(i)).setWeight(weight);
                this.mutateNeuron(((Neuron.Connection)neuron.getConnections().get(i)).getNeuron(), ((Neuron.Connection)original.getConnections().get(i)).getNeuron());
                ++i;
            }
        }

        private void crossNeurons(Neuron neuron, Neuron parent1, Neuron parent2) {
            int i = 0;
            while (i < neuron.getConnections().size()) {
                float weight = Tools.random.nextDouble() < 0.5 ? ((Neuron.Connection)parent1.getConnections().get(i)).getWeight() : ((Neuron.Connection)parent2.getConnections().get(i)).getWeight();
                ((Neuron.Connection)neuron.getConnections().get(i)).setWeight(weight);
                this.crossNeurons(((Neuron.Connection)neuron.getConnections().get(i)).getNeuron(), ((Neuron.Connection)parent1.getConnections().get(i)).getNeuron(), ((Neuron.Connection)parent2.getConnections().get(i)).getNeuron());
                ++i;
            }
        }

        public ANN getANN() {
            return this.ann;
        }

        @Override
        public Individual mutate(Individual child) {
            int i = 0;
            while (i < this.ann.getInputNeurons().size()) {
                this.mutateNeuron((Neuron)((MixtureChooser)child).getANN().getInputNeurons().get(i), (Neuron)this.ann.getInputNeurons().get(i));
                ++i;
            }
            child.markAsUnevaluated();
            return child;
        }

        @Override
        public Individual cross(Individual child, Individual[] parents) {
            int i = 0;
            while (i < this.ann.getInputNeurons().size()) {
                this.crossNeurons((Neuron)((MixtureChooser)child).getANN().getInputNeurons().get(i), (Neuron)((MixtureChooser)parents[0]).getANN().getInputNeurons().get(i), (Neuron)((MixtureChooser)parents[1]).getANN().getInputNeurons().get(i));
                ++i;
            }
            child.markAsUnevaluated();
            return child;
        }

        @Override
        public float evaluate() {
            float trainValue = 0.0f;
            int j = 0;
            while (j < Settings.problems.size() / 2) {
                PackingDataSource.PackingProblem problem = (PackingDataSource.PackingProblem)Settings.problems.get(j);
                long volumeSum = 0L;
                int i = 0;
                while (i < problem.getObjects().size()) {
                    volumeSum += ((RectObject)problem.getObjects().get(i)).getVolume();
                    ++i;
                }
                float diversity = problem.getClassCount() / problem.getObjects().size();
                float[] output = this.getANN().evaluate(new float[]{1.0f, diversity, (float)volumeSum / (float)problem.getObjects().size() / (float)((RectObject)problem.getContainers().get(0)).getVolume()});
                float sum = 0.0f;
                int i2 = 0;
                while (i2 < output.length) {
                    sum += output[i2];
                    ++i2;
                }
                i2 = 0;
                while (i2 < output.length) {
                    this.criterionProbabilities[i2] = Math.round(100.0f * output[i2] / sum);
                    ++i2;
                }
                trainValue += (float)Test.pack(Settings.problems, this.criterionProbabilities, j, j + 1);
                ++j;
            }
            this.testValue = (float)Test.pack(Settings.problems, this.criterionProbabilities, Settings.problems.size() / 2, Settings.problems.size());
            System.out.println("~~~ Tain value: " + (trainValue /= (float)(Settings.problems.size() / 2)) + ", test value: " + this.testValue);
            return trainValue;
        }

        public String toString() {
            return "testValue=" + this.testValue;
        }
    }
}

