/*
 * Decompiled with CFR 0.152.
 */
package plugins.ManualDataEntry;

import com.pkc.data.PackingDataSource;
import com.pkc.data.PackingObject;
import com.pkc.geom.NDPoint;
import com.pkc.geom.RectObject;
import com.pkc.settings.Settings;
import com.pkc.util.Tools;
import com.plugin.Parameter;
import com.plugin.Plugin;
import com.plugin.PluginManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;

public class ManualDataEntry
extends PackingDataSource
implements Plugin {
    public static final int CONSTRAINTS_LOAD = 0;
    public static final int CONSTRAINTS_NONE = 1;
    public static final int CONSTRAINTS_ALL = 2;
    int constaints;
    JFileChooser fileChooser;
    JRadioButton loadRotationConstraints;
    JRadioButton notAllowRotation;
    JRadioButton allowAllRotations;
    private JPanel dataPanel = null;
    private JTextPane txtPane = null;

    public ManualDataEntry() {
        JPanel fileChooserPanel = new JPanel(new BorderLayout());
        fileChooserPanel.add(this.getDataPanel());
        this.configPages.add(fileChooserPanel);
        this.constaints = 0;
        PluginManager.registerParam(new Parameter("allowRotations", 1, new String[]{"rotations"}, "Allow only certain {0}. Possible values load, all, none.\n\t\tDefault is load which means that rotation constraints will be loaded from file."){

            @Override
            public void process() throws Exception {
                if (this.getArg(0).equals("load")) {
                    ManualDataEntry.this.constaints = 0;
                } else if (this.getArg(0).equals("none")) {
                    ManualDataEntry.this.constaints = 1;
                } else if (this.getArg(0).equals("all")) {
                    ManualDataEntry.this.constaints = 2;
                }
            }
        });
        PluginManager.registerParam(new Parameter("loadFromThpackFile", 1, new String[]{"fileName"}, "Load data to pack from given file."){

            @Override
            public void process() throws Exception {
                ManualDataEntry.this.loadFile(new File(this.getArg(0)));
            }
        });
    }

    protected int getInt(StringTokenizer tokens) {
        try {
            return Integer.parseInt(tokens.nextToken());
        }
        catch (Exception e) {
            return Integer.MIN_VALUE;
        }
    }

    protected void loadFile(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        int problemCount = Integer.parseInt(raf.readLine().trim());
        int problemIndex = 0;
        while (problemIndex < problemCount) {
            PackingDataSource.PackingProblem problem = new PackingDataSource.PackingProblem(3);
            problem.setGravity(2);
            raf.readLine();
            StringTokenizer tokens = new StringTokenizer(raf.readLine());
            int length = this.getInt(tokens);
            int width = this.getInt(tokens);
            int height = this.getInt(tokens);
            RectObject container = new RectObject(3);
            container.setStart(0, -length / 2);
            container.setStart(1, -width / 2);
            container.setStart(2, -height / 2);
            container.setDim(0, length);
            container.setDim(1, width);
            container.setDim(2, height);
            container.setProperty("Width", new Integer(container.getDim(0)));
            container.setProperty("Height", new Integer(container.getDim(1)));
            container.setProperty("Depth", new Integer(container.getDim(2)));
            problem.addContainer(container);
            tokens = new StringTokenizer(raf.readLine());
            int n = this.getInt(tokens);
            int i = 0;
            while (i < n) {
                tokens = new StringTokenizer(raf.readLine());
                this.getInt(tokens);
                ArrayList<NDPoint> rotations = new ArrayList<NDPoint>(6);
                length = this.getInt(tokens);
                boolean rot1 = (this.getInt(tokens) == 1 && this.constaints == 0 || this.constaints == 2) && this.constaints != 1;
                width = this.getInt(tokens);
                boolean rot2 = (this.getInt(tokens) == 1 && this.constaints == 0 || this.constaints == 2) && this.constaints != 1;
                height = this.getInt(tokens);
                boolean rot3 = (this.getInt(tokens) == 1 && this.constaints == 0 || this.constaints == 2) && this.constaints != 1;
                int count = this.getInt(tokens);
                int currRotationIndex = 0;
                if (rot1) {
                    NDPoint rotation1 = new NDPoint(new int[]{width, height, length});
                    NDPoint rotation2 = new NDPoint(new int[]{height, width, length});
                    rotations.add(rotation1);
                    rotations.add(rotation2);
                }
                if (rot2) {
                    NDPoint rotation3 = new NDPoint(new int[]{length, height, width});
                    NDPoint rotation4 = new NDPoint(new int[]{height, length, width});
                    rotations.add(rotation3);
                    rotations.add(rotation4);
                }
                if (rot3) {
                    currRotationIndex = rotations.size();
                    NDPoint rotation5 = new NDPoint(new int[]{length, width, height});
                    NDPoint rotation6 = new NDPoint(new int[]{width, length, height});
                    rotations.add(rotation5);
                    rotations.add(rotation6);
                }
                int x = this.getInt(tokens);
                int y = this.getInt(tokens);
                int z = this.getInt(tokens);
                Color color = new Color(Tools.random.nextFloat(), Tools.random.nextFloat(), Tools.random.nextFloat());
                int j = 0;
                while (j < count) {
                    RectObject object = new RectObject(3);
                    object.setObjectClass(i);
                    object.setDim(0, length);
                    object.setDim(1, width);
                    object.setDim(2, height);
                    object.setStart(0, x == Integer.MIN_VALUE ? x : x + container.getStart(0));
                    object.setStart(1, y == Integer.MIN_VALUE ? y : y + container.getStart(1));
                    object.setStart(2, z == Integer.MIN_VALUE ? z : z + container.getStart(2));
                    object.setPossibleRotations(rotations, currRotationIndex);
                    object.setProperty("Width", new Integer(object.getDim(0)));
                    object.setProperty("Height", new Integer(object.getDim(1)));
                    object.setProperty("Depth", new Integer(object.getDim(2)));
                    object.setProperty(PackingObject.OBJECT_COLOR, color);
                    problem.addObject(object);
                    ++j;
                }
                ++i;
            }
            problem.setClassCount(n);
            Settings.problems.add(problem);
            ++problemIndex;
        }
        raf.close();
    }

    @Override
    public void validateConfig() throws Exception {
        Settings.problems.clear();
        File file = this.fileChooser.getSelectedFile();
        if (file == null) {
            throw new Exception("Please choose file");
        }
        this.constaints = this.loadRotationConstraints.isSelected() ? 0 : (this.notAllowRotation.isSelected() ? 1 : 2);
        this.loadFile(file);
        this.title = file.getName();
    }

    public String toString() {
        return "Load data manualy";
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public void run() {
    }

    private JPanel getDataPanel() {
        if (this.dataPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.dataPanel = new JPanel();
            this.dataPanel.setLayout(new GridBagLayout());
            this.dataPanel.setSize(new Dimension(469, 262));
            this.dataPanel.add((Component)this.getTxtPane(), gridBagConstraints);
        }
        return this.dataPanel;
    }

    private JTextPane getTxtPane() {
        if (this.txtPane == null) {
            this.txtPane = new JTextPane();
        }
        return this.txtPane;
    }
}

