/*
 * Decompiled with CFR 0.152.
 */
package plugins.GenByCutting;

import com.pkc.data.PackingDataSource;
import com.pkc.data.PackingObject;
import com.pkc.geom.RectObject;
import com.pkc.settings.Settings;
import com.pkc.util.Tools;
import com.plugin.Plugin;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class GenByCutting
extends PackingDataSource
implements Plugin {
    public static final int CUT_TO_EQUAL_PARTS = 0;
    public static final int CUT_TO_RANDOM_PARTS = 1;
    public static final int NON_GUILLOTINE_CUT = 2;
    JSpinner containerCount = new JSpinner(new SpinnerNumberModel(1, 1, 1000, 1));
    JSpinner containerLength = new JSpinner(new SpinnerNumberModel(1024, 1, 1024, 1));
    JSpinner containerWidth = new JSpinner(new SpinnerNumberModel(512, 1, 1024, 1));
    JSpinner containerHeight = new JSpinner(new SpinnerNumberModel(512, 1, 1024, 1));
    JComboBox dataGenMethodComboBox = new JComboBox<Object>(new Object[]{"equal parts", "random size parts", "non guillotine cut"});
    JSpinner timesToCut = new JSpinner(new SpinnerNumberModel(3, 1, 10, 1));
    static String[] containerNames = new String[]{"Volvo", "Mercedes", "Kamaz"};
    static String[] objectNames = new String[]{"Fridge", "Table", "Chair", "Bed", "Computer", "Mouse", "Mousepad", "Keyboard", "Printer", "Hard disk", "CRT Monitor 15\"", "CRT Monitor 17\"", "CRT Monitor 19\"", "CRT Monitor 21\"", "LCD Monitor 15\"", "LCD Monitor 17\"", "LCD Monitor 19\"", "LCD Monitor 21\"", "Cigarettes L&M", "Cigarettes West", "Cigarettes Bond", "Milk", "Tabaco", "Bread", "Meat", "Spagetti", "Water", "Salt", "Cugar", "Apples", "Candle", "Glasses", "Video cassette", "Book", "Pen", "Bottle", "Eraser"};

    public GenByCutting() {
        System.out.println("GenByCutting");
        JPanel innerPanel = new JPanel(new GridLayout(6, 2));
        JPanel configPanel = new JPanel();
        configPanel.setBorder(new TitledBorder("Data generation configuration"));
        configPanel.add(innerPanel);
        innerPanel.add(new JLabel("Containers: "));
        innerPanel.add(this.containerCount);
        innerPanel.add(new JLabel("Container length: "));
        innerPanel.add(this.containerLength);
        innerPanel.add(new JLabel("Container width: "));
        innerPanel.add(this.containerWidth);
        innerPanel.add(new JLabel("Container height: "));
        innerPanel.add(this.containerHeight);
        innerPanel.add(new JLabel("Cut method: "));
        innerPanel.add(this.dataGenMethodComboBox);
        innerPanel.add(new JLabel("Times to cut: "));
        innerPanel.add(this.timesToCut);
        this.configPages.add(configPanel);
    }

    public GenByCutting(PackingDataSource.PackingProblem problem, int containerCount, int containerLength, int containerWidth, int containerHeight, int times, int dataGenMethodComboBox) {
        int j = 0;
        while (j < containerCount) {
            RectObject container = new RectObject(3);
            int[] containerDims = new int[]{containerLength, containerWidth, containerHeight};
            int i = 0;
            while (i < container.getDimension()) {
                container.setStart(i, -containerDims[i] / 2);
                container.setDim(i, containerDims[i]);
                ++i;
            }
            container.setProperty(PackingObject.OBJECT_NAME, "test container");
            container.setProperty("Width", new Integer(container.getDim(0)));
            container.setProperty("Height", new Integer(container.getDim(1)));
            container.setProperty("Depth", new Integer(container.getDim(2)));
            problem.addContainer(container);
            GenByCutting c = new GenByCutting();
            c.cut(container.getDimension(), problem.getObjects(), times - 1, container, dataGenMethodComboBox);
            ++j;
        }
        int i = 0;
        while (i < problem.getObjects().size()) {
            RectObject object = (RectObject)problem.getObjects().get(i);
            object.setObjectClass(i);
            object.setProperty(PackingObject.OBJECT_NAME, "object");
            object.setProperty("Width", new Integer(object.getDim(0)));
            object.setProperty("Height", new Integer(object.getDim(1)));
            object.setProperty("Depth", new Integer(object.getDim(2)));
            object.setProperty(PackingObject.OBJECT_COLOR, new Color(8, 8, 8));
            ++i;
        }
        problem.setClassCount(problem.getObjects().size());
    }

    public String toString() {
        return "Generate by cuting container";
    }

    @Override
    public void validateConfig() throws Exception {
        Settings.problems.clear();
        PackingDataSource.PackingProblem problem = new PackingDataSource.PackingProblem(3);
        int times = ((Number)this.timesToCut.getValue()).intValue();
        int j = 0;
        while (j < ((Number)this.containerCount.getValue()).intValue()) {
            RectObject container = new RectObject(3);
            int[] containerDims = new int[]{((Number)this.containerLength.getValue()).intValue(), ((Number)this.containerWidth.getValue()).intValue(), ((Number)this.containerHeight.getValue()).intValue()};
            int i = 0;
            while (i < container.getDimension()) {
                container.setStart(i, -containerDims[i] / 2);
                container.setDim(i, containerDims[i]);
                ++i;
            }
            container.setProperty(PackingObject.OBJECT_NAME, containerNames[Tools.random.nextInt(containerNames.length)]);
            container.setProperty("Width", new Integer(container.getDim(0)));
            container.setProperty("Height", new Integer(container.getDim(1)));
            container.setProperty("Depth", new Integer(container.getDim(2)));
            problem.addContainer(container);
            this.cut(container.getDimension(), problem.getObjects(), times - 1, container, this.dataGenMethodComboBox.getSelectedIndex());
            ++j;
        }
        int i = 0;
        while (i < problem.getObjects().size()) {
            RectObject object = (RectObject)problem.getObjects().get(i);
            object.setObjectClass(i);
            object.setProperty(PackingObject.OBJECT_NAME, objectNames[Tools.random.nextInt(objectNames.length)]);
            object.setProperty("Width", new Integer(object.getDim(0)));
            object.setProperty("Height", new Integer(object.getDim(1)));
            object.setProperty("Depth", new Integer(object.getDim(2)));
            object.setProperty(PackingObject.OBJECT_COLOR, new Color(Tools.random.nextFloat(), Tools.random.nextFloat(), Tools.random.nextFloat()));
            ++i;
        }
        problem.setClassCount(problem.getObjects().size());
        this.title = "Generated by ";
        this.title = this.dataGenMethodComboBox.getSelectedIndex() == 0 ? String.valueOf(this.title) + "cutting container " + times + " times into equal parts" : (this.dataGenMethodComboBox.getSelectedIndex() == 1 ? String.valueOf(this.title) + "cutting container " + times + " times into random sized parts" : String.valueOf(this.title) + "non guillotine cutting container " + times + " times");
        Settings.problems.add(problem);
    }

    public void cut(int dimensions, List result, int times, RectObject object, int cutMethod) {
        ArrayList<RectObject> temp = new ArrayList<RectObject>(5);
        int newObjectCount = cutMethod == 2 ? 5 : 2;
        int i = 0;
        while (i < newObjectCount) {
            RectObject ro = new RectObject(dimensions);
            int j = 0;
            while (j < dimensions) {
                ro.setDim(j, object.getDim(j));
                ++j;
            }
            temp.add(ro);
            ++i;
        }
        int index = Tools.random.nextInt(dimensions);
        if (cutMethod != 2) {
            int value = cutMethod == 0 ? object.getDim(index) / 2 : Tools.random.nextInt(object.getDim(index) - times) + times * 2;
            ((RectObject)temp.get(0)).setDim(index, value);
            ((RectObject)temp.get(1)).setDim(index, object.getDim(index) - value);
        } else {
            int index2;
            while ((index2 = Tools.random.nextInt(dimensions)) == index) {
            }
            ((RectObject)temp.get(0)).setDim(index, object.getDim(index) / 3);
            ((RectObject)temp.get(0)).setDim(index2, object.getDim(index2) * 2 / 3);
            ((RectObject)temp.get(1)).setDim(index, object.getDim(index) / 3);
            ((RectObject)temp.get(1)).setDim(index2, object.getDim(index2) * 2 / 3);
            ((RectObject)temp.get(2)).setDim(index, object.getDim(index) - ((RectObject)temp.get(0)).getDim(index));
            ((RectObject)temp.get(2)).setDim(index2, object.getDim(index2) - ((RectObject)temp.get(0)).getDim(index2));
            ((RectObject)temp.get(3)).setDim(index, object.getDim(index) - ((RectObject)temp.get(0)).getDim(index));
            ((RectObject)temp.get(3)).setDim(index2, object.getDim(index2) - ((RectObject)temp.get(0)).getDim(index2));
            ((RectObject)temp.get(4)).setDim(index, ((RectObject)temp.get(2)).getDim(index) - ((RectObject)temp.get(0)).getDim(index));
            ((RectObject)temp.get(4)).setDim(index2, ((RectObject)temp.get(0)).getDim(index2) - ((RectObject)temp.get(2)).getDim(index2));
        }
        if (times > 0) {
            int i2 = 0;
            while (i2 < newObjectCount) {
                this.cut(dimensions, result, times - 1, (RectObject)temp.get(i2), cutMethod);
                ++i2;
            }
        } else {
            result.addAll(temp);
        }
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public void run() {
    }
}

