/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.jasm;

import java.io.DataOutputStream;
import java.io.IOException;

public class CodeArray {
    final int growth = 20;
    byte[] code = new byte[20];
    int size = 0;
    int maxStack = 0;
    int maxLocals = 0;
    int currentStackLoad = 0;
    int currentLocalLoad = 0;
    int currentArguments = 0;

    public void append(int n) {
        if (this.size >= this.code.length) {
            byte[] byArray = new byte[this.size + 20];
            System.arraycopy(this.code, 0, byArray, 0, this.size);
            this.code = byArray;
        }
        this.code[this.size++] = (byte)(n & 0xFF);
    }

    public void appendInt(int n) {
        this.append(n >> 8);
        this.append(n & 0xFF);
    }

    public void reserveStack(int n) {
        this.currentStackLoad += n;
        if (this.currentStackLoad > this.maxStack) {
            this.maxStack = this.currentStackLoad;
        }
    }

    public void reserveLocal(int n) {
        this.currentLocalLoad += n;
        if (this.currentLocalLoad > this.maxLocals) {
            this.maxLocals = this.currentLocalLoad;
        }
    }

    public void reserveArguments(int n) {
        this.currentArguments += n;
    }

    public void freeStack(int n) {
        this.currentStackLoad -= n;
    }

    public void freeLocal(int n) {
        this.currentLocalLoad -= n;
    }

    public void removeArguments(int n) {
        this.currentArguments -= n;
    }

    public void resetArguments() {
        this.currentArguments = 0;
    }

    void writeTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.size + 12);
        dataOutputStream.writeShort(this.maxStack);
        dataOutputStream.writeShort(this.maxLocals + this.currentArguments);
        dataOutputStream.writeInt(this.size);
        dataOutputStream.write(this.code, 0, this.size);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(0);
    }
}

