/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.jasm;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import lt.monarch.jasm.ConstantPool;
import lt.monarch.jasm.FieldBuilder;
import lt.monarch.jasm.MethodBuilder;

public class ClassBuilder
extends ClassLoader {
    public ConstantPool constantPool = new ConstantPool();
    int flags;
    String className;
    String superName;
    Vector interfaces;
    Vector methods;
    Vector fields;

    @Override
    public String getName() {
        return this.className;
    }

    public void setSuperclassName(String string) {
        this.superName = string;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    public void addInterface(String string) {
        this.interfaces.addElement(string);
    }

    public void addMethod(MethodBuilder methodBuilder) {
        this.methods.addElement(methodBuilder);
    }

    public boolean hasMethod(String string, String string2) {
        for (int i = 0; i < this.methods.size(); ++i) {
            MethodBuilder methodBuilder = (MethodBuilder)this.methods.elementAt(i);
            if (!methodBuilder.name.equals(string) || !methodBuilder.descriptor.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public void addField(FieldBuilder fieldBuilder) {
        this.fields.addElement(fieldBuilder);
    }

    public void addDefaultConstructor() {
        MethodBuilder methodBuilder = new MethodBuilder(this.constantPool);
        methodBuilder.setName("<init>", "()V");
        methodBuilder.setFlags(1);
        methodBuilder.code.reserveArguments(1);
        methodBuilder.code.reserveStack(1);
        methodBuilder.code.append(42);
        methodBuilder.code.append(183);
        methodBuilder.code.appendInt(methodBuilder.constantPool.defineMethod(this.superName, "<init>", "()V"));
        methodBuilder.code.append(177);
        this.addMethod(methodBuilder);
    }

    private void writeClassImage(DataOutputStream dataOutputStream) throws IOException {
        Object object;
        int n;
        dataOutputStream.writeShort(this.flags | 0x20);
        dataOutputStream.writeShort(this.constantPool.defineClass(this.className));
        dataOutputStream.writeShort(this.constantPool.defineClass(this.superName));
        dataOutputStream.writeShort(this.interfaces.size());
        for (n = 0; n < this.interfaces.size(); ++n) {
            object = (String)this.interfaces.elementAt(n);
            dataOutputStream.writeShort(this.constantPool.defineClass((String)object));
        }
        dataOutputStream.writeShort(this.fields.size());
        for (n = 0; n < this.fields.size(); ++n) {
            object = (FieldBuilder)this.fields.elementAt(n);
            ((FieldBuilder)object).writeFieldImage(dataOutputStream);
        }
        dataOutputStream.writeShort(this.methods.size());
        for (n = 0; n < this.methods.size(); ++n) {
            object = (MethodBuilder)this.methods.elementAt(n);
            ((MethodBuilder)object).writeMethodImage(dataOutputStream);
        }
        dataOutputStream.writeShort(0);
    }

    public void writeImage(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeClassImage(dataOutputStream);
        dataOutputStream.close();
        dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(3);
        dataOutputStream.writeShort(45);
        this.constantPool.writeTo(dataOutputStream);
        byteArrayOutputStream.writeTo(dataOutputStream);
        dataOutputStream.close();
    }

    public Class buildClass() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeImage(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Class<?> clazz = this.defineClass(this.className, byArray, 0, byArray.length);
            this.resolveClass(clazz);
            return clazz;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        return this.findSystemClass(string);
    }

    public ClassBuilder(String string) {
        this.className = string;
        this.superName = "java.lang.Object";
        this.flags = 17;
        this.interfaces = new Vector();
        this.methods = new Vector();
        this.fields = new Vector();
        this.constantPool.setThisClassName(this.className);
    }
}

