/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function.parser;

public class TokenMgrError
extends Error {
    static final int LEXICAL_ERROR = 0;
    static final int STATIC_LEXER_ERROR = 1;
    static final int INVALID_LEXICAL_STATE = 2;
    static final int LOOP_DETECTED = 3;
    int errorCode;

    protected static final String addEscapes(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            switch (s.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    stringbuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringbuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringbuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringbuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringbuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringbuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringbuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringbuffer.append("\\\\");
                    break;
                }
                default: {
                    char c = s.charAt(i);
                    if (c < ' ' || c > '~') {
                        String s1 = "0000" + Integer.toString(c, 16);
                        stringbuffer.append("\\u" + s1.substring(s1.length() - 4, s1.length()));
                        break;
                    }
                    stringbuffer.append(c);
                }
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    private static final String LexicalError(boolean flag, int i, int j, int k, String s, char c) {
        return "Lexical error at line " + j + ", column " + k + ".  Encountered: " + (flag ? "<EOF> " : "\"" + TokenMgrError.addEscapes(String.valueOf(c)) + "\"" + " (" + c + "), ") + "after : \"" + TokenMgrError.addEscapes(s) + "\"";
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public TokenMgrError() {
    }

    public TokenMgrError(String s, int i) {
        super(s);
        this.errorCode = i;
    }

    public TokenMgrError(boolean flag, int i, int j, int k, String s, char c, int l) {
        this(TokenMgrError.LexicalError(flag, i, j, k, s, c), l);
    }
}

