/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function.node;

import lt.monarch.function.Identifier;
import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.StdFunction;
import lt.monarch.function.Variable;
import lt.monarch.function.node.ConstantNode;
import lt.monarch.function.node.DivNode;
import lt.monarch.function.node.IdentifierNode;
import lt.monarch.function.node.MulNode;
import lt.monarch.function.node.OperatorNode;
import lt.monarch.function.node.PlusNode;
import lt.monarch.function.node.SumNode;
import lt.monarch.function.node.TimesNode;

public class PowerNode
extends OperatorNode {
    @Override
    public Node cloneNode() {
        return new PowerNode(this.l.cloneNode(), this.r.cloneNode());
    }

    @Override
    public Node simplifyOperation() {
        if (this.r instanceof ConstantNode && this.r.evaluate() == 1.0) {
            return this.l;
        }
        if (this.r instanceof ConstantNode && this.r.evaluate() == 0.0) {
            return new ConstantNode(1.0);
        }
        if (this.l instanceof ConstantNode && this.l.evaluate() == 1.0) {
            return this.l;
        }
        if (this.l instanceof PowerNode) {
            PowerNode powernode = (PowerNode)this.l;
            return new PowerNode(powernode.termNode(), new MulNode(powernode.powerNode(), this.r).simplifyOperation());
        }
        return super.simplifyOperation();
    }

    @Override
    public String toString() {
        return String.valueOf(!(this.l instanceof SumNode) && !(this.l instanceof TimesNode) ? this.l.toString() : "(" + this.l + ")") + "^" + (!(this.r instanceof SumNode) && !(this.r instanceof TimesNode) ? this.r.toString() : "(" + this.r + ")");
    }

    @Override
    public double evaluate() {
        return Math.pow(this.l.evaluate(), this.r.evaluate());
    }

    public Node powerNode() {
        return this.r;
    }

    public Node termNode() {
        return this.l;
    }

    @Override
    public Node derivative(Variable variable) {
        return new MulNode(this, new PlusNode(new DivNode(new MulNode(this.l.derivative(variable), this.r), this.l), new MulNode(new IdentifierNode((Identifier)new StdFunction(4), this.l), this.r.derivative(variable))));
    }

    @Override
    public void compile(NodeCompiler nodecompiler) {
        int i;
        double d;
        if (this.r instanceof ConstantNode && (d = this.r.evaluate()) == (double)(i = (int)d) && i <= 5 && i > 0) {
            this.l.compile(nodecompiler);
            nodecompiler.reserveStack(--i * 2);
            int j = 0;
            while (j < i) {
                nodecompiler.append(92);
                ++j;
            }
            int k = 0;
            while (k < i) {
                nodecompiler.append(107);
                ++k;
            }
            nodecompiler.freeStack(i * 2);
            return;
        }
        this.l.compile(nodecompiler);
        this.r.compile(nodecompiler);
        nodecompiler.appendStaticCall("java.lang.Math", "pow", "(DD)D");
        nodecompiler.freeStack(2);
    }

    public PowerNode(Node node, Node node1) {
        super(node, node1);
    }
}

