/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function.node;

import java.util.Vector;
import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.Variable;
import lt.monarch.function.node.ConstantNode;
import lt.monarch.function.node.NegativeNode;
import lt.monarch.function.node.SumNode;

public class MinusNode
extends SumNode {
    @Override
    public Node cloneNode() {
        return new MinusNode(this.l.cloneNode(), this.r.cloneNode());
    }

    @Override
    public String toString() {
        return this.l + "-" + this.r;
    }

    @Override
    public double evaluate() {
        return this.l.evaluate() - this.r.evaluate();
    }

    @Override
    public Node simplifyOperation() {
        if (this.r instanceof ConstantNode && this.r.evaluate() == 0.0) {
            return this.l;
        }
        if (this.l instanceof ConstantNode && this.l.evaluate() == 0.0) {
            return new NegativeNode(this.r);
        }
        return super.simplifyOperation();
    }

    @Override
    protected void enumerateOperands(Vector vector) {
        Vector<Node> vector1 = new Vector<Node>();
        if (!(this.l instanceof SumNode)) {
            this.l = this.l.simplify();
        }
        if (!(this.r instanceof SumNode)) {
            this.r = this.r.simplify();
        }
        if (this.l instanceof SumNode) {
            ((SumNode)this.l).enumerateOperands(vector);
        } else {
            vector.addElement(this.l);
        }
        if (this.r instanceof SumNode) {
            ((SumNode)this.r).enumerateOperands(vector1);
        } else {
            vector1.addElement(this.r);
        }
        int i = 0;
        while (i < vector1.size()) {
            Node node = (Node)vector1.elementAt(i);
            vector.addElement(new NegativeNode(node).simplifyOperation());
            ++i;
        }
    }

    @Override
    public Node derivative(Variable variable) {
        return new MinusNode(this.l.derivative(variable), this.r.derivative(variable));
    }

    @Override
    public void compile(NodeCompiler nodecompiler) {
        this.l.compile(nodecompiler);
        this.r.compile(nodecompiler);
        nodecompiler.append(103);
        nodecompiler.freeStack(2);
    }

    public MinusNode(Node node, Node node1) {
        super(node, node1);
    }
}

