/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function.node;

import lt.monarch.function.Identifier;
import lt.monarch.function.MacroIdentifier;
import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.Variable;
import lt.monarch.function.node.AbstractNode;
import lt.monarch.function.node.ConstantNode;
import lt.monarch.function.node.MulNode;
import lt.monarch.function.node.PlusNode;

public class IdentifierNode
extends AbstractNode {
    protected static Node[] noParams = new Node[0];
    protected Identifier identifier;
    protected Node[] params;
    protected double[] values;

    @Override
    public void visited(Node.Visitor visitor) {
        super.visited(visitor);
        int i = 0;
        while (i < this.params.length) {
            this.params[i].visited(visitor);
            ++i;
        }
    }

    @Override
    public Node cloneNode() {
        Node[] anode = new Node[this.params.length];
        int i = 0;
        while (i < anode.length) {
            anode[i] = this.params[i].cloneNode();
            ++i;
        }
        return new IdentifierNode(this.identifier, anode);
    }

    @Override
    public String toString() {
        StringBuffer stringbuffer = new StringBuffer(this.identifier.name());
        if (this.params.length != 0) {
            stringbuffer.append("(");
            int i = 0;
            while (i < this.params.length) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.params[i].toString());
                ++i;
            }
            stringbuffer.append(")");
        }
        return stringbuffer.toString();
    }

    @Override
    public Node simplify() {
        if (this.identifier instanceof MacroIdentifier) {
            return ((MacroIdentifier)this.identifier).expand(this.params);
        }
        boolean flag = true;
        int i = 0;
        while (i < this.params.length) {
            this.params[i] = this.params[i].simplify();
            flag &= this.params[i] instanceof ConstantNode;
            ++i;
        }
        if (this.params.length != 0 && flag || this.identifier.isConstant()) {
            return new ConstantNode(this.evaluate());
        }
        return this;
    }

    @Override
    public double evaluate() {
        int i = 0;
        while (i < this.params.length) {
            this.values[i] = this.params[i].evaluate();
            ++i;
        }
        return this.identifier.evaluate(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        IdentifierNode identifiernode = (IdentifierNode)obj;
        return this.identifier.equals(identifiernode.identifier) && this.paramsEquals(identifiernode.params);
    }

    private boolean paramsEquals(Node[] anode) {
        if (anode.length != this.params.length) {
            return false;
        }
        int i = 0;
        while (i < this.params.length) {
            if (!this.params[i].equals(anode[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Node derivative(Variable variable) {
        if (variable == this.identifier) {
            return new ConstantNode(1.0);
        }
        Node obj = new ConstantNode(0.0);
        int i = 0;
        while (i < this.params.length) {
            IdentifierNode identifiernode = new IdentifierNode(this.identifier.derivative(i), this.params);
            Node node = this.params[i].derivative(variable);
            Node node1 = new MulNode(identifiernode, node).simplifyOperation();
            obj = new PlusNode(obj, node1).simplifyOperation();
            ++i;
        }
        return obj;
    }

    @Override
    public void compile(NodeCompiler nodecompiler) {
        this.identifier.compileRef(nodecompiler, this.params);
    }

    public IdentifierNode(Identifier identifier1, Node[] anode) {
        this.identifier = identifier1;
        this.params = anode;
        if (this.params.length != 0) {
            this.values = new double[this.params.length];
        }
    }

    public IdentifierNode(Identifier identifier1, Node node) {
        this(identifier1, new Node[]{node});
    }

    public IdentifierNode(Identifier identifier1) {
        this(identifier1, noParams);
    }
}

