/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function.node;

import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.node.AbstractNode;
import lt.monarch.function.node.TermNode;

public class ConstantNode
extends AbstractNode
implements TermNode {
    private double value;

    @Override
    public Node cloneNode() {
        return new ConstantNode(this.value);
    }

    @Override
    public String toString() {
        String s = String.valueOf(this.value);
        if (this.value == Math.floor(this.value)) {
            s = String.valueOf((int)this.value);
        }
        return this.value >= 0.0 ? s : "(" + s + ")";
    }

    @Override
    public double evaluate() {
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.value == ((ConstantNode)obj).value;
    }

    @Override
    public double multiplier() {
        return this.value;
    }

    @Override
    public Node termNode() {
        return null;
    }

    @Override
    public void compile(NodeCompiler nodecompiler) {
        nodecompiler.appendConst(this.value);
    }

    public ConstantNode(double d) {
        this.value = d;
    }
}

