/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function;

import lt.monarch.function.CompiledFunctionSet;
import lt.monarch.function.Node;
import lt.monarch.function.Variable;
import lt.monarch.jasm.ConstantPool;
import lt.monarch.jasm.MethodBuilder;

public class NodeCompiler {
    CompiledFunctionSet cset;
    MethodBuilder method;
    ConstantPool constants;
    Variable[] variables;
    int firstParameterIndex;

    public void setParameters(Variable[] variableArray) {
        this.setParameters((this.method.getFlags() & 8) != 0, this.method.getDescriptor(), variableArray);
    }

    public void setParameters(boolean bl, String string, Variable[] variableArray) {
        this.variables = variableArray;
        this.method.code.resetArguments();
        this.method.setName(this.method.getName(), string);
        if (bl) {
            this.firstParameterIndex = 0;
            this.method.setFlags(25);
        } else {
            this.firstParameterIndex = 1;
            this.method.code.reserveArguments(1);
            this.method.setFlags(17);
        }
        if (this.method.getDescriptor().charAt(1) != '[') {
            this.method.code.reserveArguments(variableArray != null ? variableArray.length * 2 : 0);
        } else {
            this.method.code.reserveArguments(1);
        }
    }

    public CompiledFunctionSet functionSet() {
        return this.cset;
    }

    public void compile(Node node) {
        node.compile(this);
        this.method.code.append(175);
    }

    public void reserveStack(int n) {
        this.method.code.reserveStack(n);
    }

    public void freeStack(int n) {
        this.method.code.freeStack(n);
    }

    protected int getVariableIndex(Variable variable) {
        if (this.variables != null) {
            for (int i = 0; i < this.variables.length; ++i) {
                if (this.variables[i] != variable) continue;
                return i;
            }
        }
        return -1;
    }

    public void appendConst(double d) {
        this.reserveStack(2);
        this.method.code.append(20);
        this.method.code.appendInt(this.constants.define(d));
    }

    public void appendConst(int n) {
        if (n <= 5) {
            this.method.code.append(3 + n);
        } else if (n < 127 && n > -128) {
            this.method.code.append(16);
            this.method.code.append(n);
        } else {
            this.method.code.append(18);
            this.method.code.append(this.constants.define(n));
        }
    }

    public void append(int n) {
        this.method.code.append(n);
    }

    protected void appendLocalVariable(int n) {
        if (this.method.getDescriptor().charAt(1) != '[') {
            this.appendLocalDoubleParameter(n);
        } else {
            this.appendLocalArrayParameter(n);
        }
    }

    protected void appendLocalArrayParameter(int n) {
        this.method.code.append(42 + this.firstParameterIndex);
        this.appendConst(n);
        this.method.code.append(49);
    }

    protected void appendLocalDoubleParameter(int n) {
        if ((n = n * 2 + this.firstParameterIndex) <= 3) {
            this.method.code.append(38 + n);
        } else {
            this.method.code.append(24);
            this.method.code.append(n);
        }
    }

    protected void appendGlobalVariable(int n) {
        this.reserveStack(1);
        this.method.code.append(178);
        this.method.code.appendInt(this.constants.defineField(null, "globals", "[Llt/monarch/function/Variable;"));
        this.appendConst(n);
        this.method.code.append(50);
        this.appendCall("lt.monarch.function.Variable", "getValue", "()D");
        this.freeStack(1);
    }

    public void appendVariable(Variable variable) {
        this.reserveStack(2);
        int n = this.getVariableIndex(variable);
        if (n != -1) {
            this.appendLocalVariable(n);
        } else {
            this.appendGlobalVariable(this.cset.getReferencedVariableIndex(variable));
        }
    }

    public void appendStaticCall(String string, String string2, String string3) {
        this.method.code.append(184);
        this.method.code.appendInt(this.constants.defineMethod(string, string2, string3));
    }

    public void appendCall(String string, String string2, String string3) {
        this.method.code.append(182);
        this.method.code.appendInt(this.constants.defineMethod(string, string2, string3));
    }

    public NodeCompiler(CompiledFunctionSet compiledFunctionSet, String string) {
        this.cset = compiledFunctionSet;
        this.method = new MethodBuilder(this.cset.classBuilder.constantPool);
        this.constants = this.method.constantPool;
        this.method.setName(string, "()D");
        this.setParameters(false, "()D", null);
    }
}

