/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import lt.monarch.debug.ErrorLogEngine;
import lt.monarch.swing.JTextLabel;
import lt.monarch.swing.tree.StaticTreeNode;
import lt.monarch.swing.tree.StringTreeNode;

class SwingLogTreeModel
extends DefaultTreeModel {
    static DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);

    public void clear() {
        LogNode logNode = (LogNode)this.getRoot();
        logNode.clear();
        this.reload();
    }

    public void add(ErrorLogEngine.LogPacket logPacket) {
        LogNode logNode = (LogNode)this.getRoot();
        logNode.add(logPacket);
        int[] nArray = new int[]{logNode.getChildCount() - 1};
        this.nodesWereInserted(logNode, nArray);
    }

    SwingLogTreeModel() {
        super(new LogNode());
    }

    public static class CellRenderer
    extends JPanel
    implements TreeCellRenderer {
        ImageIcon logEntryIcon;
        public JLabel icon = new JLabel("");
        public JTextLabel text = new JTextLabel("");
        public DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object instanceof StackEntryNode) {
                this.defaultRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, false);
                this.defaultRenderer.setIcon(null);
                return this.defaultRenderer;
            }
            if (object instanceof LogEntryNode) {
                if (bl) {
                    this.setForeground(this.defaultRenderer.getTextSelectionColor());
                    this.setBackground(this.defaultRenderer.getBackgroundSelectionColor());
                } else {
                    this.setForeground(this.defaultRenderer.getTextNonSelectionColor());
                    this.setBackground(this.defaultRenderer.getBackgroundNonSelectionColor());
                }
                String string = object.toString().trim();
                while (string.endsWith("\n") || string.endsWith("\r")) {
                    string = string.substring(1, string.length() - 1);
                }
                this.text.setText(string);
                this.setEnabled(jTree.isEnabled());
                this.revalidate();
                return this;
            }
            return this.defaultRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, false);
        }

        public CellRenderer() {
            super(new BorderLayout());
            this.icon.setIcon(this.logEntryIcon);
            this.add("West", this.icon);
            this.add("Center", this.text);
        }
    }

    static class StackEntryNode
    extends StringTreeNode {
        public StackEntryNode(LogEntryNode logEntryNode, String string) {
            super(logEntryNode, string);
        }
    }

    static class LogEntryNode
    extends StaticTreeNode {
        ErrorLogEngine.LogPacket packet;

        public String toString() {
            return this.packet.debugText();
        }

        @Override
        protected Vector loadSubtree() {
            Vector<StackEntryNode> vector = new Vector<StackEntryNode>();
            if (this.packet.exception() != null) {
                try {
                    CharArrayWriter charArrayWriter = new CharArrayWriter();
                    this.packet.exception().printStackTrace(new PrintWriter(charArrayWriter));
                    charArrayWriter.close();
                    BufferedReader bufferedReader = new BufferedReader(new CharArrayReader(charArrayWriter.toCharArray()));
                    String string = bufferedReader.readLine();
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.length() == 0 || string.charAt(0) != '\t' || (string = string.trim()).length() == 0) continue;
                        string = string.substring(3);
                        vector.addElement(new StackEntryNode(this, string));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return vector;
        }

        public LogEntryNode(LogNode logNode, ErrorLogEngine.LogPacket logPacket) {
            super(logNode);
            this.packet = logPacket;
        }
    }

    static class LogNode
    implements TreeNode {
        Vector log = new Vector();

        public void add(ErrorLogEngine.LogPacket logPacket) {
            this.log.addElement(new LogEntryNode(this, logPacket));
        }

        public void clear() {
            this.log.removeAllElements();
        }

        @Override
        public TreeNode getChildAt(int n) {
            return (LogEntryNode)this.log.elementAt(n);
        }

        public String toString() {
            return "Log";
        }

        @Override
        public int getChildCount() {
            return this.log.size();
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return this.log.indexOf(treeNode);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public Enumeration children() {
            return this.log.elements();
        }

        LogNode() {
        }
    }
}

