/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.charts;

import java.awt.Color;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import lt.monarch.awt.Tooltip;
import lt.monarch.charts.ChartSeries;
import lt.monarch.charts.Grid;
import lt.monarch.charts.XAxis;
import lt.monarch.charts.YAxis;

public class Chart
extends Panel {
    protected final int border = 10;
    protected Tooltip tip;
    protected String lastTip;
    protected Rectangle chartArea;
    protected Rectangle bounds;
    protected Vector series;
    protected XAxis axisB;
    protected YAxis axisL;
    protected YAxis axisR;
    protected Grid grid;

    public Chart() {
        this.setBackground(Color.white);
        this.setLayout(new FlowLayout());
        this.tip = new Tooltip();
        this.add(this.tip);
    }

    public synchronized Rectangle chartArea(Graphics graphics) {
        if (this.chartArea != null && this.bounds != null && this.bounds.equals(this.bounds())) {
            return this.chartArea;
        }
        this.bounds = this.bounds();
        int n = this.axisR == null ? 0 : this.axisR.width(graphics);
        int n2 = this.axisL == null ? 0 : this.axisL.width(graphics);
        int n3 = this.axisB.height(graphics);
        this.chartArea = new Rectangle(10 + n2, 10, this.bounds.width - n2 - n - 20, this.bounds.height - n3 - 20);
        return this.chartArea;
    }

    @Override
    public boolean mouseExit(Event event, int n, int n2) {
        this.tip.hide();
        return true;
    }

    @Override
    public boolean mouseMove(Event event, int n, int n2) {
        if (this.series == null) {
            return true;
        }
        Object var4_4 = null;
        String string = null;
        Point point = new Point(n, n2);
        for (int i = this.series.size() - 1; i >= 0 && string == null; --i) {
            ChartSeries chartSeries = (ChartSeries)this.series.elementAt(i);
            string = chartSeries.tipAt(point);
        }
        if (string == null) {
            this.tip.hide();
        } else if (this.lastTip == null || !this.lastTip.equals(string)) {
            this.tip.showTip(string, point);
        }
        this.lastTip = string;
        return true;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.series == null) {
            return;
        }
        Rectangle rectangle = this.chartArea(graphics);
        if (this.axisB != null) {
            this.axisB.draw(graphics, new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, this.bounds.height - rectangle.height - rectangle.y - 10));
        }
        if (this.axisL != null) {
            this.axisL.draw(graphics, new Rectangle(10, rectangle.y, rectangle.x - 10, rectangle.height));
        }
        if (this.axisR != null) {
            this.axisR.draw(graphics, new Rectangle(rectangle.x + rectangle.width, rectangle.y, this.bounds.width - rectangle.x - rectangle.width - 10, rectangle.height));
        }
        if (this.grid != null) {
            this.grid.draw(graphics, rectangle);
        }
        for (int i = 0; i < this.series.size(); ++i) {
            ((ChartSeries)this.series.elementAt(i)).draw(graphics, rectangle);
        }
        super.paintComponents(graphics);
    }

    public void setGrid(Grid grid) {
        this.grid = grid;
        this.chartArea = null;
    }

    public void setLeftAxis(YAxis yAxis) {
        this.axisL = yAxis;
        this.axisL.alignRight = true;
        this.chartArea = null;
    }

    public void setRightAxis(YAxis yAxis) {
        this.axisR = yAxis;
        this.axisR.alignRight = false;
        this.chartArea = null;
    }

    public void setXAxis(XAxis xAxis) {
        this.axisB = xAxis;
        this.chartArea = null;
    }

    public void setup(Vector vector) {
        this.series = vector;
        this.axisB = null;
        this.axisL = null;
        this.axisR = null;
        this.grid = null;
        this.chartArea = null;
    }
}

