/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart.chart2D;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import lt.monarch.chart.AbstractChartObject;
import lt.monarch.chart.NormalizedMatrix;
import lt.monarch.chart.NormalizedPoint;
import lt.monarch.chart.PlainMapper;

public class DensityMap
extends AbstractChartObject {
    protected PlainMapper mapper;
    protected NormalizedMatrix matrix;
    protected Color[] palette;

    public DensityMap(PlainMapper plainmapper, NormalizedMatrix normalizedmatrix) {
        this.mapper = plainmapper;
        this.matrix = normalizedmatrix;
        this.setPalette(DensityMap.createDefaultPalette(128));
    }

    public static Color[] createDefaultPalette(int i) {
        Color[] acolor = new Color[i];
        float[] af = new float[]{0.46875f, 0.9765625f, 0.0390625f};
        float[] af1 = new float[]{0.1757813f, 0.9375f, 0.9960938f};
        float[] af2 = new float[3];
        int j = 0;
        while (j < i) {
            float f = (float)j / (float)(i - 1);
            af2[0] = (1.0f + af1[0] - af[0]) * f + af[0];
            af2[1] = (af[1] - af1[1]) * f + af1[1];
            af2[2] = (af1[2] - af[2]) * f + af[2];
            if (af2[0] > 1.0f) {
                af2[0] = af2[0] - 1.0f;
            }
            acolor[j] = Color.getHSBColor(af2[0], af2[1], af2[2]);
            ++j;
        }
        return acolor;
    }

    public static Color[] createGrayPalette(int i) {
        return DensityMap.createGrayPalette(i, 0.5f);
    }

    public static Color[] createGrayPalette(int i, float f) {
        Color[] acolor = new Color[i];
        int j = 0;
        while (j < i) {
            float f1 = (float)j / (float)(i - 1) / 2.0f + f;
            int k = (int)(255.0f * f1);
            acolor[j] = new Color(k, k, k);
            ++j;
        }
        return acolor;
    }

    @Override
    public void draw(Graphics g) {
        if (this.mapper == null) {
            this.drawImageMap(g);
        } else {
            this.drawPolygonMap(g);
        }
    }

    private void drawImageMap(Graphics g) {
        int i = this.matrix.resolutionX;
        int j = this.matrix.resolutionY;
        byte[] abyte0 = new byte[i * j];
        byte[] abyte1 = new byte[this.palette.length];
        byte[] abyte2 = new byte[this.palette.length];
        byte[] abyte3 = new byte[this.palette.length];
        int k = 0;
        while (k < this.palette.length) {
            abyte1[k] = (byte)(this.palette[k].getRed() & 0xFF);
            abyte2[k] = (byte)(this.palette[k].getGreen() & 0xFF);
            abyte3[k] = (byte)(this.palette[k].getBlue() & 0xFF);
            ++k;
        }
        int l = 0;
        while (l < abyte0.length) {
            abyte0[l] = 50;
            ++l;
        }
        int i1 = 0;
        int j1 = this.palette.length - 1;
        int k1 = j - 1;
        while (k1 >= 0) {
            int l1 = 0;
            while (l1 < i) {
                abyte0[i1++] = (byte)((int)(this.matrix.z[l1][k1] * (double)j1) & 0xFF);
                ++l1;
            }
            --k1;
        }
        IndexColorModel indexcolormodel = new IndexColorModel(8, this.palette.length, abyte1, abyte2, abyte3);
        MemoryImageSource memoryimagesource = new MemoryImageSource(i, j, (ColorModel)indexcolormodel, abyte0, 0, i);
        Image image = this.chart().container().getComponent().createImage(memoryimagesource);
        MediaTracker mediatracker = new MediaTracker(this.chart().container().getComponent());
        mediatracker.addImage(image, 0);
        try {
            mediatracker.waitForID(0);
        }
        catch (InterruptedException _ex) {
            return;
        }
        mediatracker.removeImage(image, 0);
        Rectangle rectangle = this.chart().projector().getProjectionArea();
        g.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        image.flush();
    }

    private void drawPolygonMap(Graphics g) {
        NormalizedPoint normalizedpoint = this.mapper.map(0.0, 0.0);
        Point point = new Point();
        double[] ad = new double[2];
        int[] ai = new int[4];
        int[] ai1 = new int[4];
        double d = this.matrix.resolutionX;
        double d1 = this.matrix.resolutionY;
        int i = this.palette.length - 1;
        int j = 0;
        while (j < this.matrix.resolutionX) {
            ad[0] = ((double)j - 0.0) / d;
            ad[1] = ((double)j + 1.0) / d;
            int k = 0;
            while (k < 2) {
                Point point1 = this.chart().projector().project(this.mapper.map(ad[k], 0.0, normalizedpoint), point);
                ai[2 + k] = point1.x;
                ai1[2 + k] = point1.y;
                ++k;
            }
            int l = 0;
            while (l < this.matrix.resolutionY) {
                double d2 = ((double)l + 1.0) / d1;
                ai[0] = ai[3];
                ai1[0] = ai1[3];
                ai[1] = ai[2];
                ai1[1] = ai1[2];
                int i1 = 0;
                while (i1 < 2) {
                    Point point2 = this.chart().projector().project(this.mapper.map(ad[i1], d2, normalizedpoint), point);
                    ai[2 + i1] = point2.x;
                    ai1[2 + i1] = point2.y;
                    ++i1;
                }
                g.setColor(this.palette[(int)(this.matrix.z[j][l] * (double)i)]);
                g.fillPolygon(ai, ai1, 4);
                ++l;
            }
            ++j;
        }
    }

    public void setPalette(Color[] acolor) {
        this.palette = acolor;
    }
}

