/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart.chart2D;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import lt.monarch.chart.AxisMapper;
import lt.monarch.chart.PlainMapper;
import lt.monarch.chart.chart2D.Axis2D;
import lt.monarch.chart.chart2D.ChartPoint;
import lt.monarch.chart.chart2D.ChartPointProvider;
import lt.monarch.chart.chart2D.DotSeries;
import lt.monarch.chart.chart2D.NormalizedPoint2D;

public class ConnectedSeries
extends DotSeries {
    protected Color lineColor = Color.red;
    protected Color fillColor = null;
    protected Stroke lineStroke;

    public ConnectedSeries(ChartPointProvider chartpointprovider, PlainMapper plainmapper, AxisMapper axismapper, AxisMapper axismapper1) {
        super(chartpointprovider, plainmapper, axismapper, axismapper1);
    }

    public ConnectedSeries(ChartPointProvider chartpointprovider, Axis2D axis2d, Axis2D axis2d1) {
        super(chartpointprovider, axis2d, axis2d1);
    }

    @Override
    public void draw(Graphics g) {
        Polygon polygon = new Polygon();
        double d = 0.0;
        double d1 = 0.0;
        int i = this.provider.pointCount();
        int j = 0;
        while (j < i) {
            NormalizedPoint2D normalizedpoint2d = this.provider.point(j).getCenter(g, this);
            Point point = this.chart().projector().project(normalizedpoint2d);
            polygon.addPoint(point.x, point.y);
            d1 = normalizedpoint2d.x;
            if (j == 0) {
                d = d1;
            }
            ++j;
        }
        if (i != 0 && this.fillColor != null) {
            Polygon polygon1 = new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            Point point1 = this.chart().projector().project(this.mapper.map(d1, 0.0));
            polygon1.addPoint(point1.x, point1.y);
            Point point2 = this.chart().projector().project(this.mapper.map(d, 0.0));
            polygon1.addPoint(point2.x, point2.y);
            g.setColor(this.fillColor);
            g.fillPolygon(polygon1);
        }
        Stroke stroke = null;
        if (this.lineStroke != null) {
            stroke = ((Graphics2D)g).getStroke();
            ((Graphics2D)g).setStroke(this.lineStroke);
        }
        g.setColor(this.lineColor);
        g.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
        if (stroke != null) {
            ((Graphics2D)g).setStroke(stroke);
        }
        this.drawPoints(g);
    }

    @Override
    public void pointAdded(ChartPointProvider chartpointprovider, ChartPoint chartpoint) {
        this.chart().invalidate();
    }

    public void setColor(Color color) {
        this.lineColor = color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setStroke(Stroke stroke) {
        this.lineStroke = stroke;
    }
}

