/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class TextLabel
extends Canvas {
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    protected String[] text;
    protected int alignment;

    public TextLabel() {
        this(2);
    }

    public TextLabel(int n) {
        this.text = new String[0];
        this.alignment = n;
    }

    public TextLabel(String string) {
        this(string, 2);
    }

    public TextLabel(String string, int n) {
        this.alignment = n;
        this.setText(string);
    }

    public TextLabel(String[] stringArray) {
        this(stringArray, 2);
    }

    public TextLabel(String[] stringArray, int n) {
        this.alignment = n;
        this.text = stringArray;
    }

    @Override
    public void paint(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        graphics.setColor(this.getForeground());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(" ");
        block5: for (int i = 0; i < this.text.length; ++i) {
            switch (this.alignment) {
                case 3: {
                    graphics.drawString(this.text[i], rectangle.width - fontMetrics.stringWidth(this.text[i]) - n, i * fontMetrics.getHeight() + fontMetrics.getAscent());
                    continue block5;
                }
                case 2: {
                    graphics.drawString(this.text[i], n, i * fontMetrics.getHeight() + fontMetrics.getAscent());
                    continue block5;
                }
                case 1: {
                    graphics.drawString(this.text[i], (rectangle.width - fontMetrics.stringWidth(this.text[i])) / 2, i * fontMetrics.getHeight() + fontMetrics.getAscent());
                }
            }
        }
    }

    @Override
    public Dimension preferredSize() {
        int n;
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = 0;
        for (n = 0; n < this.text.length; ++n) {
            int n3 = fontMetrics.stringWidth(this.text[n]);
            if (n2 >= n3) continue;
            n2 = n3;
        }
        n = fontMetrics.stringWidth(" ");
        return new Dimension(n2 + n * 2, this.text.length * fontMetrics.getHeight());
    }

    public void setText(String string) {
        int n;
        int n2 = 1;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '\n') continue;
            ++n2;
        }
        this.text = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.text[n] = new String();
        }
        n2 = 0;
        block6: for (n = 0; n < string.length(); ++n) {
            switch (string.charAt(n)) {
                case '\n': {
                    ++n2;
                    continue block6;
                }
                default: {
                    int n3 = n2;
                    this.text[n3] = this.text[n3] + string.charAt(n);
                }
                case '\r': 
            }
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

