/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.ui;

import java.util.Vector;
import lt.ktu.gmj.Method;
import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultLogger;
import lt.ktu.gmj.Task;
import lt.ktu.gmj.ui.ResultNotifyer;

public class ResultSet
extends ResultNotifyer
implements ResultLogger {
    protected Method method;
    protected Task task;
    protected Result lastResult;
    protected Vector log = new Vector(1000, 1000);
    protected Vector progressLog = new Vector(1000, 1000);
    protected double progress;
    protected double minValue;
    protected double maxValue;
    Object blockingMonitor = null;

    public void startLog() {
        this.lastResult = new Result();
        this.log.removeAllElements();
        this.progressLog.removeAllElements();
        this.progress = Double.MAX_VALUE;
        this.minValue = Double.MAX_VALUE;
        this.maxValue = Double.NEGATIVE_INFINITY;
        this.fireLogStarted();
    }

    public void dispose() {
        this.fireLogDisposed();
    }

    public void setResult(Result result) {
        this.lastResult = result;
        this.progressLog.addElement(new Result(this.method.iterations(), result.point, result.value));
        this.fireFinalResult();
    }

    public synchronized void blockOn(Object obj) {
        this.blockingMonitor = obj;
    }

    public synchronized void resume() {
        this.blockingMonitor = null;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void log(Result result) {
        this.lastResult = result;
        this.log.addElement(result);
        if (result.value < this.minValue) {
            this.minValue = result.value;
        }
        if (result.value > this.maxValue) {
            this.maxValue = result.value;
        }
        if (result.value < this.progress) {
            this.progress = result.value;
            this.progressLog.addElement(result);
            this.fireNewProgressResult();
        }
        this.fireNewResult();
        Thread.yield();
        if (this.blockingMonitor != null) {
            Object object = this.blockingMonitor;
            synchronized (object) {
                this.blockingMonitor.notify();
            }
            if (Thread.interrupted()) {
                throw new ResultLogger.AbortedError();
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedexception) {
                throw new ResultLogger.AbortedError();
            }
        }
    }

    @Override
    public synchronized Result logAt(int i) {
        return (Result)this.log.elementAt(i);
    }

    @Override
    public Result lastResult() {
        return this.lastResult;
    }

    @Override
    public synchronized int resultCount() {
        return this.log.size();
    }

    @Override
    public synchronized Result resultAt(int i) {
        return (Result)this.log.elementAt(i);
    }

    @Override
    public synchronized int progressResultCount() {
        return this.progressLog.size();
    }

    @Override
    public synchronized Result progressResultAt(int i) {
        return (Result)this.progressLog.elementAt(i);
    }

    @Override
    public Task task() {
        return this.task;
    }

    @Override
    public Method method() {
        return this.method;
    }

    @Override
    public double minValue() {
        return this.minValue;
    }

    @Override
    public double maxValue() {
        return this.maxValue;
    }

    public ResultSet(Method method1, Task task1) {
        this.method = method1;
        this.task = task1;
        this.startLog();
    }
}

