/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.ui;

import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultLogger;
import lt.ktu.gmj.ui.MinimizerDirector;
import lt.ktu.gmj.ui.ResultSet;
import lt.monarch.debug.ErrorLog;

public class Minimizer
extends Thread {
    protected ResultSet set;
    protected MinimizerDirector director;
    protected boolean suspended;

    public Minimizer(MinimizerDirector minimizerdirector, ResultSet resultset) {
        this.director = minimizerdirector;
        this.set = resultset;
        this.setPriority(4);
        this.set.startLog();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resumeMinimizer() {
        this.suspended = false;
        this.set.resume();
        this.director.minimizerStateChanged();
    }

    @Override
    public void run() {
        try {
            Result result = this.set.method.run(this.set, this.set.task);
            this.set.setResult(result);
        }
        catch (ResultLogger.AbortedError result) {
        }
        catch (Exception exception) {
            ErrorLog.defaultLog().log("Method execution failed", exception);
        }
        this.director.minimizationComplete();
    }

    public void startMinimizer() {
        this.suspended = false;
        this.set.resume();
        this.start();
        this.director.minimizerStateChanged();
    }

    public synchronized void stopMinimizer() {
        if (this.isAlive()) {
            this.suspended = false;
            this.set.blockOn(this);
            this.interrupt();
        }
    }

    public void suspendMinimizer() {
        this.suspended = true;
        this.set.blockOn(this);
        this.director.minimizerStateChanged();
    }
}

