/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import lt.ktu.gmj.GlobalTools;
import lt.ktu.gmj.Method;
import lt.ktu.gmj.Task;
import lt.ktu.gmj.TaskWithAnalyzers;
import lt.ktu.gmj.analysis.ResultAnalyzer;
import lt.ktu.gmj.propertySheet.Header;
import lt.ktu.gmj.propertySheet.PropertySheet;
import lt.ktu.gmj.ui.Logo;
import lt.ktu.gmj.ui.Minimizer;
import lt.ktu.gmj.ui.MinimizerDirector;
import lt.ktu.gmj.ui.ResultSet;
import lt.ktu.gmj.ui.ResultSheet;
import lt.monarch.debug.ErrorLog;
import lt.monarch.debug.MultiLogEngine;
import lt.monarch.debug.StdErrLogEngine;
import lt.monarch.debug.SwingListLogEngine;
import lt.monarch.swing.applet.AppletFrame;

public class GMJ
extends JApplet
implements MinimizerDirector,
Runnable {
    static final String[] logoText = new String[]{"Method algorithms by Jonas Mockus", "Design&Implementation by Modestas Grybauskas", "e-mail: Modestas_G@equinoxlt.com"};
    protected static String taskNames;
    protected static String methodNames;
    protected static String analysisNames;
    protected Logo logo;
    protected JTabbedPane pages;
    protected Method method;
    protected JComboBox methodChoice;
    protected PropertySheet methodProperties;
    protected Hashtable methods;
    protected Task task;
    protected JComboBox taskChoice;
    protected PropertySheet taskProperties;
    protected JButton run;
    protected JButton pause;
    protected JButton stop;
    protected JButton analysis;
    protected Minimizer minimizer;
    protected ResultSet results;
    protected ResultSheet resultProperties;
    JPopupMenu jpopupmenu;

    static {
        MultiLogEngine multilogengine = new MultiLogEngine();
        multilogengine.addLogEngine(new SwingListLogEngine());
        multilogengine.addLogEngine(new StdErrLogEngine());
        ErrorLog.setDefaultLog(new ErrorLog(multilogengine));
    }

    public GMJ() {
        GlobalTools.setApplet(this);
        this.method = null;
        this.methods = new Hashtable();
        this.task = null;
    }

    protected static String completeClassName(String s, String[] as) {
        int i = 0;
        while (i < as.length) {
            String s1 = as[i];
            if (s.equals(GMJ.shortClassName(s1))) {
                return s1;
            }
            ++i;
        }
        return null;
    }

    protected void enableControls() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.run.setEnabled(this.minimizer == null || this.minimizer != null && this.minimizer.isSuspended());
            this.pause.setEnabled(this.minimizer != null && !this.minimizer.isSuspended());
            this.stop.setEnabled(this.minimizer != null);
            this.analysis.setEnabled(this.results != null);
            this.stop.setText("Stop");
            this.pages.setEnabledAt(0, this.minimizer == null);
            this.pages.setEnabledAt(1, this.minimizer == null);
            this.pages.setEnabledAt(2, this.method != null && this.task != null);
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public String getAppletInfo() {
        return this.logo.getInfo();
    }

    @Override
    public void init() {
        GlobalTools.setApplet(this);
        try {
            try {
                taskNames = this.getParameter("TASKS");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                methodNames = this.getParameter("METHODS");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                analysisNames = this.getParameter("ANALYSIS");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.pages = new JTabbedPane();
            this.pages.setBackground(Color.white);
            this.getContentPane().setBackground(new Color(230, 230, 230));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", this.pages);
            JPanel jpanel = new JPanel();
            jpanel.setLayout(new FlowLayout(2));
            jpanel.add(new JLabel("Select method and properties:"));
            this.methodChoice = new JComboBox();
            jpanel.add(this.methodChoice);
            this.methodProperties = new PropertySheet();
            JPanel jpanel1 = new JPanel();
            jpanel1.setLayout(new BorderLayout(4, 4));
            jpanel1.add("North", jpanel);
            jpanel1.add("Center", this.methodProperties);
            this.pages.addTab("Method", jpanel1);
            JPanel jpanel2 = new JPanel();
            jpanel2.setLayout(new FlowLayout(2));
            jpanel2.add(new JLabel("Select task and properties:"));
            this.taskChoice = new JComboBox();
            jpanel2.add(this.taskChoice);
            this.taskProperties = new PropertySheet();
            JPanel jpanel3 = new JPanel();
            jpanel3.setLayout(new BorderLayout(4, 4));
            jpanel3.add("North", jpanel2);
            jpanel3.add("Center", this.taskProperties);
            this.pages.add("Task", jpanel3);
            JPanel jpanel4 = new JPanel();
            jpanel4.setLayout(new GridLayout(1, 4));
            this.run = new JButton("Run");
            this.pause = new JButton("Pause");
            this.stop = new JButton("Stop");
            this.analysis = new JButton("Analysis");
            jpanel4.add(this.run);
            jpanel4.add(this.pause);
            jpanel4.add(this.stop);
            jpanel4.add(this.analysis);
            this.run.setForeground(Color.green);
            this.stop.setForeground(Color.red);
            this.resultProperties = new ResultSheet();
            JPanel jpanel5 = new JPanel();
            jpanel5.setLayout(new BorderLayout(4, 4));
            jpanel5.add("South", jpanel4);
            jpanel5.add("Center", this.resultProperties);
            this.pages.addTab("Operation", jpanel5);
            GMJ.loadClassChoice(this.methodChoice, GMJ.parseClassList(methodNames));
            GMJ.loadClassChoice(this.taskChoice, GMJ.parseClassList(taskNames));
            this.methodChoice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    GMJ.this.stop();
                    GMJ.this.reloadMethod();
                }
            });
            this.taskChoice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    GMJ.this.stop();
                    GMJ.this.reloadTask();
                }
            });
            this.run.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    if (GMJ.this.minimizer != null) {
                        GMJ.this.minimizer.resumeMinimizer();
                    } else {
                        if (GMJ.this.results == null) {
                            GMJ.this.results = new ResultSet(GMJ.this.method, GMJ.this.task);
                            GMJ.this.results.addObserver(GMJ.this.resultProperties);
                        }
                        GMJ.this.minimizer = new Minimizer(GMJ.this, GMJ.this.results);
                        GMJ.this.minimizer.startMinimizer();
                    }
                }
            });
            this.pause.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    if (GMJ.this.minimizer != null) {
                        GMJ.this.minimizer.suspendMinimizer();
                    }
                    GMJ.this.run.setEnabled(true);
                }
            });
            this.stop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    if (GMJ.this.minimizer != null) {
                        GMJ.this.run.setEnabled(false);
                    }
                    GMJ.this.pause.setEnabled(false);
                    GMJ.this.stop.setEnabled(false);
                    GMJ.this.stop.setText("Wait...");
                    GMJ.this.stop();
                }
            });
            this.analysis.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    GMJ.this.showAnalysisMenu();
                }
            });
            this.reloadMethod();
            this.reloadTask();
        }
        catch (Throwable throwable) {
            this.getContentPane().removeAll();
            ErrorLog.defaultLog().log("Initialization error", throwable);
        }
    }

    protected static void loadClassChoice(JComboBox jcombobox, String[] as) {
        int i = 0;
        while (i < as.length) {
            String s = GMJ.shortClassName(as[i]);
            jcombobox.addItem(s);
            ++i;
        }
    }

    public static void main(String[] args) throws ClassNotFoundException {
        System.out.println("Global Minimizer II For Java. Modestas Grybauskas 1999");
        if (args.length == 0) {
            System.out.println("Syntax: java lt.ktu.gmj.ui.GMJ <task names> <method names> <analysis names>");
        }
        if (args.length > 0) {
            taskNames = args[0];
        }
        if (args.length > 1) {
            methodNames = args[1];
        }
        if (args.length > 2) {
            analysisNames = args[2];
        }
        new AppletFrame(new GMJ(), "GMJ", new Dimension(800, 500));
    }

    @Override
    public void minimizationComplete() {
        this.minimizer = null;
        this.enableControls();
    }

    @Override
    public void minimizerStateChanged() {
        this.enableControls();
    }

    protected static String[] parseClassList(String s) {
        int i = 0;
        int j = 0;
        while (j < s.length()) {
            ++i;
            if ((j = s.indexOf(124, j)) == -1) {
                j = s.length();
            }
            ++j;
        }
        int k = 0;
        String[] as = new String[i];
        int l = 0;
        while (l < s.length()) {
            int i1 = s.indexOf(124, l);
            if (i1 == -1) {
                i1 = s.length();
            }
            String s1 = s.substring(l, i1);
            as[k++] = s1;
            l = i1;
            ++l;
        }
        return as;
    }

    protected void reloadMethod() {
        String s = GMJ.parseClassList(methodNames)[this.methodChoice.getSelectedIndex()];
        this.method = (Method)this.methods.get(s);
        this.methodProperties.removeAll();
        this.method = null;
        if (this.method == null) {
            try {
                this.method = (Method)Class.forName(s).newInstance();
                this.methods.put(s, this.method);
            }
            catch (Throwable throwable) {
                this.enableControls();
                this.methodProperties.complete();
                ErrorLog.defaultLog().log("Method could not be initialized", throwable);
                return;
            }
        }
        this.methodProperties.add(new Header("Property", "Value"));
        this.method.customize(this.methodProperties);
        this.methodProperties.complete();
        this.enableControls();
    }

    protected void reloadTask() {
        String s = GMJ.parseClassList(taskNames)[this.taskChoice.getSelectedIndex()];
        this.taskProperties.removeAll();
        this.task = null;
        try {
            this.task = (Task)Class.forName(s).newInstance();
        }
        catch (Throwable throwable) {
            this.enableControls();
            this.taskProperties.complete();
            ErrorLog.defaultLog().log("Task could not be initialized", throwable);
            return;
        }
        this.taskProperties.add(new Header("Property", "Value"));
        this.task.customize(this.taskProperties);
        this.task.domain().customize(this.taskProperties);
        this.taskProperties.complete();
        this.enableControls();
    }

    protected void removeLogo() {
        if (this.logo != null) {
            this.remove(this.logo);
            this.logo = null;
            this.validate();
        }
    }

    @Override
    public void run() {
        this.enableControls();
    }

    protected static final String shortClassName(String s) {
        return s.indexOf(46) != -1 ? s.substring(s.lastIndexOf(46) + 1) : s;
    }

    private void showAnalysisMenu() {
        this.jpopupmenu = new JPopupMenu("Analysis methods");
        String[] as = GMJ.parseClassList(analysisNames);
        int i = 0;
        while (i < as.length) {
            this.jpopupmenu.add(new AnalysisAction(as[i]));
            ++i;
        }
        if (this.task instanceof TaskWithAnalyzers) {
            try {
                Class[] aclass = ((TaskWithAnalyzers)this.task).analyzers();
                if (aclass != null) {
                    int j = 0;
                    while (j < aclass.length) {
                        this.jpopupmenu.add(new AnalysisAction(aclass[j].getName()));
                        ++j;
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.jpopupmenu.show(this.analysis, 0, this.analysis.getBounds().height);
    }

    @Override
    public void stop() {
        if (this.minimizer != null) {
            this.minimizer.stopMinimizer();
            try {
                this.minimizer.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.minimizer = null;
        }
        if (this.results != null) {
            this.results.dispose();
            this.results = null;
        }
        this.enableControls();
    }

    protected final class AnalysisAction
    extends AbstractAction {
        String className;

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            ResultAnalyzer resultanalyzer = null;
            try {
                resultanalyzer = (ResultAnalyzer)Class.forName(this.className).newInstance();
                resultanalyzer.prepare(GMJ.this.results);
            }
            catch (Throwable throwable) {
                if (resultanalyzer != null) {
                    resultanalyzer.dispose();
                }
                GMJ.this.enableControls();
                ErrorLog.defaultLog().log("Analysis could not be initialized", throwable);
            }
        }

        public AnalysisAction(String s) {
            this.className = s;
            this.putValue("Name", GMJ.shortClassName(s));
        }
    }
}

