/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.tasks;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Vector;
import lt.ktu.gmj.analysis.NonGuillotine;
import lt.ktu.gmj.tasks.BestFit;
import lt.ktu.gmj.tasks.Cut;
import lt.ktu.gmj.tasks.Figura;
import lt.ktu.gmj.tasks.Plokste;

public class TabuSearch
extends BestFit {
    int min_size;
    int max_size;
    int aspiration;
    int iterationsNr;
    NonGuillotine cAnalyser;
    ArrayList best_sol;
    long best_cost;
    long[][] tabu_list;
    public long cost;

    public TabuSearch(Cut cut, int i, int j, int k, int l, Vector vector) {
        this.m_pPatterns = new Vector();
        this.ct = cut;
        this.m_iLeft = i;
        this.m_iTop = j;
        this.m_iBottom = k;
        this.m_iRight = l;
        int ii = 0;
        while (ii < vector.size()) {
            Plokste pl = (Plokste)vector.elementAt(ii);
            Figura fig = new Figura(pl.m_iWidth, pl.m_iHeight, 1);
            this.shapeList.add(fig);
            ++ii;
        }
    }

    public TabuSearch(int mins, int maxs, int asp, int itNr, int i, int j, int k, int l, Vector vector, NonGuillotine ca) {
        if (vector.isEmpty()) {
            this.cAnalyser.lblStatus.setText("Error: no data found");
            this.cAnalyser.pnlMain.repaint();
            return;
        }
        this.cAnalyser = ca;
        this.min_size = mins;
        this.max_size = maxs;
        this.aspiration = asp;
        this.iterationsNr = itNr;
        this.m_pPatterns = new Vector();
        this.m_iLeft = i;
        this.m_iTop = j;
        this.m_iBottom = k;
        this.m_iRight = l;
        int ii = 0;
        while (ii < vector.size()) {
            Plokste pl = (Plokste)vector.elementAt(ii);
            Figura fig = new Figura(pl.m_iWidth, pl.m_iHeight, 1);
            this.shapeList.add(fig);
            ++ii;
        }
    }

    public TabuSearch(int mins, int maxs, int asp, int itNr, int i, int j, int k, int l, Vector vector) {
        this.min_size = mins;
        this.max_size = maxs;
        this.aspiration = asp;
        this.iterationsNr = itNr;
        this.m_pPatterns = new Vector();
        this.m_iLeft = i;
        this.m_iTop = j;
        this.m_iBottom = k;
        this.m_iRight = l;
        int ii = 0;
        while (ii < vector.size()) {
            Plokste pl = (Plokste)vector.elementAt(ii);
            Figura fig = new Figura(pl.m_iWidth, pl.m_iHeight, 1);
            this.shapeList.add(fig);
            ++ii;
        }
    }

    double rando() {
        long m = Integer.MAX_VALUE;
        long m2 = 2145483479L;
        long a12 = 63308L;
        long q12 = 33921L;
        long r12 = 12979L;
        long a13 = -183326L;
        long q13 = 11714L;
        long r13 = 2883L;
        long a21 = 86098L;
        long q21 = 24919L;
        long r21 = 7417L;
        long a23 = -539608L;
        long q23 = 3976L;
        long r23 = 2071L;
        double invm = 4.656612873077393E-10;
        long x10 = 12345L;
        long x11 = 67890L;
        long x12 = 13579L;
        long x20 = 24680L;
        long x21 = 98765L;
        long x22 = 43210L;
        long h = x10 / q13;
        long p13 = -a13 * (x10 - h * q13) - h * r13;
        h = x11 / q12;
        long p12 = a12 * (x11 - h * q12) - h * r12;
        if (p13 < 0L) {
            p13 += m;
        }
        if (p12 < 0L) {
            p12 += m;
        }
        x10 = x11;
        x11 = x12;
        x12 = p12 - p13;
        if (x12 < 0L) {
            x12 += m;
        }
        h = x20 / q23;
        long p23 = -a23 * (x20 - h * q23) - h * r23;
        h = x22 / q21;
        long p21 = a21 * (x22 - h * q21) - h * r21;
        if (p23 < 0L) {
            p23 += m2;
        }
        if (p21 < 0L) {
            p21 += m2;
        }
        x20 = x21;
        x21 = x22;
        x22 = p21 - p23;
        if (x22 < 0L) {
            x22 += m2;
        }
        if ((h = x12 < x22 ? x12 - x22 + m : x12 - x22) == 0L) {
            return 1.0;
        }
        return (double)h * invm;
    }

    int unif(int low, int high) {
        return low + (int)((double)(high - low + 1) * this.rando());
    }

    int min(long a, long b) {
        if (a < b) {
            return (int)a;
        }
        return (int)b;
    }

    long tabu_search(int n, int min_size, int max_size, long aspiration, long nr_iterations) {
        long infinite = 999999999L;
        long current_cost = 0L;
        long best_cost = 0L;
        long max_cost = 0L;
        long min_cost = 999999999L;
        ListIterator i_retained = null;
        ListIterator j_retained = null;
        boolean ok = true;
        long best_sol_improve = 999999999L;
        best_cost = 999999999L;
        this.tabu_list = new long[n + 1][n + 1];
        int i = 1;
        while (i <= n) {
            int j = 1;
            while (j <= n) {
                this.tabu_list[i][j] = -(n * i + j);
                ++j;
            }
            ++i;
        }
        ListIterator iter_i = this.shapeList.listIterator();
        ListIterator iter_j = this.shapeList.listIterator();
        while (iter_i.hasNext()) {
            iter_j = this.shapeList.listIterator();
            Figura fig_a = (Figura)iter_i.next();
            while (iter_j.hasNext()) {
                Figura fig_b = (Figura)iter_j.next();
                if (!fig_a.equal(fig_b)) continue;
                this.tabu_list[iter_i.previousIndex()][iter_j.previousIndex()] = 999999999L;
            }
        }
        iter_i = this.shapeList.listIterator();
        int current_iteration = 0;
        while ((long)current_iteration < nr_iterations) {
            i_retained = null;
            max_cost = -999999999L;
            min_cost = 999999999L;
            long sol_improve = 999999999L;
            boolean already_aspired = false;
            long curr_sol_improve = -999999999L;
            iter_j = this.shapeList.listIterator(iter_i.nextIndex());
            while (iter_j.hasNext()) {
                boolean aspired;
                this.swap(iter_i.nextIndex(), iter_j.nextIndex());
                this.resetFlags(ok);
                current_cost = this.sliceTemplateXY(ok, this.m_iBottom - this.m_iTop, this.m_iRight - this.m_iLeft);
                boolean autorized = this.tabu_list[iter_i.nextIndex()][iter_j.nextIndex()] < (long)current_iteration || this.tabu_list[iter_j.nextIndex()][iter_i.nextIndex()] < (long)current_iteration;
                boolean bl = aspired = best_cost > current_cost;
                if (aspired && !already_aspired || aspired && already_aspired && current_cost < min_cost) {
                    i_retained = this.shapeList.listIterator(iter_i.nextIndex());
                    j_retained = this.shapeList.listIterator(iter_j.nextIndex());
                    min_cost = current_cost;
                    already_aspired = true;
                } else if (!aspired && !already_aspired && autorized && current_cost <= best_cost) {
                    i_retained = this.shapeList.listIterator(iter_i.nextIndex());
                    j_retained = this.shapeList.listIterator(iter_j.nextIndex());
                }
                if (i_retained == null) {
                    this.swap(iter_i.nextIndex(), iter_j.nextIndex());
                } else {
                    if (min_cost != 999999999L) {
                        current_cost = min_cost;
                    }
                    this.tabu_list[i_retained.nextIndex()][j_retained.nextIndex()] = current_iteration + this.unif(min_size, max_size);
                    this.tabu_list[j_retained.nextIndex()][i_retained.nextIndex()] = current_iteration + this.unif(min_size, max_size);
                    if (current_cost < best_cost) {
                        best_cost = current_cost;
                    } else {
                        this.swap(iter_i.nextIndex(), iter_j.nextIndex());
                    }
                }
                iter_j.next();
            }
            iter_i.next();
            ++current_iteration;
        }
        return best_cost;
    }

    public long cut() {
        this.expandShapeList();
        this.sortShapes();
        long cost = 0L;
        cost = this.tabu_search(this.shapeList.size(), this.min_size, this.max_size, this.aspiration, this.iterationsNr);
        return cost;
    }

    @Override
    public void run() {
        this.expandShapeList();
        this.sortShapes();
        this.cost = this.tabu_search(this.shapeList.size(), this.min_size, this.max_size, this.aspiration, this.iterationsNr);
        ListIterator iter = this.shapeList.listIterator();
        int i = 0;
        while (iter.hasNext()) {
            Figura fig = (Figura)iter.next();
            Plokste pl = new Plokste(fig.getX(), fig.getY(), fig.getLength(), fig.getWidth(), i, !fig.getFlag());
            this.m_pPatterns.add(pl);
        }
        this.cAnalyser.lblStatus.setText("Waist " + this.cost);
        this.cAnalyser.pnlMain.setValues(this.m_iLeft, this.m_iTop, this.m_iBottom, this.m_iRight, this.m_pPatterns);
        this.cAnalyser.pnlMain.repaint();
    }
}

