/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import lt.ktu.gmj.tasks.Cut;
import lt.ktu.gmj.tasks.Figura;
import lt.ktu.gmj.tasks.Plokste;
import lt.ktu.gmj.tasks.Skyline;
import lt.ktu.gmj.tasks.SortByLength;

public class BestFit
extends Thread {
    double cost;
    ArrayList<Figura> shapeList = new ArrayList();
    ArrayList<Skyline> skyline = new ArrayList();
    ArrayList tmplList;
    ArrayList stockList;
    Vector<Plokste> m_pPatterns;
    Cut ct;
    int m_iLeft;
    int m_iTop;
    int m_iBottom;
    int m_iRight;

    void openShapeList() {
        try {
            String eilute;
            File pFile = new File("duomenys.txt");
            BufferedReader ds = new BufferedReader(new FileReader(pFile));
            while ((eilute = ds.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(eilute);
                Figura fig = new Figura();
                if (st.hasMoreTokens()) {
                    fig.setCount(Integer.parseInt(st.nextToken()));
                }
                if (st.hasMoreTokens()) {
                    fig.setLength(Integer.parseInt(st.nextToken()));
                }
                if (st.hasMoreTokens()) {
                    fig.setWidth(Integer.parseInt(st.nextToken()));
                }
                if (st.hasMoreTokens()) {
                    fig.setId(st.nextToken());
                }
                fig.setFlag(true);
                this.shapeList.add(fig);
            }
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (IOException e) {
                    System.out.println("Klaida uzdarant faila");
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Nerastas duomenu failas");
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println("Klaida atidarant duomenu faila");
            System.exit(0);
        }
    }

    void outputShapeList() {
        try {
            File pFile = new File("rezultatai.txt");
            PrintWriter rs = new PrintWriter(new FileWriter(pFile));
            ListIterator<Figura> iter = this.shapeList.listIterator();
            while (iter.hasNext()) {
                Figura fig = iter.next();
                rs.println(String.valueOf(fig.getCount()) + " " + fig.getLength() + " " + fig.getWidth() + " " + fig.getId());
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (IOException e) {
            System.out.println("Klaida atidarant duomenu faila");
            System.exit(0);
        }
    }

    void resetFlags(boolean ok) {
        ListIterator<Figura> iter = this.shapeList.listIterator();
        while (iter.hasNext()) {
            iter.next().setFlag(ok);
        }
    }

    void swap(int firstInd, int secondInd) {
        Figura temp = this.shapeList.set(firstInd, this.shapeList.get(secondInd));
        this.shapeList.set(secondInd, temp);
    }

    void sortShapes() {
        ListIterator<Figura> iter = this.shapeList.listIterator();
        while (iter.hasNext()) {
            Figura fig = iter.next();
            if (fig.getWidth() <= fig.getLength()) continue;
            int temp = fig.getWidth();
            fig.setWidth(fig.getLength());
            fig.setLength(temp);
            iter.set(fig);
        }
        SortByLength sortByLength = new SortByLength();
        Collections.sort(this.shapeList, sortByLength);
    }

    void expandShapeList() {
        int count = 0;
        ListIterator<Figura> iter = this.shapeList.listIterator();
        while (iter.hasNext()) {
            Figura fig = iter.next();
            if (fig.getCount() <= 1) continue;
            count = fig.getCount();
            fig.setCount(1);
            iter.set(fig);
            int i = 1;
            while (i < count) {
                iter.add(fig);
                ++i;
            }
        }
    }

    void contractShapeList() {
        ListIterator<Figura> iter = this.shapeList.listIterator();
        Figura fig1 = iter.next();
        while (iter.hasNext()) {
            Figura fig2 = new Figura(iter.next());
            if (fig1.getLength() == fig2.getLength() && fig1.getWidth() == fig2.getWidth()) {
                fig2.setCount(fig1.getCount() + fig2.getCount());
                iter.set(fig2);
                iter.previous();
                iter.previous();
                iter.remove();
                iter.next();
            }
            fig1 = new Figura(fig2);
        }
    }

    void enumerateShapeList() {
        ListIterator<Figura> iter = this.shapeList.listIterator();
        int temp = 1;
        while (iter.hasNext()) {
            Figura fig = new Figura(iter.next());
            fig.setNr(++temp);
            iter.set(fig);
        }
    }

    void eraseShape(int at) {
        if (this.shapeList.get(at).getCount() > 1) {
            this.shapeList.get(at).setCount(this.shapeList.get(at).getCount() - 1);
        } else {
            this.shapeList.remove(at);
        }
    }

    int getShapeListSize() {
        return this.shapeList.size();
    }

    int lowestHole() {
        ListIterator<Skyline> iter = this.skyline.listIterator();
        int min = 9999;
        int min_at = 0;
        while (iter.hasNext()) {
            Skyline cell = iter.next();
            if (cell.x >= min) continue;
            min = cell.x;
            min_at = iter.previousIndex();
        }
        return min_at;
    }

    void fillHole(int x0_at, int tmplLength, int tmplWidth) {
        int infinite;
        int left = infinite = 99999;
        int right = infinite;
        Skyline cell = this.skyline.get(x0_at);
        Skyline cell_rigth = null;
        Skyline cell_left = null;
        if (x0_at == 0) {
            left = tmplWidth;
        } else {
            cell_left = this.skyline.get(x0_at - 1);
        }
        if (cell.to == tmplLength) {
            right = tmplWidth;
        } else {
            cell_rigth = this.skyline.get(x0_at + 1);
        }
        if (right != infinite && left == infinite) {
            cell_left.to = cell.to;
            cell_left.count = cell_left.to - cell_left.from;
            this.skyline.set(x0_at - 1, cell_left);
            this.skyline.remove(x0_at);
        } else if (right == infinite && left != infinite) {
            cell_rigth.from = 0;
            cell_rigth.count = cell_rigth.to - cell_rigth.from;
            this.skyline.set(x0_at + 1, cell_rigth);
            this.skyline.remove(x0_at);
        } else if (right != infinite && left != infinite) {
            cell.x = tmplWidth;
            this.skyline.set(x0_at, cell);
        } else if (cell_rigth.x > cell_left.x) {
            cell_left.to = cell.to;
            cell_left.count = cell_left.to - cell_left.from;
            this.skyline.set(x0_at - 1, cell_left);
            this.skyline.remove(x0_at);
        } else if (cell_rigth.x < cell_left.x) {
            cell_rigth.from = cell.from;
            cell_rigth.count = cell_rigth.to - cell_rigth.from;
            this.skyline.set(x0_at + 1, cell_rigth);
            this.skyline.remove(x0_at);
        } else if (cell_rigth.x == cell_left.x) {
            cell_left.to = cell_rigth.to;
            cell_left.count = cell_left.to - cell_left.from;
            this.skyline.set(x0_at - 1, cell_left);
            this.skyline.remove(x0_at + 1);
            this.skyline.remove(x0_at);
        }
    }

    boolean fitShapeUnsortedRotate(int[] result, int cell_at, int tmplWidth, boolean ok) {
        ListIterator<Figura> iter = this.shapeList.listIterator();
        while (iter.hasNext()) {
            Figura fig = iter.next();
            if (fig.getFlag() == ok && fig.getLength() <= this.skyline.get((int)cell_at).count && tmplWidth - this.skyline.get((int)cell_at).x >= fig.getWidth()) {
                fig.setFlag(!ok);
                iter.set(fig);
                result[0] = iter.previousIndex();
                result[1] = 0;
                return true;
            }
            if (fig.getFlag() != ok || fig.getWidth() > this.skyline.get((int)cell_at).count || tmplWidth - this.skyline.get((int)cell_at).x < fig.getLength()) continue;
            fig.setFlag(!ok);
            iter.set(fig);
            result[0] = iter.previousIndex();
            result[1] = 1;
            return true;
        }
        return false;
    }

    void testHole() {
        Skyline cell = new Skyline();
        cell.count = 5;
        cell.from = 0;
        cell.to = 5;
        cell.x = 10;
        this.skyline.add(cell);
        cell = new Skyline();
        cell.count = 4;
        cell.from = 5;
        cell.to = 9;
        cell.x = 11;
        this.skyline.add(cell);
        cell = new Skyline();
        cell.count = 6;
        cell.from = 9;
        cell.to = 15;
        cell.x = 20;
        this.skyline.add(cell);
        cell = new Skyline();
        cell.count = 4;
        cell.from = 15;
        cell.to = 19;
        cell.x = 25;
        this.skyline.add(cell);
        cell = new Skyline();
        cell.count = 5;
        cell.from = 19;
        cell.to = 24;
        cell.x = 15;
        this.skyline.add(cell);
        ListIterator<Skyline> iter = this.skyline.listIterator();
        while (iter.hasNext()) {
            cell = iter.next();
            System.out.println("x: " + cell.x + " from: " + cell.from + " to: " + cell.to + " count: " + cell.count);
        }
        int min = this.lowestHole();
        System.out.println("minimumas = " + min + " x: " + this.skyline.get((int)min).x + " from: " + this.skyline.get((int)min).from + " to: " + this.skyline.get((int)min).to);
        this.placeShape(2, 1, 0);
        iter = this.skyline.listIterator();
        while (iter.hasNext()) {
            cell = iter.next();
            System.out.println("x: " + cell.x + " from: " + cell.from + " to: " + cell.to + " count: " + cell.count);
        }
        Figura fig = new Figura();
        fig.setWidth(5);
        fig.setLength(14);
        fig.setCount(1);
        this.shapeList.add(fig);
        fig = new Figura();
        fig.setWidth(10);
        fig.setLength(10);
        fig.setCount(1);
        this.shapeList.add(fig);
        fig = new Figura();
        fig.setWidth(1);
        fig.setLength(1);
        fig.setCount(1);
        this.shapeList.add(fig);
        System.out.println("---------------------------------");
    }

    void placeShape(int length, int width, int cell_at) {
        if (length == this.skyline.get((int)cell_at).count) {
            Skyline cell = this.skyline.get(cell_at);
            cell.x += width;
            if (cell_at != 0 && this.skyline.get((int)(cell_at - 1)).x == this.skyline.get((int)cell_at).x) {
                cell.from = this.skyline.get((int)(cell_at - 1)).from;
                cell.count = cell.to - cell.from;
                this.skyline.remove(cell_at - 1);
                --cell_at;
            }
            if (cell_at != this.skyline.size() - 1 && this.skyline.get((int)(cell_at + 1)).x == this.skyline.get((int)cell_at).x) {
                cell.to = this.skyline.get((int)(cell_at + 1)).to;
                cell.count = cell.to - cell.from;
                this.skyline.remove(cell_at + 1);
            }
            this.skyline.set(cell_at, cell);
        } else if (length < this.skyline.get((int)cell_at).count) {
            Skyline newCell = new Skyline();
            Skyline cell = this.skyline.get(cell_at);
            cell.count -= length;
            newCell.from = cell.from;
            cell.from += length;
            newCell.to = cell.from;
            newCell.count = length;
            newCell.x = cell.x + width;
            this.skyline.set(cell_at, cell);
            if (cell_at == 0) {
                this.skyline.add(0, newCell);
            } else if (this.skyline.get((int)(cell_at - 1)).x == newCell.x) {
                cell = this.skyline.get(cell_at - 1);
                cell.to += length;
                cell.count += length;
                this.skyline.set(cell_at - 1, cell);
            } else {
                this.skyline.add(cell_at, newCell);
            }
        } else {
            System.out.println("klaida - cia neturim niekada patekti!");
            System.exit(0);
        }
    }

    long sliceTemplate(boolean ok, int tmplWidth, int tmplLength) {
        long cost = 0L;
        int lh = 0;
        int[] res = new int[3];
        Skyline cell = new Skyline();
        cell.count = tmplLength;
        cell.from = 0;
        cell.to = tmplLength;
        cell.x = 0;
        this.skyline.clear();
        this.skyline.add(cell);
        while (this.skyline.get((int)0).x != tmplWidth || this.skyline.get((int)0).count != tmplLength) {
            lh = this.lowestHole();
            if (this.fitShapeUnsortedRotate(res, lh, tmplWidth, ok)) {
                if (res[1] == 1) {
                    this.placeShape(this.shapeList.get(res[0]).getWidth(), this.shapeList.get(res[0]).getLength(), lh);
                } else {
                    this.placeShape(this.shapeList.get(res[0]).getLength(), this.shapeList.get(res[0]).getWidth(), lh);
                }
                cost += (long)(this.shapeList.get(res[0]).getWidth() * this.shapeList.get(res[0]).getLength());
                continue;
            }
            this.fillHole(lh, tmplLength, tmplWidth);
        }
        cost = (long)(tmplWidth * tmplLength) - cost;
        return cost;
    }

    long sliceTemplateXY(boolean ok, int tmplWidth, int tmplLength) {
        int w = 0;
        long cost = 0L;
        int lh = 0;
        int[] res = new int[3];
        Figura fig = null;
        Skyline cell = new Skyline();
        cell.count = tmplLength;
        cell.from = 0;
        cell.to = tmplLength;
        cell.x = 0;
        this.skyline.clear();
        this.skyline.add(cell);
        while (this.skyline.get((int)0).x != tmplWidth || this.skyline.get((int)0).count != tmplLength) {
            lh = this.lowestHole();
            if (this.fitShapeUnsortedRotate(res, lh, tmplWidth, ok)) {
                if (res[1] == 1) {
                    fig = this.shapeList.get(res[0]);
                    fig.setX(this.skyline.get((int)lh).from);
                    fig.setY(this.skyline.get((int)lh).x);
                    w = fig.getWidth();
                    fig.setWidth(fig.getLength());
                    fig.setLength(w);
                    this.shapeList.set(res[0], fig);
                    this.placeShape(this.shapeList.get(res[0]).getLength(), this.shapeList.get(res[0]).getWidth(), lh);
                } else {
                    fig = this.shapeList.get(res[0]);
                    fig.setX(this.skyline.get((int)lh).from);
                    fig.setY(this.skyline.get((int)lh).x);
                    this.placeShape(this.shapeList.get(res[0]).getLength(), this.shapeList.get(res[0]).getWidth(), lh);
                    this.shapeList.set(res[0], fig);
                }
                cost += (long)(this.shapeList.get(res[0]).getWidth() * this.shapeList.get(res[0]).getLength());
                continue;
            }
            this.fillHole(lh, tmplLength, tmplWidth);
        }
        cost = (long)(tmplWidth * tmplLength) - cost;
        return cost;
    }

    @Override
    public void run() {
        this.expandShapeList();
        this.sortShapes();
        System.out.println("m_iTop = " + this.m_iTop + " m_iBottom = " + this.m_iBottom + " m_iLeft = " + this.m_iLeft + " m_iRight = " + this.m_iRight);
        long cost = this.sliceTemplateXY(true, this.m_iBottom - this.m_iTop, this.m_iRight - this.m_iLeft);
        ListIterator<Figura> iter = this.shapeList.listIterator();
        int i = 0;
        while (iter.hasNext()) {
            Figura fig = iter.next();
            Plokste pl = new Plokste(fig.getX(), fig.getY(), fig.getLength(), fig.getWidth(), i, !fig.getFlag());
            this.m_pPatterns.add(pl);
        }
        this.ct.pnlMain.setValues(this.m_iLeft, this.m_iTop, this.m_iBottom, this.m_iRight, this.m_pPatterns);
        this.ct.pnlMain.repaint();
        System.out.println(cost);
    }

    public BestFit(Cut cut, int i, int j, int k, int l, Vector vector) {
        this.m_pPatterns = new Vector();
        this.ct = cut;
        this.m_iLeft = i;
        this.m_iTop = j;
        this.m_iBottom = k;
        this.m_iRight = l;
        int ii = 0;
        while (ii < vector.size()) {
            Plokste pl = (Plokste)vector.elementAt(ii);
            Figura fig = new Figura(pl.m_iWidth, pl.m_iHeight, 1);
            this.shapeList.add(fig);
            ++ii;
        }
    }

    public BestFit() {
    }
}

