/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.propertySheet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import lt.ktu.gmj.propertySheet.InvalidPropertyException;
import lt.ktu.gmj.propertySheet.PropertyProvider;
import lt.ktu.gmj.propertySheet.PropertyStringer;
import lt.ktu.gmj.propertySheet.StringablePropertyEditor;

public class UrlEditor
extends StringablePropertyEditor
implements PropertyStringer {
    private PropertyProvider provider;

    public UrlEditor(PropertyProvider _provider) {
        this.provider = _provider;
        this.provider.addObserver(this);
        this.setStringer(this);
    }

    @Override
    public String getAsString() {
        return this.provider.get().toString();
    }

    @Override
    public void setAsString(String text) throws InvalidPropertyException {
        try {
            URL myurl = new URL(text);
            System.out.println("Will read data from: " + myurl.getHost() + myurl.getFile());
            URLConnection mycon = myurl.openConnection();
            System.out.println("Data type will be: " + mycon.getContentType() + " and size: " + mycon.getContentLength());
            if (mycon.getContentLength() <= 0) {
                throw new InvalidPropertyException("!!!-Bad data file...");
            }
            this.provider.set(text);
        }
        catch (MalformedURLException e) {
            System.out.println("!!!-Bad URL: " + e);
        }
        catch (IOException e) {
            System.out.println("!!!-Bad Connection: " + e);
        }
    }
}

