/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.methods;

import lt.ktu.gmj.Domain;
import lt.ktu.gmj.Point;
import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultLogger;
import lt.ktu.gmj.Task;
import lt.ktu.gmj.methods.IPMethodBase;
import lt.ktu.gmj.methods.LPPoint;
import lt.ktu.gmj.methods.RandomPoint;

public class Bayes
extends IPMethodBase {
    private static final int NOT_SEC_POINT = 0;
    private static final int SEC_POINT = 1;
    private static final int PAR1 = 10;
    private static final int PAR2 = 50;
    private static final double VAL = 1.0E-6;
    private static final double COEF = 1.0E-14;
    private static final double RMAX = 8.988465674311579E307;
    private Point x2;
    private Point mz;
    private int ix;

    public Bayes() {
        this.iterations = 100;
        this.initialPoints = 5;
    }

    private double fiap1(Point point, ResultLogger resultlogger, double d, Result result, int i) {
        double d1 = resultlogger.logAt((int)0).value;
        double d2 = result.value;
        double d3 = d2 - Math.max(1.0E-6, 1.0E-14 * Math.abs(d2));
        double d4 = Math.min(8.988465674311579E307, 8.988465674311579E307 / (d1 - d3));
        int j = 0;
        while (j < i) {
            double d7;
            Result result1 = resultlogger.logAt(j);
            double d5 = point.distance(result1.point);
            double d6 = d5 * d5;
            if (d6 < Math.min(8.988465674311579E307, (d7 = result1.value - d3) * d4) && (d4 = d6 / d7) <= -d) {
                return -d4;
            }
            ++j;
        }
        return -d4;
    }

    private Point mig2f2(ResultLogger resultlogger, Task task, Result result, int i) {
        Point point = null;
        Domain domain = task.domain();
        int j = Math.min(50, Math.max(10, i)) * domain.dimensions().length;
        double d = 0.0;
        double d1 = 0.0;
        if (this.ix == 0) {
            this.x2 = new RandomPoint(domain);
            --j;
            this.ix = 1;
        }
        double d2 = this.fiap1(this.x2, resultlogger, d, result, i);
        int k = 0;
        while (k < j) {
            this.mz = new RandomPoint(domain);
            double d3 = this.fiap1(this.mz, resultlogger, d, result, i);
            if (k == 0) {
                if (d3 >= d2) {
                    point = this.x2;
                    this.x2 = this.mz;
                    d1 = d2;
                    d = d2 = d3;
                } else {
                    point = this.mz;
                    d1 = d3;
                    d = d2;
                }
            } else if (d3 < d2) {
                if (d3 < d1) {
                    this.x2 = point;
                    point = this.mz;
                    d = d2 = d1;
                    d1 = d3;
                } else {
                    this.x2 = this.mz;
                    d = d2 = d3;
                }
            }
            ++k;
        }
        return point;
    }

    @Override
    public Result run(ResultLogger resultlogger, Task task) {
        Domain domain = task.domain();
        Result result = new Result();
        this.ix = 0;
        int i = 0;
        while (i < this.initialPoints) {
            LPPoint lppoint = new LPPoint(domain, i);
            Result result1 = new Result(i, lppoint, task.f(lppoint));
            resultlogger.log(result1);
            if (result1.value < result.value) {
                result = result1;
            }
            ++i;
        }
        int j = this.initialPoints;
        while (j < this.iterations) {
            Point point = this.mig2f2(resultlogger, task, result, j);
            Result result2 = new Result(j, point, task.f(point));
            resultlogger.log(result2);
            if (result2.value < result.value) {
                result = result2;
            }
            ++j;
        }
        return result;
    }
}

