/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.analysis;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultRepository;
import lt.ktu.gmj.analysis.ResultFrame;
import lt.monarch.chart.ChartObject;
import lt.monarch.chart.Grid;
import lt.monarch.chart.MathAxisMapper;
import lt.monarch.chart.chart2D.AbstractChartPointProvider;
import lt.monarch.chart.chart2D.Axis2DX;
import lt.monarch.chart.chart2D.Axis2DY;
import lt.monarch.chart.chart2D.Chart2D;
import lt.monarch.chart.chart2D.ChartPoint;
import lt.monarch.chart.chart2D.ChartPointSeries;
import lt.monarch.chart.chart2D.Dot;
import lt.monarch.chart.chart2D.DotSeries;
import lt.monarch.swing.JChartPanel;

public class Projection
extends ResultFrame {
    protected Chart2D chart = new Chart2D();
    protected int projection = 0;
    protected ChartPointSeries series = null;
    protected JComboBox projectionChoice;
    private Provider provider;

    protected synchronized void setupChart() {
        this.provider = new Provider();
        MathAxisMapper mathaxismapper = new MathAxisMapper();
        MathAxisMapper mathaxismapper1 = new MathAxisMapper();
        Axis2DX axis2dx = new Axis2DX(mathaxismapper1);
        Axis2DY axis2dy = new Axis2DY(mathaxismapper);
        this.series = new DotSeries(this.provider, axis2dx, axis2dy);
        Grid grid = new Grid(axis2dx, axis2dy);
        axis2dy.setLabel("f(x)");
        axis2dx.setLabel(this.results.task().domain().dimensions()[this.projection]);
        mathaxismapper.range.setRange(this.results.minValue(), this.results.maxValue());
        mathaxismapper1.range.setRange(this.results.task().domain().min[this.projection], this.results.task().domain().max[this.projection]);
        this.chart.reset();
        this.chart.setLAxis(axis2dy);
        this.chart.setXAxis(axis2dx);
        this.chart.setObjects(new ChartObject[]{grid, axis2dx, axis2dy, this.series});
        this.chart.invalidate();
    }

    @Override
    public synchronized void prepare(ResultRepository resultrepository) {
        super.prepare(resultrepository);
        String[] as = resultrepository.task().domain().dimensions();
        int i = 0;
        while (i < as.length) {
            this.projectionChoice.addItem(as[i]);
            ++i;
        }
        this.setupChart();
        this.show();
        resultrepository.addObserver(this);
    }

    @Override
    public synchronized void newResult(ResultRepository resultrepository) {
        this.provider.newResult(resultrepository.lastResult());
    }

    @Override
    public void newProgressResult(ResultRepository resultrepository) {
    }

    @Override
    public void finalResult(ResultRepository resultrepository) {
    }

    @Override
    public synchronized void logStarted(ResultRepository resultrepository) {
        this.setupChart();
    }

    public Projection() {
        super("Projection");
        this.getContentPane().add("Center", new JChartPanel(this.chart));
        this.projectionChoice = new JComboBox();
        this.getContentPane().add("South", this.projectionChoice);
        this.projectionChoice.addItemListener(new _cls1());
    }

    class Provider
    extends AbstractChartPointProvider {
        ChartPoint[] dotCache = new ChartPoint[500];

        @Override
        public int pointCount() {
            int i = Projection.this.results.resultCount();
            return i <= 500 ? i : 500;
        }

        @Override
        public ChartPoint point(int i) {
            int j = i;
            int k = Projection.this.results.resultCount();
            if (k > 500) {
                j = j * k / 500;
            }
            if (this.dotCache[i] == null) {
                this.dotCache[i] = this.pointFromResult(Projection.this.results.resultAt(j));
            }
            return this.dotCache[i];
        }

        public void newResult(Result result) {
            int i = Projection.this.results.resultCount();
            if (i < 500 || i % 50 == 0) {
                ChartPoint chartpoint = this.pointFromResult(result);
                if (chartpoint.registerOn(Projection.this.series)) {
                    this.firePointsChanged();
                }
                this.dotCache[(int)(Math.random() * 500.0)] = chartpoint;
                this.firePointAdded(chartpoint);
            }
        }

        protected ChartPoint pointFromResult(Result result) {
            _cls2 _lcls2 = new _cls2(new Double(result.point.x[Projection.this.projection]), new Double(result.value));
            return _lcls2;
        }

        Provider() {
        }

        private class _cls2
        extends Dot {
            @Override
            public String tip(ChartPointSeries chartpointseries) {
                return " (" + chartpointseries.xMapper.formatKey(this.xValue()) + ", " + chartpointseries.yMapper.formatKey(this.yValue()) + ") ";
            }

            public void constructor$0(Provider provider1, Object obj, Object obj1) {
            }

            public _cls2(Object obj, Object obj1) {
                super(obj, obj1);
                this.constructor$0(Provider.this, obj, obj1);
            }
        }
    }

    private class _cls1
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemevent) {
            Projection.this.projection = Projection.this.projectionChoice.getSelectedIndex();
            Projection.this.setupChart();
        }

        public void constructor$0(Projection projection1) {
        }

        public _cls1() {
            this.constructor$0(Projection.this);
        }
    }
}

