/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.analysis;

import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultRepository;
import lt.ktu.gmj.analysis.ResultFrame;
import lt.monarch.chart.ChartObject;
import lt.monarch.chart.Grid;
import lt.monarch.chart.MathAxisMapper;
import lt.monarch.chart.chart2D.AbstractChartPointProvider;
import lt.monarch.chart.chart2D.Axis2DX;
import lt.monarch.chart.chart2D.Axis2DY;
import lt.monarch.chart.chart2D.Chart2D;
import lt.monarch.chart.chart2D.ChartPoint;
import lt.monarch.chart.chart2D.ConnectedSeries;
import lt.monarch.chart.chart2D.InvisibleDot;
import lt.monarch.swing.JChartPanel;

public class Convergence
extends ResultFrame {
    protected Chart2D chart = new Chart2D();
    protected ConnectedSeries series;
    protected Provider provider;

    public Convergence() {
        super("Convergence");
        this.getContentPane().add("Center", new JChartPanel(this.chart));
    }

    @Override
    public void finalResult(ResultRepository resultrepository) {
        this.newProgressResult(resultrepository);
    }

    @Override
    public void newProgressResult(ResultRepository resultrepository) {
        this.provider.newResult(resultrepository.lastResult());
    }

    @Override
    public void newResult(ResultRepository resultrepository) {
    }

    @Override
    public void prepare(ResultRepository resultrepository) {
        super.prepare(resultrepository);
        this.setupChart();
        this.show();
        resultrepository.addObserver(this);
    }

    protected void setupChart() {
        this.provider = new Provider();
        MathAxisMapper mathaxismapper = new MathAxisMapper();
        MathAxisMapper mathaxismapper1 = new MathAxisMapper();
        Axis2DX axis2dx = new Axis2DX(mathaxismapper1);
        Axis2DY axis2dy = new Axis2DY(mathaxismapper);
        this.series = new ConnectedSeries(this.provider, axis2dx, axis2dy);
        Grid grid = new Grid(axis2dx, axis2dy);
        axis2dy.setLabel("f(x)");
        axis2dx.setLabel("Iteration");
        mathaxismapper.range.setRange(this.results.minValue(), this.results.maxValue());
        mathaxismapper1.range.setRange(0.0, this.results.method().iterations());
        this.chart.reset();
        this.chart.setLAxis(axis2dy);
        this.chart.setXAxis(axis2dx);
        this.chart.setObjects(new ChartObject[]{grid, axis2dx, axis2dy, this.series});
        this.chart.invalidate();
    }

    class Provider
    extends AbstractChartPointProvider {
        public void newResult(Result result) {
            ChartPoint chartpoint = this.pointFromResult(result);
            if (chartpoint.registerOn(Convergence.this.series)) {
                this.firePointsChanged();
            }
            this.firePointAdded(chartpoint);
        }

        @Override
        public ChartPoint point(int i) {
            return i == 0 ? new InvisibleDot(new Double(0.0), new Double(Convergence.this.results.maxValue())) : this.pointFromResult(Convergence.this.results.progressResultAt(i - 1));
        }

        @Override
        public int pointCount() {
            return Convergence.this.results.progressResultCount() + 1;
        }

        protected ChartPoint pointFromResult(Result result) {
            InvisibleDot invisibledot = new InvisibleDot(new Double(result.iteration), new Double(result.value));
            return invisibledot;
        }

        Provider() {
        }
    }
}

