/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj;

import lt.ktu.gmj.Customizable;
import lt.ktu.gmj.Point;
import lt.ktu.gmj.propertySheet.DoubleArrayProvider;
import lt.ktu.gmj.propertySheet.DoubleRangeProperty;
import lt.ktu.gmj.propertySheet.Header;
import lt.ktu.gmj.propertySheet.PropertyManager;

public abstract class Domain
implements Customizable {
    public double[] min = new double[this.dimensions().length];
    public double[] max = new double[this.dimensions().length];
    public Point defaultPoint = new Point(this);

    public abstract String[] dimensions();

    @Override
    public void customize(PropertyManager propertyManager) {
        String[] stringArray = new String[]{"Min", "Default", "Max"};
        propertyManager.add(new Header("Dimension", stringArray));
        for (int i = 0; i < this.dimensions().length; ++i) {
            propertyManager.add(new DoubleRangeProperty(this.dimensions()[i] + " (x" + (i + 1) + ")", new DoubleArrayProvider(this.min, i), new DoubleArrayProvider(this.defaultPoint.x, i), new DoubleArrayProvider(this.max, i)));
        }
    }

    public double constraintAt(int n, Point point) {
        return 1.0;
    }

    public final void normalizePoint(Point point) {
        for (int i = 0; i < point.x.length; ++i) {
            point.x[i] = point.x[i] * (this.max[i] - this.min[i]) + this.min[i];
        }
    }
}

