/*
 * Decompiled with CFR 0.152.
 */
package com.plugin;

import com.pkc.settings.Settings;
import com.plugin.Parameter;
import com.plugin.Plugin;
import java.applet.Applet;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import plugins.GUI.GUI;
import plugins.GenByCutting.GenByCutting;
import plugins.ManualDataEntry.ManualDataEntry;

public class PluginManager
extends Applet {
    public static final String PARAM_PREFIX = "-";
    private static Map parameters = new HashMap();

    public PluginManager(int byDimmension_, int byVolume_, int byRatio_, int byMinMax_, int byRandom_) {
        Settings.byDimmension = byDimmension_;
        Settings.byVolume = byVolume_;
        Settings.byRatio = byRatio_;
        Settings.byMinMax = byMinMax_;
        Settings.byRandom = byRandom_;
    }

    public static void registerParam(Parameter param) {
        parameters.put(param.getName(), param);
    }

    @Override
    public void start() {
        new GenByCutting().run();
        new ManualDataEntry().run();
        new GUI().run();
    }

    public static void main(String[] args) {
        try {
            ArrayList<PluginEntry> plugins = new ArrayList<PluginEntry>();
            File[] files = new File("plugins").listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    try {
                        Properties pluginProperties = new Properties();
                        File file = new File(String.valueOf(files[i].getAbsolutePath()) + File.separator + "plugin.properties");
                        if (file.exists()) {
                            FileInputStream fileInputStream = new FileInputStream(file);
                            pluginProperties.load(fileInputStream);
                            fileInputStream.close();
                            String className = pluginProperties.getProperty("main");
                            Class<?> pluginClass = Class.forName(className);
                            Object object = pluginClass.newInstance();
                            if (object instanceof Plugin) {
                                plugins.add(new PluginEntry((Plugin)object, Integer.parseInt(pluginProperties.getProperty("priority"))));
                            }
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Exception occured while loading plugins: " + e);
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            i = 0;
            while (i < args.length) {
                String param = args[i];
                if (!param.startsWith(PARAM_PREFIX)) {
                    throw new Exception("Invalid option '" + param + "'.\nOption must start with '" + PARAM_PREFIX + "'.");
                }
                if ((param = param.substring(PARAM_PREFIX.length())).equals("help")) {
                    PluginManager.printHelpScreen(parameters, System.out);
                    throw new Exception("");
                }
                Parameter parameter = (Parameter)parameters.get(param);
                if (parameter != null) {
                    if (args.length - ++i < parameter.getArgCount()) {
                        throw new Exception("Not enougth arguments for option '" + param + "'");
                    }
                    int k = 0;
                    while (k < parameter.getArgCount()) {
                        parameter.setArg(args[i], k);
                        ++k;
                        ++i;
                    }
                    parameter.process();
                    continue;
                }
                throw new Exception("Unknown option '-" + param + "'.\nUse option '-help' to see all available options.");
            }
            Collections.sort(plugins);
            while (plugins.size() > 0) {
                ((PluginEntry)plugins.remove(0)).getPlugin().run();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void printHelpScreen(Map parameters, PrintStream output) {
        output.println("Packer v0.04");
        output.println("USAGE: java " + PluginManager.class.getName() + " [options...]");
        output.println("Available options:");
        Iterator params = parameters.keySet().iterator();
        while (params.hasNext()) {
            Parameter parameter = (Parameter)parameters.get(params.next());
            output.print("\t-" + parameter.getName());
            int i = 0;
            while (i < parameter.getArgCount()) {
                output.print(" " + parameter.getArgName(i));
                ++i;
            }
            output.println("\n\t\t" + parameter.getDescription());
        }
    }

    private static class PluginEntry
    implements Comparable {
        Plugin plugin;
        int priority;

        public PluginEntry(Plugin plugin, int priority) {
            this.plugin = plugin;
            this.priority = priority;
        }

        public int compareTo(Object o) {
            int priority = ((PluginEntry)o).priority;
            return this.priority < priority ? 1 : (this.priority > priority ? -1 : 0);
        }

        public Plugin getPlugin() {
            return this.plugin;
        }
    }
}

