/*
 * Decompiled with CFR 0.152.
 */
package com.pkc.ui.dialogs;

import com.pkc.settings.Settings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class SettingsDialog
extends JDialog
implements ActionListener {
    Locale[] locales = Locale.getAvailableLocales();
    JRadioButton limitPackTimeRadioButton = new JRadioButton("after");
    JSpinner limitPackTimeSpinner = new JSpinner(new SpinnerNumberModel(Settings.stopTime, 1, 864000, 1));
    JRadioButton limitPackIterationsRadioButton = new JRadioButton("after");
    JSpinner limitPackIterationsSpinner = new JSpinner(new SpinnerNumberModel(Settings.stopIterations, 1, 1000000000, 1));
    JCheckBox stopIfNotBetterResultFoundCheckBox = new JCheckBox("when no better result is found after given number of time or iterations", false);
    JComboBox languages = this.getLanguages();
    JButton ok = new JButton(Settings.resources.getString("button.ok"));
    JButton cancel = new JButton(Settings.resources.getString("button.cancel"));
    JButton apply = new JButton(Settings.resources.getString("button.apply"));

    public SettingsDialog() {
        super(Settings.mainDialog, "Settings", true);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.apply.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.ok);
        buttonPanel.add(this.cancel);
        buttonPanel.add(this.apply);
        JPanel packPanel = new JPanel();
        JPanel packRadioButtonPanel = new JPanel(new GridLayout(3, 1));
        JPanel limitPackTimePanel = new JPanel(new FlowLayout(0));
        JPanel limitPackIterationsPanel = new JPanel(new FlowLayout(0));
        ButtonGroup packRadioButtonGroup = new ButtonGroup();
        packRadioButtonPanel.setBorder(new TitledBorder("Stop"));
        packRadioButtonGroup.add(this.limitPackTimeRadioButton);
        this.limitPackTimeRadioButton.setSelected(Settings.stopCondition == 0);
        packRadioButtonGroup.add(this.limitPackIterationsRadioButton);
        this.limitPackIterationsRadioButton.setSelected(Settings.stopCondition == 1);
        limitPackTimePanel.add(this.limitPackTimeRadioButton);
        limitPackTimePanel.add(this.limitPackTimeSpinner);
        limitPackTimePanel.add(new JLabel("seconds"));
        packRadioButtonPanel.add(limitPackTimePanel);
        limitPackIterationsPanel.add(this.limitPackIterationsRadioButton);
        limitPackIterationsPanel.add(this.limitPackIterationsSpinner);
        limitPackIterationsPanel.add(new JLabel("iterations"));
        packRadioButtonPanel.add(limitPackIterationsPanel);
        packRadioButtonPanel.add(this.stopIfNotBetterResultFoundCheckBox);
        packPanel.add(packRadioButtonPanel);
        JPanel regionalPanel = new JPanel();
        JPanel regionalGridPanel = new JPanel(new GridLayout(1, 2));
        regionalGridPanel.add(new JLabel(Settings.resources.getString("label.language")));
        regionalGridPanel.add(this.languages);
        regionalPanel.add(regionalGridPanel);
        JPanel viewPanel = new JPanel();
        JPanel viewGridPanel = new JPanel(new GridLayout(1, 2));
        viewGridPanel.add(new JLabel("Show wireframe container"));
        viewPanel.add(viewGridPanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Pack", packPanel);
        tabbedPane.addTab("Regional settings", regionalPanel);
        tabbedPane.addTab("View", viewPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tabbedPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(500, 500);
        Dimension d = this.getToolkit().getScreenSize();
        this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancel) {
            this.dispose();
        } else {
            Settings.locale = this.locales[this.languages.getSelectedIndex()];
            Settings.stopCondition = this.limitPackTimeRadioButton.isSelected() ? 0 : 1;
            Settings.stopTime = ((Number)this.limitPackTimeSpinner.getValue()).intValue();
            Settings.stopIterations = ((Number)this.limitPackIterationsSpinner.getValue()).intValue();
            Settings.apply();
            if (e.getSource() == this.ok) {
                this.dispose();
            }
        }
    }

    protected JComboBox getLanguages() {
        Vector<String> languages = new Vector<String>();
        int selected = 0;
        int i = 0;
        while (i < this.locales.length) {
            languages.add(this.locales[i].getDisplayName());
            if (this.locales[i].equals(Settings.locale)) {
                selected = i;
            }
            ++i;
        }
        JComboBox comboBox = new JComboBox(languages);
        comboBox.setSelectedIndex(selected);
        return comboBox;
    }
}

