/*
 * Decompiled with CFR 0.152.
 */
package com.pkc.ui.dialogs;

import com.pkc.data.PackingDataSource;
import com.pkc.geom.RectObject;
import com.pkc.packing.PackingAlgorithm;
import com.pkc.settings.Settings;
import com.pkc.ui.component.ContainerPreviewPanel;
import com.pkc.ui.tables.PackingObjectTable;
import com.pkc.util.PackingTask;
import com.pkc.util.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;

public class PackDialog
extends JSplitPane
implements Runnable {
    long maxTime;
    int maxIterations;
    long volumeTotal;
    Object[][] stats = new Object[11][2];
    ContainerPreviewPanel packedPanel;
    JTable containersTable;
    JTable objectsTable;
    JTable statsTable;
    PackingTask packingTask;
    PackingAlgorithm packingAlgorithm;
    List loadedResult = new ArrayList();
    String title;
    public JSplitPane leftPanel = new JSplitPane(0);
    public JSplitPane rightPanel = new JSplitPane(0);

    public PackDialog(String title, PackingDataSource.PackingProblem problem) {
        super(1);
        this.setOneTouchExpandable(true);
        this.leftPanel.setOneTouchExpandable(true);
        this.rightPanel.setOneTouchExpandable(true);
        this.title = title;
        this.packingAlgorithm = new PackingAlgorithm(problem, new int[]{Settings.byDimmension, Settings.byVolume, Settings.byRatio, Settings.byMinMax, Settings.byRandom});
        this.stats[0][0] = "iteration";
        this.stats[1][0] = "time";
        this.stats[2][0] = "packed objects";
        this.stats[3][0] = "packed volume";
        this.stats[4][0] = "total object volume";
        this.stats[5][0] = "different objects types";
        this.stats[6][0] = "Max-Dimension";
        this.stats[7][0] = "Max-Value";
        this.stats[8][0] = "Max-Ratio";
        this.stats[9][0] = "Max-Min";
        this.stats[10][0] = "Monte-Carlo";
        JPanel statsPanel = new JPanel(new BorderLayout());
        JPanel resultPanel = new JPanel(new BorderLayout());
        this.rightPanel.setTopComponent(resultPanel);
        this.rightPanel.setBottomComponent(statsPanel);
        this.setLeftComponent(this.leftPanel);
        this.setRightComponent(this.rightPanel);
        RectObject container = (RectObject)problem.getContainers().get(0);
        this.packedPanel = new ContainerPreviewPanel(container.getMaxDim());
        this.volumeTotal = container.getVolume();
        this.stats[4][1] = new Long(this.packingAlgorithm.getObjectsVolume()) + " (" + Tools.percentFormat.format((double)this.packingAlgorithm.getObjectsVolume() / (double)this.volumeTotal) + ")";
        this.stats[5][1] = new Integer(problem.getClassCount());
        this.containersTable = new PackingObjectTable(problem.getContainers());
        JScrollPane scrollPane = new JScrollPane(this.containersTable);
        scrollPane.setBorder(new TitledBorder("Containers (" + problem.getContainers().size() + ")"));
        this.leftPanel.setTopComponent(scrollPane);
        this.objectsTable = new PackingObjectTable(problem.getObjects());
        scrollPane = new JScrollPane(this.objectsTable);
        scrollPane.setBorder(new TitledBorder("Objects to pack (" + problem.getObjects().size() + ")"));
        this.leftPanel.setBottomComponent(scrollPane);
        statsPanel.setBorder(new TitledBorder("Progress & Statistics"));
        this.statsTable = new JTable(this.stats, new Object[]{"Parameter", "Value"});
        statsPanel.add(new JScrollPane(this.statsTable));
        this.packedPanel.setBorder(new TitledBorder("Packed container"));
        resultPanel.add((Component)this.packedPanel, "Center");
        this.packingTask = new PackingTask(this);
        int i = 0;
        while (i < this.packingAlgorithm.getProblem().getObjects().size()) {
            RectObject object = (RectObject)this.packingAlgorithm.getProblem().getObjects().get(i);
            if (object.getStart(0) != Integer.MIN_VALUE) {
                this.loadedResult.add(object);
            }
            ++i;
        }
        this.setVisible(true);
    }

    public void startPacking() {
        this.maxTime = this.packingTask.getRunTime() + (long)(Settings.stopTime * 1000);
        this.maxIterations = this.packingTask.getIteration() + Settings.stopIterations;
        long value = this.packingAlgorithm.packGreedy(this.packingAlgorithm.chooseObjectByGivenDimCriterion);
        this.stats[6][1] = String.valueOf(value) + " of " + this.volumeTotal + " (" + Tools.percentFormat.format((double)value / (double)this.volumeTotal) + ")";
        value = this.packingAlgorithm.packGreedy(this.packingAlgorithm.chooseLargestVolumeObjectCriterion);
        this.stats[7][1] = String.valueOf(value) + " of " + this.volumeTotal + " (" + Tools.percentFormat.format((double)value / (double)this.volumeTotal) + ")";
        value = this.packingAlgorithm.packGreedy(this.packingAlgorithm.chooseMaxRatioObjectCriterion);
        this.stats[8][1] = String.valueOf(value) + " of " + this.volumeTotal + " (" + Tools.percentFormat.format((double)value / (double)this.volumeTotal) + ")";
        value = this.packingAlgorithm.packGreedy(this.packingAlgorithm.chooseMaxMinObjectCriterion);
        this.stats[9][1] = String.valueOf(value) + " of " + this.volumeTotal + " (" + Tools.percentFormat.format((double)value / (double)this.volumeTotal) + ")";
        value = this.packingAlgorithm.packGreedy(this.packingAlgorithm.chooseRandomObjectCriterion);
        this.stats[10][1] = String.valueOf(value) + " of " + this.volumeTotal + " (" + Tools.percentFormat.format((double)value / (double)this.volumeTotal) + ")";
        this.updateStatus();
        this.packingTask.setStopped(false);
    }

    public void stopPacking() {
        this.packingTask.setStopped(true);
        this.packedPanel.initialize((RectObject)this.packingAlgorithm.getProblem().getContainers().get(0), this.packingAlgorithm.getBestPacking());
        this.updateStatus();
        Rectangle oldBounds = this.getBounds();
        Rectangle newBounds = this.getBounds();
        newBounds.setSize(newBounds.getSize().width, newBounds.getSize().height - 1);
        this.setBounds(newBounds);
        this.setBounds(oldBounds);
    }

    protected void updateStatus() {
        long volumePacked = 0L;
        int i = 0;
        while (i < this.packingAlgorithm.getBestPacking().size()) {
            RectObject o = (RectObject)this.packingAlgorithm.getBestPacking().get(i);
            volumePacked += o.getVolume();
            ++i;
        }
        this.stats[0][1] = new Integer(this.packingTask.getIteration());
        this.stats[1][1] = String.valueOf(Tools.flonumFormat.format((double)this.packingTask.getRunTime() / 1000.0)) + " seconds";
        this.stats[2][1] = String.valueOf(this.packingAlgorithm.getBestPacking().size()) + " of " + this.packingAlgorithm.getProblem().getObjects().size() + " (" + Tools.percentFormat.format((double)this.packingAlgorithm.getBestPacking().size() / (double)this.packingAlgorithm.getProblem().getObjects().size()) + ")";
        this.stats[3][1] = String.valueOf(volumePacked) + " of " + this.volumeTotal + " (" + Tools.percentFormat.format((double)volumePacked / (double)this.volumeTotal) + ")";
        ((AbstractTableModel)this.statsTable.getModel()).fireTableDataChanged();
    }

    @Override
    public String toString() {
        return this.title;
    }

    @Override
    public void run() {
        this.updateStatus();
        this.packingAlgorithm.layerChooserByObjDims.reset();
        this.packingAlgorithm.packUsingLayers(this.packingAlgorithm.layerChooserByObjDims, 1000);
        if (Settings.stopCondition == 0 && this.packingTask.getRunTime() >= this.maxTime || Settings.stopCondition == 1 && this.packingTask.getIteration() >= this.maxIterations || this.packingAlgorithm.getBestPacking().size() == this.packingAlgorithm.getProblem().getObjects().size() || this.packingAlgorithm.getBestValue() == this.volumeTotal) {
            this.stopPacking();
        }
        this.updateStatus();
    }
}

