/*
 * Decompiled with CFR 0.152.
 */
package com.pkc.ui.dialogs;

import com.pkc.data.PackingDataSource;
import com.pkc.settings.Settings;
import com.pkc.ui.dialogs.PackDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NewDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    JPanel centerPanel = new JPanel(new BorderLayout());
    JButton back = new JButton(Settings.resources.getString("button.back"));
    JButton next = new JButton(Settings.resources.getString("button.next"));
    JButton finish = new JButton(Settings.resources.getString("button.finish"));
    JButton cancel = new JButton(Settings.resources.getString("button.cancel"));
    JList sourceList;
    Component firstPage;
    protected int index = 0;
    protected List pages = new ArrayList();

    public NewDialog() {
        super(Settings.mainDialog, "New", true);
        this.back.addActionListener(this);
        this.next.addActionListener(this);
        this.finish.addActionListener(this);
        this.cancel.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.back);
        buttonPanel.add(this.next);
        buttonPanel.add(this.finish);
        buttonPanel.add(this.cancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.firstPage = this.generateFirstPage();
        this.pages.add(this.firstPage);
        this.showHideComponents();
        this.setSize(600, 400);
        Dimension d = this.getToolkit().getScreenSize();
        this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    protected void showHideComponents() {
        this.back.setVisible(this.index != 0);
        this.next.setVisible(this.index < this.pages.size() - 1);
        this.finish.setVisible(this.index == this.pages.size() - 1 && this.sourceList.getSelectedValue() != null);
        this.centerPanel.removeAll();
        this.centerPanel.add((Component)this.pages.get(this.index));
        this.getContentPane().repaint();
    }

    protected Component generateFirstPage() {
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.setBorder(new TitledBorder("Data sources"));
        this.sourceList = new JList(new Vector(Settings.dataSources));
        this.sourceList.setSelectionMode(0);
        this.sourceList.addListSelectionListener(this);
        listPanel.add((Component)new JScrollPane(this.sourceList), "Center");
        this.sourceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NewDialog.this.handleNext();
                }
            }
        });
        return listPanel;
    }

    protected void handleNext() {
        if (this.index != this.pages.size() - 1) {
            ++this.index;
            this.showHideComponents();
        } else {
            PackingDataSource dataSource = (PackingDataSource)this.sourceList.getSelectedValue();
            try {
                dataSource.validateConfig();
                Settings.mainDialog.newPacking(new PackDialog(dataSource.getTitle(), (PackingDataSource.PackingProblem)Settings.problems.get(0)));
                this.dispose();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancel) {
            this.dispose();
        } else if (e.getSource() == this.back) {
            if (this.index != 0) {
                --this.index;
                this.showHideComponents();
            }
        } else if (e.getSource() == this.next) {
            this.handleNext();
        } else if (e.getSource() == this.finish) {
            this.handleNext();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        List nextPages;
        this.pages.clear();
        this.pages.add(this.firstPage);
        if (this.sourceList.getSelectedValue() != null && (nextPages = ((PackingDataSource)this.sourceList.getSelectedValue()).getConfigPages()) != null) {
            this.pages.addAll(nextPages);
        }
        this.showHideComponents();
    }
}

